/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.CallReferenceHighlighter;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.HighlightingKt;
import org.jetbrains.plugins.groovy.codeInspection.type.highlighting.MethodCallReferenceHighlighter$WhenMappings;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.requests.CreateMethodFromUsageKt;
import org.jetbrains.plugins.groovy.highlighting.HighlightSink;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;
import org.jetbrains.plugins.groovy.lang.typing.TypeUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\"\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00160\fj\u0002`\u0017H\u0002J(\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00160\fj\u0002`\u0017H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/MethodCallReferenceHighlighter;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/highlighting/CallReferenceHighlighter;", "methodReference", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReference;", "highlightElement", "Lcom/intellij/psi/PsiElement;", "sink", "Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/api/GroovyMethodCallReference;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/plugins/groovy/highlighting/HighlightSink;)V", "getHighlightElement", "()Lcom/intellij/psi/PsiElement;", "buildFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "highlightApplicable", "", "result", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyMethodResult;", "highlightClosureCall", "receiver", "Lorg/jetbrains/plugins/groovy/lang/typing/GroovyClosureType;", "arguments", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "highlightClosureInvocation", "results", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "intellij.groovy.psi"})
public final class MethodCallReferenceHighlighter
extends CallReferenceHighlighter {
    private final GroovyMethodCallReference methodReference;
    @NotNull
    private final PsiElement highlightElement;

    @Override
    protected boolean highlightClosureInvocation(@NotNull Collection<? extends GroovyResolveResult> results, @NotNull List<? extends Argument> arguments2) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Collection<? extends GroovyResolveResult> collection = results;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        GroovyResolveResult groovyResolveResult = (GroovyResolveResult)CollectionsKt.singleOrNull((Iterable)results);
        if (groovyResolveResult == null) {
            return false;
        }
        GroovyResolveResult result2 = groovyResolveResult;
        if (!result2.isInvokedOnProperty()) {
            return false;
        }
        PsiType propertyType = TypeUtils.getReadPropertyType(result2);
        if (!(propertyType instanceof GroovyClosureType)) {
            this.highlightCannotApplyError(this.methodReference.getMethodName(), HighlightingKt.argumentsString(arguments2));
            return true;
        }
        return this.highlightClosureCall((GroovyClosureType)propertyType, arguments2);
    }

    @Override
    protected boolean highlightApplicable(@NotNull GroovyMethodResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        GroovyMethodCandidate groovyMethodCandidate = result2.getCandidate();
        if (groovyMethodCandidate == null) {
            return false;
        }
        GroovyMethodCandidate candidate = groovyMethodCandidate;
        if (!PsiUtilKt.isClosureCall(candidate.getMethod())) {
            return false;
        }
        PsiType psiType = candidate.getReceiverType();
        if (!(psiType instanceof GroovyClosureType)) {
            psiType = null;
        }
        GroovyClosureType groovyClosureType = (GroovyClosureType)psiType;
        if (groovyClosureType == null) {
            return false;
        }
        GroovyClosureType receiver = groovyClosureType;
        ArgumentMapping<PsiCallParameter> argumentMapping2 = candidate.getArgumentMapping();
        if (argumentMapping2 == null || (argumentMapping2 = argumentMapping2.getArguments()) == null) {
            return false;
        }
        ArgumentMapping<PsiCallParameter> arguments2 = argumentMapping2;
        return this.highlightClosureCall(receiver, (List<? extends Argument>)((Object)arguments2));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean highlightClosureCall(GroovyClosureType receiver, List<? extends Argument> arguments2) {
        Applicability applicability;
        Collection<ArgumentMapping<?>> mappings = receiver.applyTo(arguments2);
        if (mappings.isEmpty()) {
            applicability = Applicability.inapplicable;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = mappings;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ArgumentMapping argumentMapping2 = (ArgumentMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Applicability applicability2 = it.applicability();
                collection.add(applicability2);
            }
            Applicability applicability3 = Applicability.totalApplicability((List)destination$iv$iv);
            applicability = applicability3;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)applicability3), (String)"totalApplicability(mappi\u2026.applicability()\n      })");
        }
        Applicability totalApplicability = applicability;
        switch (MethodCallReferenceHighlighter$WhenMappings.$EnumSwitchMapping$0[totalApplicability.ordinal()]) {
            case 1: {
                this.highlightCannotApplyError("call", HighlightingKt.argumentsString(arguments2));
                return true;
            }
            case 2: {
                if (mappings.size() <= 1) break;
                this.highlightUnknownArgs();
                return true;
            }
            case 3: {
                if (mappings.size() <= 1) break;
                this.highlightAmbiguousMethod();
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    protected List<LocalQuickFix> buildFixes() {
        PsiElement psiElement = this.methodReference.getElement();
        if (!(psiElement instanceof GrMethodCall)) {
            psiElement = null;
        }
        GrMethodCall grMethodCall = (GrMethodCall)psiElement;
        if (grMethodCall == null) {
            return CollectionsKt.emptyList();
        }
        GrMethodCall call = grMethodCall;
        List<IntentionAction> actions = CreateMethodFromUsageKt.generateCreateMethodActions(call);
        List list = IntentionWrapper.wrapToQuickFixes(actions, (PsiFile)call.getContainingFile());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"IntentionWrapper.wrapToQ\u2026ons, call.containingFile)");
        return list;
    }

    @Override
    @NotNull
    protected PsiElement getHighlightElement() {
        return this.highlightElement;
    }

    public MethodCallReferenceHighlighter(@NotNull GroovyMethodCallReference methodReference, @NotNull PsiElement highlightElement, @NotNull HighlightSink sink) {
        Intrinsics.checkNotNullParameter((Object)methodReference, (String)"methodReference");
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super(methodReference, sink);
        this.methodReference = methodReference;
        this.highlightElement = highlightElement;
    }
}

