/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.template.expressions.ChooseTypeExpression;

public class GrSetStrongTypeIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance(GrSetStrongTypeIntention.class);

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, final Editor editor) throws IncorrectOperationException {
        PsiElement elementToBuildTemplate;
        GrVariable[] variables;
        PsiElement parent2;
        if (element == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(1);
        }
        if ((parent2 = element.getParent()) instanceof GrVariable && parent2.getParent() instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent2.getParent()).getVariables();
            elementToBuildTemplate = parent2.getParent();
        } else if (parent2 instanceof GrVariable && parent2.getParent() instanceof GrForInClause) {
            variables = new GrVariable[]{(GrVariable)parent2};
            elementToBuildTemplate = parent2.getParent().getParent();
        } else if (parent2 instanceof GrVariableDeclaration) {
            variables = ((GrVariableDeclaration)parent2).getVariables();
            elementToBuildTemplate = parent2;
        } else if (parent2 instanceof GrParameter && parent2.getParent() instanceof GrParameterList) {
            variables = new GrVariable[]{(GrVariable)parent2};
            elementToBuildTemplate = parent2.getParent().getParent();
        } else if (parent2 instanceof GrVariable) {
            variables = new GrVariable[]{(GrVariable)parent2};
            elementToBuildTemplate = parent2;
        } else {
            return;
        }
        ArrayList<SupertypeConstraint> types = new ArrayList<SupertypeConstraint>();
        if (parent2.getParent() instanceof GrForInClause) {
            types.add(SupertypeConstraint.create(PsiUtil.extractIteratedType((GrForInClause)parent2.getParent())));
        } else {
            for (GrVariable variable : variables) {
                PsiParameter parameter;
                PsiType type2;
                PsiType type3;
                GrExpression initializer = variable.getInitializerGroovy();
                if (initializer != null && (type3 = initializer.getType()) != null) {
                    types.add(SupertypeConstraint.create(type3));
                }
                if (!(variable instanceof GrParameter) || (type2 = GrSetStrongTypeIntention.getClosureParameterType(parameter = (PsiParameter)variable)) == null) continue;
                types.add(SupertypeConstraint.create(type2));
            }
        }
        final String originalText = elementToBuildTemplate.getText();
        final TypeInfo typeInfo = GrSetStrongTypeIntention.getOrCreateTypeElement(parent2, elementToBuildTemplate);
        PsiElement replaceElement = typeInfo.elementToReplace;
        TypeConstraint[] constraints = types.toArray(TypeConstraint.EMPTY_ARRAY);
        ChooseTypeExpression chooseTypeExpression = new ChooseTypeExpression(constraints, element.getManager(), replaceElement.getResolveScope());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(elementToBuildTemplate);
        builder.replaceElement(replaceElement, (Expression)chooseTypeExpression);
        final Document document = editor.getDocument();
        final RangeMarker rangeMarker = document.createRangeMarker(elementToBuildTemplate.getTextRange());
        rangeMarker.setGreedyToRight(true);
        rangeMarker.setGreedyToLeft(true);
        PsiElement afterPostprocess = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)elementToBuildTemplate);
        Template template = builder.buildTemplate();
        TextRange range = afterPostprocess.getTextRange();
        document.deleteString(range.getStartOffset(), range.getEndOffset());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (rangeMarker.isValid()) {
                            document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)originalText);
                            editor.getCaretModel().moveToOffset(rangeMarker.getStartOffset() + typeInfo2.originalOffset);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention$1", "templateFinished"));
            }
        });
    }

    @Nullable
    private static PsiType getClosureParameterType(@NotNull PsiParameter parameter) {
        PsiElement scope;
        if (parameter == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(2);
        }
        PsiType type2 = (scope = parameter.getDeclarationScope()) instanceof GrClosableBlock ? ClosureParameterEnhancer.inferType((GrClosableBlock)scope, ((GrParameterList)parameter.getParent()).getParameterIndex(parameter)) : null;
        return type2;
    }

    @NotNull
    private static TypeInfo getOrCreateTypeElement(@NotNull PsiElement parent2, @NotNull PsiElement elementToBuildTemplateOn) {
        int nameElementOffset;
        GrModifierList modifierList;
        if (parent2 == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(3);
        }
        if (elementToBuildTemplateOn == null) {
            GrSetStrongTypeIntention.$$$reportNull$$$0(4);
        }
        if ((modifierList = GrSetStrongTypeIntention.getModifierList(parent2)) != null && modifierList.hasModifierProperty("def") && modifierList.getModifiers().length == 1) {
            PsiElement modifier = modifierList.getModifier("def");
            LOG.assertTrue(modifier != null);
            int modifierOffset = modifier.getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
            return new TypeInfo(modifier, modifierOffset);
        }
        PsiClassType typeToUse = TypesUtil.createType("Abc", parent2);
        if (elementToBuildTemplateOn instanceof GrVariableDeclaration) {
            GrVariableDeclaration decl = (GrVariableDeclaration)elementToBuildTemplateOn;
            decl.setType((PsiType)typeToUse);
            nameElementOffset = decl.getModifierList().getTextRange().getEndOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        } else {
            GrVariable var = (GrVariable)parent2;
            var.setType((PsiType)typeToUse);
            nameElementOffset = var.getNameIdentifierGroovy().getTextRange().getStartOffset() - elementToBuildTemplateOn.getTextRange().getStartOffset();
        }
        return new TypeInfo(GrSetStrongTypeIntention.getTypeElement(parent2), nameElementOffset);
    }

    @Nullable
    private static GrTypeElement getTypeElement(PsiElement parent2) {
        if (parent2 instanceof GrVariable) {
            return ((GrVariable)parent2).getTypeElementGroovy();
        }
        return ((GrVariableDeclaration)parent2).getTypeElementGroovy();
    }

    @Nullable
    private static GrModifierList getModifierList(PsiElement parent2) {
        GrModifierList modifierList = parent2 instanceof GrVariable ? ((GrVariable)parent2).getModifierList() : ((GrVariableDeclaration)parent2).getModifierList();
        return modifierList;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(@NotNull PsiElement element) {
                PsiElement pparent;
                PsiElement parent2;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.isNameIdentifierOfVariable(element, parent2 = element.getParent()) || this.isModifierListOfVar(element, parent2)) {
                    pparent = parent2.getParent();
                } else if (this.isModifierListOfVarDecl(element, parent2)) {
                    pparent = parent2;
                } else {
                    return false;
                }
                if (pparent instanceof GrVariableDeclaration) {
                    GrVariable[] variables;
                    if (((GrVariableDeclaration)pparent).getTypeElementGroovy() != null) {
                        return false;
                    }
                    for (GrVariable variable : variables = ((GrVariableDeclaration)pparent).getVariables()) {
                        if (!GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable)) continue;
                        return true;
                    }
                } else {
                    if (pparent instanceof GrForInClause) {
                        GrVariable variable = ((GrForInClause)pparent).getDeclaredVariable();
                        return variable != null && variable.getTypeElementGroovy() == null && PsiUtil.extractIteratedType((GrForInClause)pparent) != null;
                    }
                    if (parent2 instanceof GrParameter && pparent instanceof GrParameterList) {
                        return ((GrParameter)parent2).getTypeElementGroovy() == null && GrSetStrongTypeIntention.getClosureParameterType((PsiParameter)parent2) != null;
                    }
                    GrVariable variable = (GrVariable)parent2;
                    return variable.getTypeElementGroovy() == null && GrSetStrongTypeIntention.isVarDeclaredWithInitializer(variable);
                }
                return false;
            }

            private boolean isModifierListOfVarDecl(PsiElement element, PsiElement parent2) {
                return parent2 instanceof GrVariableDeclaration && ((GrVariableDeclaration)parent2).getModifierList() == element;
            }

            private boolean isModifierListOfVar(PsiElement element, PsiElement parent2) {
                return parent2 instanceof GrVariable && ((GrVariable)parent2).getModifierList() == element;
            }

            private boolean isNameIdentifierOfVariable(PsiElement element, PsiElement parent2) {
                return parent2 instanceof GrVariable && ((GrVariable)parent2).getTypeElementGroovy() == null && element == ((GrVariable)parent2).getNameIdentifierGroovy();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention$2", "satisfiedBy"));
            }
        };
    }

    private static boolean isVarDeclaredWithInitializer(GrVariable variable) {
        GrExpression initializer = variable.getInitializerGroovy();
        return initializer != null && initializer.getType() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToBuildTemplateOn";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/intentions/declaration/GrSetStrongTypeIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getClosureParameterType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateTypeElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TypeInfo {
        final PsiElement elementToReplace;
        final int originalOffset;

        TypeInfo(PsiElement element, int offset) {
            this.originalOffset = offset;
            this.elementToReplace = element;
        }
    }
}

