/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.completion.CompleteCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.completion.CompleteReferenceExpression;
import org.jetbrains.plugins.groovy.lang.completion.GroovyClassNameInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.types.GrCodeReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ReferencesKt;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyProperty;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ConstructorsKt;

public final class GroovyCompletionUtil {
    private static final TokenSet SEPARATORS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mNLS, GroovyTokenTypes.mSEMI});

    private GroovyCompletionUtil() {
    }

    public static boolean endsWithExpression(PsiElement statement) {
        while (statement != null && !(statement instanceof GrExpression)) {
            if (!((statement = statement.getLastChild()) instanceof PsiErrorElement)) continue;
            statement = GroovyCompletionUtil.nearestLeftSibling(statement);
        }
        return statement != null;
    }

    @Nullable
    public static PsiElement nearestLeftSibling(PsiElement elem) {
        for (elem = elem.getPrevSibling(); elem != null && (elem instanceof PsiWhiteSpace || elem instanceof PsiComment || GroovyTokenTypes.mNLS.equals(elem.getNode().getElementType())); elem = elem.getPrevSibling()) {
        }
        return elem;
    }

    @Nullable
    public static PsiElement nearestLeftLeaf(PsiElement elem) {
        elem = PsiTreeUtil.prevLeaf((PsiElement)elem);
        while (elem != null && (elem instanceof PsiWhiteSpace || elem instanceof PsiComment || GroovyTokenTypes.mNLS.equals(elem.getNode().getElementType()))) {
            elem = PsiTreeUtil.prevLeaf((PsiElement)elem);
        }
        return elem;
    }

    public static boolean isNewStatement(PsiElement element, boolean canBeAfterBrace) {
        PsiElement previousLeaf = GroovyCompletionUtil.getLeafByOffset(element.getTextRange().getStartOffset() - 1, element);
        if ((previousLeaf = PsiImplUtil.realPrevious(previousLeaf)) != null) {
            if (canBeAfterBrace && GroovyTokenTypes.mLCURLY.equals(previousLeaf.getNode().getElementType())) {
                return true;
            }
            if (GroovyTokenTypes.mCOLON.equals(previousLeaf.getNode().getElementType()) && previousLeaf.getParent() instanceof GrLabeledStatement) {
                return true;
            }
        }
        return previousLeaf == null || SEPARATORS.contains(previousLeaf.getNode().getElementType());
    }

    @Nullable
    public static PsiElement getLeafByOffset(int offset, PsiElement element) {
        if (offset < 0) {
            return null;
        }
        PsiFile candidate = element.getContainingFile();
        while (candidate.getNode().getFirstChildNode() != null) {
            candidate = candidate.findElementAt(offset);
        }
        return candidate;
    }

    public static boolean isFirstElementAfterPossibleModifiersInVariableDeclaration(PsiElement element, boolean acceptParameter) {
        if (element.getParent() instanceof GrTypeDefinitionBody && !(element instanceof PsiComment)) {
            String text = element.getContainingFile().getText();
            int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(element.getTextRange().getStartOffset() - 1), (String)" \t");
            return i >= 0 && (text.charAt(i) == '\n' || text.charAt(i) == '{');
        }
        PsiElement parent2 = element.getParent();
        if (!(parent2 instanceof GrVariable)) {
            return false;
        }
        if (acceptParameter && parent2 instanceof GrParameter) {
            return ((GrParameter)parent2).getTypeElementGroovy() == null;
        }
        PsiElement pparent = parent2.getParent();
        if (!(pparent instanceof GrVariableDeclaration)) {
            return false;
        }
        if (((GrVariableDeclaration)pparent).isTuple()) {
            return false;
        }
        GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)pparent;
        if (variableDeclaration.getTypeElementGroovy() != null) {
            return false;
        }
        return variableDeclaration.getVariables()[0] == parent2;
    }

    public static boolean asSimpleVariable(PsiElement context) {
        return GroovyCompletionUtil.isInTypeDefinitionBody(context) && GroovyCompletionUtil.isNewStatement(context, true);
    }

    public static boolean isInTypeDefinitionBody(PsiElement context) {
        return context.getParent() instanceof GrCodeReferenceElement && context.getParent().getParent() instanceof GrClassTypeElement && context.getParent().getParent().getParent() instanceof GrTypeDefinitionBody || context.getParent() instanceof GrTypeDefinitionBody;
    }

    public static boolean asVariableInBlock(PsiElement context) {
        if (context.getParent() instanceof GrReferenceExpression) {
            PsiElement parent2 = context.getParent().getParent();
            while (parent2 instanceof GrStatement) {
                parent2 = parent2.getParent();
            }
            if ((parent2 instanceof GrControlFlowOwner || parent2 instanceof GrCaseSection) && GroovyCompletionUtil.isNewStatement(context, true)) {
                return true;
            }
        }
        return context.getParent() instanceof GrTypeDefinitionBody && GroovyCompletionUtil.isNewStatement(context, true);
    }

    public static boolean asTypedMethod(PsiElement context) {
        return context.getParent() instanceof GrReferenceElement && context.getParent().getParent() instanceof GrTypeElement && context.getParent().getParent().getParent() instanceof GrMethod && context.getParent().getParent().getParent().getParent() instanceof GrTypeDefinitionBody && context.getTextRange().getStartOffset() == context.getParent().getParent().getParent().getParent().getTextRange().getStartOffset();
    }

    public static List<LookupElement> getCompletionVariants(GroovyResolveResult[] candidates, boolean afterNew, PrefixMatcher matcher, PsiElement position) {
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        for (GroovyResolveResult candidate : candidates) {
            result2.addAll(GroovyCompletionUtil.createLookupElements(candidate, afterNew, matcher, position));
            ProgressManager.checkCanceled();
        }
        return result2;
    }

    public static List<LookupElement> getCompletionVariants(List<? extends GroovyResolveResult> candidates, boolean afterNew, PrefixMatcher matcher, PsiElement position) {
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        for (GroovyResolveResult groovyResolveResult : candidates) {
            result2.addAll(GroovyCompletionUtil.createLookupElements(groovyResolveResult, afterNew, matcher, position));
            ProgressManager.checkCanceled();
        }
        return result2;
    }

    public static List<? extends LookupElement> createLookupElements(@NotNull GroovyResolveResult candidate, boolean afterNew, @NotNull PrefixMatcher matcher, @Nullable PsiElement position) {
        String name;
        if (candidate == null) {
            GroovyCompletionUtil.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            GroovyCompletionUtil.$$$reportNull$$$0(1);
        }
        PsiElement element = candidate.getElement();
        PsiElement context = candidate.getCurrentFileResolveContext();
        if (context instanceof GrImportStatement && element != null) {
            if (element instanceof PsiPackage) {
                return Collections.emptyList();
            }
            String importedName = ((GrImportStatement)context).getImportedName();
            if (importedName != null) {
                if (!(matcher.prefixMatches(importedName) || element instanceof PsiMethod && GroovyCompletionUtil.getterMatches(matcher, (PsiMethod)element, importedName) || element instanceof PsiMethod && GroovyCompletionUtil.setterMatches(matcher, (PsiMethod)element, importedName))) {
                    return Collections.emptyList();
                }
                GrCodeReferenceElement importReference = ((GrImportStatement)context).getImportReference();
                if (importReference != null) {
                    boolean alias = ((GrImportStatement)context).isAliasedImport();
                    for (GroovyResolveResult r : importReference.multiResolve(false)) {
                        PsiElement resolved = r.getElement();
                        if (context.getManager().areElementsEquivalent(resolved, element) && (alias || !(element instanceof PsiClass))) {
                            return GroovyCompletionUtil.generateLookupForImportedElement(candidate, importedName);
                        }
                        if (!(resolved instanceof PsiField) || !(element instanceof PsiMethod) || !GroovyPropertyUtils.isAccessorFor((PsiMethod)element, (PsiField)resolved)) continue;
                        return GroovyCompletionUtil.generateLookupForImportedElement(candidate, GroovyPropertyUtils.getAccessorPrefix((PsiMethod)element) + GroovyPropertyUtils.capitalize(importedName));
                    }
                }
            }
        }
        String string = name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : element.getText();
        if (name == null || !matcher.prefixMatches(name)) {
            return Collections.emptyList();
        }
        if (element instanceof PsiClass) {
            return JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)((PsiClass)element), (boolean)afterNew, (InsertHandler)new GroovyClassNameInsertHandler(), (Condition)Conditions.alwaysTrue());
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)(element instanceof PsiPackage ? element : candidate), (String)name);
        return Collections.singletonList(GroovyCompletionUtil.setupLookupBuilder(element, candidate.getSubstitutor(), builder, position));
    }

    private static boolean setterMatches(PrefixMatcher matcher, PsiMethod element, String importedName) {
        return GroovyPropertyUtils.isSimplePropertySetter(element) && matcher.prefixMatches(GroovyPropertyUtils.getSetterName(importedName));
    }

    private static boolean getterMatches(PrefixMatcher matcher, PsiMethod element, String importedName) {
        return GroovyPropertyUtils.isSimplePropertyGetter(element) && (matcher.prefixMatches(GroovyPropertyUtils.getGetterNameNonBoolean(importedName)) || PsiType.BOOLEAN.equals((Object)element.getReturnType()) && matcher.prefixMatches(GroovyPropertyUtils.getGetterNameBoolean(importedName)));
    }

    public static LookupElement createClassLookupItem(PsiClass psiClass) {
        assert (psiClass.isValid());
        return AllClassesGetter.createLookupItem((PsiClass)psiClass, (InsertHandler)new GroovyClassNameInsertHandler());
    }

    private static List<? extends LookupElement> generateLookupForImportedElement(GroovyResolveResult resolveResult2, String importedName) {
        PsiElement element = resolveResult2.getElement();
        assert (element != null);
        PsiSubstitutor substitutor = resolveResult2.getSubstitutor();
        LookupElementBuilder builder = LookupElementBuilder.create((Object)resolveResult2, (String)importedName).withPresentableText(importedName);
        return Collections.singletonList(GroovyCompletionUtil.setupLookupBuilder(element, substitutor, builder, null));
    }

    public static LookupElement createLookupElement(PsiNamedElement o) {
        return GroovyCompletionUtil.setupLookupBuilder((PsiElement)o, PsiSubstitutor.EMPTY, LookupElementBuilder.create((Object)o, (String)o.getName()), null);
    }

    public static LookupElement setupLookupBuilder(PsiElement element, PsiSubstitutor substitutor, LookupElementBuilder builder, @Nullable PsiElement position) {
        builder = builder.withIcon(element.getIcon(3)).withInsertHandler((InsertHandler)GroovyInsertHandler.INSTANCE);
        builder = GroovyCompletionUtil.setTailText(element, builder, substitutor);
        builder = GroovyCompletionUtil.setTypeText(element, builder, substitutor, position);
        return builder;
    }

    private static LookupElementBuilder setTailText(PsiElement element, LookupElementBuilder builder, PsiSubstitutor substitutor) {
        if (element instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)element).getContainingClass();
            if (aClass != null && aClass.isAnnotationType()) {
                return builder;
            }
            builder = builder.withTailText(PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)substitutor, (int)256, (int)3));
        } else if (element instanceof PsiClass) {
            Object tailText = GroovyCompletionUtil.getPackageText((PsiClass)element);
            PsiClass psiClass = (PsiClass)element;
            if ((substitutor == null || substitutor.getSubstitutionMap().isEmpty()) && psiClass.getTypeParameters().length > 0) {
                tailText = "<" + StringUtil.join((Object[])psiClass.getTypeParameters(), psiTypeParameter -> psiTypeParameter.getName(), (String)("," + (GroovyCompletionUtil.showSpaceAfterComma(psiClass) ? " " : ""))) + ">" + (String)tailText;
            }
            builder = builder.withTailText((String)tailText, true);
        }
        return builder;
    }

    private static String getPackageText(PsiClass psiClass) {
        @NonNls String packageName = PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass);
        return " (" + packageName + ")";
    }

    private static boolean showSpaceAfterComma(PsiClass element) {
        return CodeStyle.getLanguageSettings((PsiFile)element.getContainingFile(), (Language)GroovyLanguage.INSTANCE).SPACE_AFTER_COMMA;
    }

    private static LookupElementBuilder setTypeText(PsiElement element, LookupElementBuilder builder, PsiSubstitutor substitutor, @Nullable PsiElement position) {
        PsiType type2 = null;
        if (element instanceof GrVariable) {
            type2 = TypeInferenceHelper.getVariableTypeInContext(position, (GrVariable)element);
        } else if (element instanceof PsiVariable) {
            type2 = ((PsiVariable)element).getType();
        } else if (element instanceof PsiMethod) {
            type2 = substitutor.substitute(((PsiMethod)element).getReturnType());
        } else if (element instanceof GroovyProperty) {
            type2 = ((GroovyProperty)element).getPropertyType();
        }
        return type2 != null ? builder.withTypeText(type2.getPresentableText()) : builder;
    }

    public static boolean hasConstructorParameters(@NotNull PsiClass clazz, @NotNull PsiElement place) {
        if (clazz == null) {
            GroovyCompletionUtil.$$$reportNull$$$0(2);
        }
        if (place == null) {
            GroovyCompletionUtil.$$$reportNull$$$0(3);
        }
        List<PsiMethod> constructors = ConstructorsKt.getAllConstructors(clazz, place);
        SmartList accessibleParameterlessConstructors = new SmartList();
        SmartList inaccessibleConstructors = new SmartList();
        for (PsiMethod constructor2 : constructors) {
            if (PsiUtil.isAccessible(place, (PsiMember)constructor2)) {
                if (constructor2.hasParameters()) {
                    return true;
                }
                accessibleParameterlessConstructors.add(constructor2);
                continue;
            }
            inaccessibleConstructors.add(constructor2);
        }
        return accessibleParameterlessConstructors.isEmpty() && (ContainerUtil.or((Iterable)inaccessibleConstructors, constructor -> constructor.hasParameters()) || ContainerUtil.or((Object[])clazz.getAllMethods(), method -> GroovyPropertyUtils.isSimplePropertySetter(method)));
    }

    public static void addImportForItem(PsiFile file, int startOffset, LookupElement item) throws IncorrectOperationException {
        PsiClass refClass;
        PsiType type2;
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        Object o = item.getObject();
        if (o instanceof PsiClass) {
            PsiClass aClass = (PsiClass)o;
            if (aClass.getQualifiedName() == null) {
                return;
            }
            String lookupString = item.getLookupString();
            int length = lookupString.length();
            int i = lookupString.indexOf(60);
            if (i >= 0) {
                length = i;
            }
            int newOffset = GroovyCompletionUtil.addImportForClass(file, startOffset, startOffset + length, aClass);
            GroovyCompletionUtil.shortenReference(file, newOffset);
        } else if (o instanceof PsiType && (type2 = ((PsiType)o).getDeepComponentType()) instanceof PsiClassType && (refClass = ((PsiClassType)type2).resolve()) != null) {
            int length = refClass.getName().length();
            GroovyCompletionUtil.addImportForClass(file, startOffset, startOffset + length, refClass);
        }
    }

    public static int addImportForClass(PsiFile file, int startOffset, int endOffset, PsiClass aClass) throws IncorrectOperationException {
        PsiElement resolved;
        PsiManager manager = file.getManager();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        int newStartOffset = startOffset;
        PsiReference reference = file.findReferenceAt(endOffset - 1);
        if (reference != null && (resolved = reference.resolve()) instanceof PsiClass && (((PsiClass)resolved).getQualifiedName() == null || manager.areElementsEquivalent((PsiElement)aClass, resolved))) {
            return newStartOffset;
        }
        String name = aClass.getName();
        document.replaceString(startOffset, endOffset, (CharSequence)name);
        RangeMarker toDelete = JavaCompletionUtil.insertTemporary((int)endOffset, (Document)document, (String)" ");
        PsiDocumentManager.getInstance((Project)manager.getProject()).commitAllDocuments();
        PsiReference ref = file.findReferenceAt(startOffset);
        if (ref instanceof GrReferenceElement && aClass.isValid()) {
            PsiElement newElement = ref.bindToElement((PsiElement)aClass);
            RangeMarker marker = document.createRangeMarker(newElement.getTextRange());
            CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)newElement);
            newStartOffset = marker.getStartOffset();
        }
        if (toDelete != null && toDelete.isValid()) {
            document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
        }
        return newStartOffset;
    }

    public static void shortenReference(PsiFile file, int offset) throws IncorrectOperationException {
        Project project = file.getProject();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        assert (document != null);
        manager.commitDocument(document);
        PsiReference ref = file.findReferenceAt(offset);
        if (ref instanceof GrCodeReferenceElement) {
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)((GroovyPsiElement)ref));
        }
    }

    public static int addRParenth(Editor editor, int oldTail, boolean space_within_cast_parentheses) {
        int offset = -1;
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(oldTail);
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (TokenSets.WHITE_SPACES_OR_COMMENTS.contains(tokenType)) {
                iterator2.advance();
                continue;
            }
            if (tokenType != GroovyTokenTypes.mRPAREN) break;
            offset = iterator2.getEnd();
            break;
        }
        if (offset != -1) {
            return offset;
        }
        offset = oldTail;
        if (space_within_cast_parentheses) {
            offset = TailType.insertChar((Editor)editor, (int)oldTail, (char)' ');
        }
        return TailType.insertChar((Editor)editor, (int)offset, (char)')');
    }

    public static boolean skipDefGroovyMethod(GrGdkMethod gdkMethod, PsiSubstitutor substitutor, @Nullable PsiType type2) {
        PsiType substituted;
        if (type2 == null) {
            return false;
        }
        String name = gdkMethod.getStaticMethod().getName();
        PsiType baseType = gdkMethod.getReceiverType();
        if (!TypeConversionUtil.erasure((PsiType)baseType).equalsToText("java.lang.Object")) {
            return false;
        }
        PsiType psiType = substituted = substitutor != null ? substitutor.substitute(baseType) : baseType;
        if (GdkMethodUtil.COLLECTION_METHOD_NAMES.contains(name)) {
            return !(type2 instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Iterable") && !(substituted instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)substituted, (String)"java.lang.Iterable");
        }
        return !GdkMethodUtil.isWithName(name);
    }

    public static boolean isWildcardCompletion(PsiElement position) {
        PsiElement prev = PsiUtil.getPreviousNonWhitespaceToken(position);
        if (prev instanceof PsiErrorElement) {
            prev = PsiUtil.getPreviousNonWhitespaceToken(prev);
        }
        if (prev == null || prev.getNode().getElementType() != GroovyTokenTypes.mQUESTION) {
            return false;
        }
        PsiElement pprev = PsiUtil.getPreviousNonWhitespaceToken(prev);
        if (pprev == null) {
            return false;
        }
        IElementType t = pprev.getNode().getElementType();
        return t == GroovyTokenTypes.mLT || t == GroovyTokenTypes.mCOMMA;
    }

    static boolean isNewStatementInScript(PsiElement context) {
        PsiElement parent2;
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        return leaf != null && GroovyCompletionUtil.isNewStatement(context, false) && (parent2 = leaf.getParent()) instanceof GroovyFile;
    }

    public static boolean isReferenceElementInNewExpr(PsiElement context) {
        PsiElement pparent;
        return context.getParent() instanceof GrCodeReferenceElement && (pparent = context.getParent().getParent()) instanceof GrNewExpression;
    }

    static boolean isCodeReferenceElementApplicableToModifierCompletion(PsiElement context) {
        return context.getParent() instanceof GrCodeReferenceElement && !(context.getParent().getParent() instanceof GrImportStatement) && !(context.getParent().getParent() instanceof GrPackageDefinition) && !(context.getParent().getParent() instanceof GrNewExpression);
    }

    static boolean isTypelessParameter(PsiElement context) {
        return context.getParent() instanceof GrParameter && ((GrParameter)context.getParent()).getTypeElementGroovy() == null;
    }

    public static boolean isTupleVarNameWithoutTypeDeclared(PsiElement position) {
        PsiElement parent2 = position.getParent();
        PsiElement pparent = parent2.getParent();
        return parent2 instanceof GrVariable && ((GrVariable)parent2).getNameIdentifierGroovy() == position && ((GrVariable)parent2).getTypeElementGroovy() == null && pparent instanceof GrVariableDeclaration && ((GrVariableDeclaration)pparent).isTuple();
    }

    public static void processVariants(GrReferenceElement referenceElement, PrefixMatcher matcher, CompletionParameters parameters2, Consumer<LookupElement> consumer) {
        if (referenceElement instanceof GrCodeReferenceElementImpl) {
            CompleteCodeReferenceElement.complete((GrCodeReferenceElement)referenceElement, matcher, consumer);
        } else if (referenceElement instanceof GrReferenceExpressionImpl) {
            CompleteReferenceExpression.processVariants(matcher, consumer, (GrReferenceExpressionImpl)referenceElement, parameters2);
        }
    }

    public static boolean isInPossibleClosureParameter(PsiElement position) {
        if (position == null) {
            return false;
        }
        if (position instanceof PsiWhiteSpace || position.getNode().getElementType() == GroovyTokenTypes.mNLS) {
            position = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)position);
        }
        boolean hasCommas = false;
        while (position != null) {
            PsiElement parent2 = position.getParent();
            if (parent2 instanceof GrVariable) {
                PsiElement prev = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)parent2);
                boolean bl = hasCommas = prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mCOMMA;
            }
            if (parent2 instanceof GrClosableBlock) {
                for (PsiElement sibling = position.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
                    if (sibling instanceof GrParameterList) {
                        return hasCommas;
                    }
                    boolean isComma = sibling instanceof LeafPsiElement && GroovyTokenTypes.mCOMMA == ((LeafPsiElement)sibling).getElementType();
                    hasCommas |= isComma;
                    if (isComma || sibling instanceof PsiWhiteSpace || sibling instanceof PsiErrorElement || sibling instanceof GrVariableDeclaration || sibling instanceof GrReferenceExpression && !((GrReferenceExpression)sibling).isQualified()) {
                        continue;
                    }
                    return false;
                }
                return false;
            }
            position = parent2;
        }
        return false;
    }

    @Nullable
    public static PsiType getQualifierType(@Nullable PsiElement qualifier) {
        PsiType type2;
        PsiType qualifierType;
        PsiType psiType = qualifierType = qualifier instanceof GrExpression ? ((GrExpression)qualifier).getType() : null;
        if (ResolveUtil.resolvesToClass(qualifier) && (type2 = ResolveUtil.unwrapClassType(qualifierType)) != null) {
            qualifierType = type2;
        }
        return qualifierType;
    }

    static boolean canResolveToPackage(@NotNull PsiElement qualifier) {
        if (qualifier == null) {
            GroovyCompletionUtil.$$$reportNull$$$0(4);
        }
        return qualifier instanceof GrReferenceExpression && ReferencesKt.resolvePackageFqn((GrReferenceElement)qualifier) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElements";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConstructorParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "canResolveToPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

