/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.groovy.mvc.MvcConsole;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.MvcWatchedRootProvider;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcToolWindowDescriptor;

@Service
public final class MvcModuleStructureSynchronizer
implements Disposable {
    private final Set<Pair<Object, SyncAction>> myOrders;
    private final Project myProject;
    private Set<VirtualFile> myPluginRoots;
    private boolean myOutOfModuleDirectoryCreatedActionAdded;
    public static boolean ourGrailsTestFlag;
    private final SimpleModificationTracker myModificationTracker;

    public MvcModuleStructureSynchronizer(@NotNull Project project) {
        if (project == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(0);
        }
        this.myOrders = new LinkedHashSet<Pair<Object, SyncAction>>();
        this.myPluginRoots = Collections.emptySet();
        this.myModificationTracker = new SimpleModificationTracker();
        this.myProject = project;
    }

    public void dispose() {
    }

    @NotNull
    public static MvcModuleStructureSynchronizer getInstance(@NotNull Project project) {
        if (project == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(1);
        }
        MvcModuleStructureSynchronizer mvcModuleStructureSynchronizer = (MvcModuleStructureSynchronizer)project.getService(MvcModuleStructureSynchronizer.class);
        if (mvcModuleStructureSynchronizer == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(2);
        }
        return mvcModuleStructureSynchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectOpened() {
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        synchronized (set) {
            Project project = this.myProject;
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.UpdateProjectStructure));
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.EnsureRunConfigurationExists));
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.UpgradeFramework));
            this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.CreateAppStructureIfNeeded));
        }
        this.scheduleRunActions();
        this.addListeners();
    }

    @NotNull
    public SimpleModificationTracker getFileAndRootsModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    private void addListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        for (String rootPath : MvcWatchedRootProvider.doGetRootsToWatch(this.myProject)) {
            VirtualFilePointerManager.getInstance().createDirectoryPointer(VfsUtilCore.pathToUrl((String)rootPath), true, (Disposable)this, new VirtualFilePointerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void validityChanged(@NotNull @NotNull VirtualFilePointer @NotNull [] pointers) {
                    if (pointers == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                    Set<Pair<Object, SyncAction>> set = MvcModuleStructureSynchronizer.this.myOrders;
                    synchronized (set) {
                        MvcModuleStructureSynchronizer.this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)MvcModuleStructureSynchronizer.this.myProject, (Object)SyncAction.SyncLibrariesInPluginsModule));
                    }
                    MvcModuleStructureSynchronizer.this.scheduleRunActions();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$1", "validityChanged"));
                }
            });
        }
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                Set<Pair<Object, SyncAction>> set = MvcModuleStructureSynchronizer.this.myOrders;
                synchronized (set) {
                    Project project = MvcModuleStructureSynchronizer.this.myProject;
                    MvcModuleStructureSynchronizer.this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.UpgradeFramework));
                    MvcModuleStructureSynchronizer.this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.CreateAppStructureIfNeeded));
                    MvcModuleStructureSynchronizer.this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.UpdateProjectStructure));
                    MvcModuleStructureSynchronizer.this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.EnsureRunConfigurationExists));
                }
                MvcModuleStructureSynchronizer.this.scheduleRunActions();
                MvcModuleStructureSynchronizer.this.updateProjectViewVisibility();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$2", "rootsChanged"));
            }
        });
        connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void moduleAdded(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(1);
                }
                Set<Pair<Object, SyncAction>> set = MvcModuleStructureSynchronizer.this.myOrders;
                synchronized (set) {
                    MvcModuleStructureSynchronizer.this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.UpdateProjectStructure));
                    MvcModuleStructureSynchronizer.this.myOrders.add((Pair<Object, SyncAction>)new Pair((Object)project, (Object)SyncAction.CreateAppStructureIfNeeded));
                }
                MvcModuleStructureSynchronizer.this.scheduleRunActions();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$3";
                objectArray[2] = "moduleAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){
            final ProjectFileIndex myFileIndex;
            {
                this.myFileIndex = ProjectFileIndex.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                VirtualFile file;
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!this.myFileIndex.isInContent(file = event.getFile())) {
                    return;
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                String fileName = event.getFileName();
                if ("application.properties".equals(fileName) || MvcModuleStructureSynchronizer.isApplicationDirectoryName(fileName)) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.EnsureRunConfigurationExists, file);
                } else if (MvcModuleStructureSynchronizer.isLibDirectory(file) || MvcModuleStructureSynchronizer.isLibDirectory(event.getParent())) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                } else {
                    if (!MvcModuleStructureSynchronizer.this.myProject.isInitialized()) {
                        return;
                    }
                    Module module = ProjectRootManager.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject).getFileIndex().getModuleForFile(file);
                    if (module == null) {
                        if (file.isDirectory()) {
                            if (MvcModuleStructureSynchronizer.this.myPluginRoots.contains(file.getParent())) {
                                MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, MvcModuleStructureSynchronizer.this.myProject);
                                return;
                            }
                            if (!MvcModuleStructureSynchronizer.this.myOutOfModuleDirectoryCreatedActionAdded) {
                                MvcModuleStructureSynchronizer.this.queue(SyncAction.OutOfModuleDirectoryCreated, MvcModuleStructureSynchronizer.this.myProject);
                                MvcModuleStructureSynchronizer.this.myOutOfModuleDirectoryCreatedActionAdded = true;
                            }
                        }
                        return;
                    }
                    if (!MvcConsole.isUpdatingVfsByConsoleProcess(module)) {
                        return;
                    }
                    MvcFramework framework = MvcFramework.getInstance(module);
                    if (framework == null) {
                        return;
                    }
                    if (framework.isToReformatOnCreation(file) || file.isDirectory()) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!file.isValid()) {
                                return;
                            }
                            if (!framework.hasSupport(module)) {
                                return;
                            }
                            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
                            if (file.isDirectory()) {
                                ModuleRootManager.getInstance((Module)module).getFileIndex().iterateContentUnderDirectory(file, fileOrDir -> {
                                    if (!fileOrDir.isDirectory() && framework.isToReformatOnCreation(fileOrDir)) {
                                        files.add(file);
                                    }
                                    return true;
                                });
                            } else {
                                files.add(file);
                            }
                            PsiManager manager = PsiManager.getInstance((Project)MvcModuleStructureSynchronizer.this.myProject);
                            for (VirtualFile virtualFile : files) {
                                PsiFile psiFile = manager.findFile(virtualFile);
                                if (psiFile == null) continue;
                                new ReformatCodeProcessor(MvcModuleStructureSynchronizer.this.myProject, psiFile, null, false).run();
                            }
                        }, module.getDisposed());
                    }
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(1);
                }
                VirtualFile file = event.getFile();
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                if (MvcModuleStructureSynchronizer.isLibDirectory(file) || MvcModuleStructureSynchronizer.isLibDirectory(event.getParent())) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                VirtualFile file;
                if (event == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (!this.myFileIndex.isInContent(file = event.getFile())) {
                    return;
                }
                String fileName = event.getFileName();
                if ("application.properties".equals(fileName)) {
                    MvcModuleStructureSynchronizer.this.queue(SyncAction.UpdateProjectStructure, file);
                }
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (!this.myFileIndex.isInContent(event.getFile())) {
                    return;
                }
                MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
            }

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(4);
                }
                if (!this.myFileIndex.isInContent(event.getFile())) {
                    return;
                }
                if ("name".equals(event.getPropertyName())) {
                    MvcModuleStructureSynchronizer.this.myModificationTracker.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    private static boolean isApplicationDirectoryName(@NotNull String fileName) {
        if (fileName == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(4);
        }
        for (MvcFramework framework : (MvcFramework[])MvcFramework.EP_NAME.getExtensions()) {
            if (!framework.getApplicationDirectoryName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLibDirectory(@Nullable VirtualFile file) {
        return file != null && "lib".equals(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue(@NotNull SyncAction action, @NotNull Object on) {
        if (action == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(5);
        }
        if (on == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        synchronized (set) {
            this.myOrders.add((Pair<Object, SyncAction>)Pair.create((Object)on, (Object)((Object)action)));
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(this::scheduleRunActions);
    }

    private void scheduleRunActions() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ourGrailsTestFlag && !this.myProject.isInitialized()) {
                this.runActions(this.computeRawActions());
            }
            return;
        }
        ReadAction.nonBlocking(() -> this.computeRawActions()).expireWith((Disposable)this).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.NON_MODAL, this::runActions).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Set<Pair<Object, SyncAction>> takeOrderSnapshot() {
        Set<Pair<Object, SyncAction>> set = this.myOrders;
        // MONITORENTER : set
        LinkedHashSet<Pair<Object, SyncAction>> linkedHashSet = new LinkedHashSet<Pair<Object, SyncAction>>(this.myOrders);
        // MONITOREXIT : set
        if (linkedHashSet != null) return linkedHashSet;
        MvcModuleStructureSynchronizer.$$$reportNull$$$0(7);
        return linkedHashSet;
    }

    @NotNull
    private List<Module> determineModuleBySyncActionObject(@NotNull Object o) {
        VirtualFile file;
        if (o == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(8);
        }
        if (o instanceof Module) {
            List<Module> list = Collections.singletonList((Module)o);
            if (list == null) {
                MvcModuleStructureSynchronizer.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (o instanceof Project) {
            List<Module> list = Arrays.asList(ModuleManager.getInstance((Project)((Project)o)).getModules());
            if (list == null) {
                MvcModuleStructureSynchronizer.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (o instanceof VirtualFile && (file = (VirtualFile)o).isValid()) {
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
            if (module == null) {
                List<Module> list = Collections.emptyList();
                if (list == null) {
                    MvcModuleStructureSynchronizer.$$$reportNull$$$0(11);
                }
                return list;
            }
            List<Module> list = Collections.singletonList(module);
            if (list == null) {
                MvcModuleStructureSynchronizer.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<Module> list = Collections.emptyList();
        if (list == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(13);
        }
        return list;
    }

    @TestOnly
    public static void forceUpdateProject(@NotNull Project project) {
        if (project == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(14);
        }
        MvcModuleStructureSynchronizer instance = MvcModuleStructureSynchronizer.getInstance(project);
        instance.getFileAndRootsModificationTracker().incModificationCount();
        instance.runActions(instance.computeRawActions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runActions(@NotNull Set<? extends Trinity<Module, SyncAction, MvcFramework>> actions) {
        if (actions == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(15);
        }
        try {
            boolean isProjectStructureUpdated = false;
            for (Trinity<Module, SyncAction, MvcFramework> trinity : actions) {
                Module module = (Module)trinity.first;
                if (module.isDisposed()) continue;
                if (trinity.second == SyncAction.UpdateProjectStructure && ((MvcFramework)trinity.third).updatesWholeProject()) {
                    if (isProjectStructureUpdated) continue;
                    isProjectStructureUpdated = true;
                }
                ((SyncAction)((Object)trinity.second)).doAction(module, (MvcFramework)trinity.third);
            }
        }
        finally {
            Set<Pair<Object, SyncAction>> set = this.myOrders;
            synchronized (set) {
                this.myOrders.clear();
            }
        }
    }

    @NotNull
    private Set<Trinity<Module, SyncAction, MvcFramework>> computeRawActions() {
        Set<Pair<Object, SyncAction>> actions = this.takeOrderSnapshot();
        LinkedHashSet<Trinity<Module, SyncAction, MvcFramework>> rawActions = new LinkedHashSet<Trinity<Module, SyncAction, MvcFramework>>();
        for (Pair<Object, SyncAction> pair : actions) {
            for (Module module : this.determineModuleBySyncActionObject(pair.first)) {
                MvcFramework framework;
                if (module.isDisposed() || (framework = pair.second == SyncAction.CreateAppStructureIfNeeded ? MvcFramework.getInstanceBySdk(module) : MvcFramework.getInstance(module)) == null || framework.isAuxModule(module)) continue;
                rawActions.add((Trinity<Module, SyncAction, MvcFramework>)Trinity.create((Object)module, (Object)((Object)((SyncAction)((Object)pair.second))), (Object)framework));
            }
        }
        LinkedHashSet<Trinity<Module, SyncAction, MvcFramework>> linkedHashSet = rawActions;
        if (linkedHashSet == null) {
            MvcModuleStructureSynchronizer.$$$reportNull$$$0(16);
        }
        return linkedHashSet;
    }

    private void updateProjectViewVisibility() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
            for (ToolWindowEP ep : ToolWindowEP.EP_NAME.getExtensionList()) {
                Class factoryClass = ep.getFactoryClass(ep.getPluginDescriptor());
                if (factoryClass == null || !MvcToolWindowDescriptor.class.isAssignableFrom(factoryClass)) continue;
                MvcToolWindowDescriptor descriptor = (MvcToolWindowDescriptor)ep.getToolWindowFactory(ep.getPluginDescriptor());
                String id = descriptor.getToolWindowId();
                boolean shouldShow = descriptor.value(this.myProject);
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
                ToolWindow toolWindow = toolWindowManager.getToolWindow(id);
                if (shouldShow && toolWindow == null) {
                    toolWindow = toolWindowManager.registerToolWindow(id, true, ToolWindowAnchor.LEFT, (Disposable)this, true);
                    toolWindow.setIcon(descriptor.getFramework().getToolWindowIcon());
                    descriptor.createToolWindowContent(this.myProject, toolWindow);
                    continue;
                }
                if (shouldShow || toolWindow == null) continue;
                toolWindowManager.unregisterToolWindow(id);
                Disposer.dispose((Disposable)toolWindow.getContentManager());
            }
        }, this.myProject.getDisposed()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "on";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileAndRootsModificationTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "takeOrderSnapshot";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "determineModuleBySyncActionObject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRawActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplicationDirectoryName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "determineModuleBySyncActionObject";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateProject";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SyncAction {
        SyncLibrariesInPluginsModule{

            @Override
            void doAction(@NotNull Module module, @NotNull MvcFramework framework) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (framework == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (MvcModuleStructureUtil.isEnabledStructureUpdate()) {
                    framework.syncSdkAndLibrariesInPluginsModule(module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "framework";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$SyncAction$1";
                objectArray[2] = "doAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        UpgradeFramework{

            @Override
            void doAction(@NotNull Module module, @NotNull MvcFramework framework) {
                if (module == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (framework == null) {
                    2.$$$reportNull$$$0(1);
                }
                framework.upgradeFramework(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "framework";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$SyncAction$2";
                objectArray[2] = "doAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        CreateAppStructureIfNeeded{

            @Override
            void doAction(@NotNull Module module, @NotNull MvcFramework framework) {
                if (module == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (framework == null) {
                    3.$$$reportNull$$$0(1);
                }
                framework.createApplicationIfNeeded(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "framework";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$SyncAction$3";
                objectArray[2] = "doAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        UpdateProjectStructure{

            @Override
            void doAction(@NotNull Module module, @NotNull MvcFramework framework) {
                if (module == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (framework == null) {
                    4.$$$reportNull$$$0(1);
                }
                framework.updateProjectStructure(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "framework";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$SyncAction$4";
                objectArray[2] = "doAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        EnsureRunConfigurationExists{

            @Override
            void doAction(@NotNull Module module, @NotNull MvcFramework framework) {
                if (module == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (framework == null) {
                    5.$$$reportNull$$$0(1);
                }
                framework.ensureRunConfigurationExists(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "framework";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$SyncAction$5";
                objectArray[2] = "doAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        OutOfModuleDirectoryCreated{

            @Override
            void doAction(@NotNull Module module, @NotNull MvcFramework framework) {
                if (module == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (framework == null) {
                    6.$$$reportNull$$$0(1);
                }
                Project project = module.getProject();
                MvcModuleStructureSynchronizer mvcModuleStructureSynchronizer = MvcModuleStructureSynchronizer.getInstance(project);
                if (mvcModuleStructureSynchronizer.myOutOfModuleDirectoryCreatedActionAdded) {
                    mvcModuleStructureSynchronizer.myOutOfModuleDirectoryCreatedActionAdded = false;
                    HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
                    for (String rootPath : MvcWatchedRootProvider.doGetRootsToWatch(project)) {
                        ContainerUtil.addIfNotNull(roots, (Object)LocalFileSystem.getInstance().findFileByPath(rootPath));
                    }
                    if (!roots.equals(mvcModuleStructureSynchronizer.myPluginRoots)) {
                        mvcModuleStructureSynchronizer.myPluginRoots = roots;
                        ApplicationManager.getApplication().invokeLater(() -> mvcModuleStructureSynchronizer.queue(UpdateProjectStructure, project));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "framework";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$SyncAction$6";
                objectArray[2] = "doAction";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        abstract void doAction(@NotNull Module var1, @NotNull MvcFramework var2);
    }

    static final class MyPostStartUpActivity
    implements StartupActivity.DumbAware {
        MyPostStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyPostStartUpActivity.$$$reportNull$$$0(0);
            }
            GuiUtils.invokeLaterIfNeeded(() -> MvcModuleStructureSynchronizer.getInstance(project).projectOpened(), (ModalityState)ModalityState.NON_MODAL, (Condition)project.getDisposed());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/mvc/MvcModuleStructureSynchronizer$MyPostStartUpActivity", "runActivity"));
        }
    }
}

