/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin;

import com.intellij.openapi.roots.OrderEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Version {
    @NonNls
    public static final String PLUGIN_NAME = "Lombok plugin";
    @NonNls
    public static final String LAST_LOMBOK_VERSION = "1.18.16";

    public static boolean isLessThan(@Nullable OrderEntry orderEntry, @NotNull String version) {
        String lombokVersion;
        if (version == null) {
            Version.$$$reportNull$$$0(0);
        }
        return (lombokVersion = Version.parseLombokVersion(orderEntry)) != null && Version.compareVersionString(lombokVersion, version) < 0;
    }

    @Nullable
    public static String parseLombokVersion(@Nullable OrderEntry orderEntry) {
        String result = null;
        if (orderEntry != null) {
            String presentableName = orderEntry.getPresentableName();
            Matcher matcher = Pattern.compile("(.*:)([\\d.]+)(.*)").matcher(presentableName);
            if (matcher.find()) {
                result = matcher.group(2);
            }
        }
        return result;
    }

    public static int compareVersionString(@NotNull String firstVersionOne, @NotNull String secondVersion) {
        if (firstVersionOne == null) {
            Version.$$$reportNull$$$0(1);
        }
        if (secondVersion == null) {
            Version.$$$reportNull$$$0(2);
        }
        String[] firstVersionParts = firstVersionOne.split("\\.");
        String[] secondVersionParts = secondVersion.split("\\.");
        int length = Math.max(firstVersionParts.length, secondVersionParts.length);
        for (int i = 0; i < length; ++i) {
            int secondPart;
            int firstPart = i < firstVersionParts.length && !firstVersionParts[i].isEmpty() ? Integer.parseInt(firstVersionParts[i]) : 0;
            int n = secondPart = i < secondVersionParts.length && !secondVersionParts[i].isEmpty() ? Integer.parseInt(secondVersionParts[i]) : 0;
            if (firstPart < secondPart) {
                return -1;
            }
            if (firstPart <= secondPart) continue;
            return 1;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstVersionOne";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondVersion";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/Version";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLessThan";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareVersionString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

