/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.quickfix.UseSlf4jAnnotationQuickFix;
import org.jetbrains.annotations.NotNull;

public class RedundantSlf4jDefinitionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String LOGGER_SLF4J_FQCN = "org.slf4j.Logger";
    private static final String LOGGER_INITIALIZATION = "LoggerFactory.getLogger(%s.class)";

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantSlf4jDefinitionInspection.$$$reportNull$$$0(0);
        }
        return new LombokDefinitionVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/RedundantSlf4jDefinitionInspection", "buildVisitor"));
    }

    private static class LombokDefinitionVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder holder;

        public LombokDefinitionVisitor(ProblemsHolder holder) {
            this.holder = holder;
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            this.findRedundantDefinition((PsiVariable)field, field.getContainingClass());
        }

        private void findRedundantDefinition(PsiVariable field, PsiClass containingClass) {
            PsiExpression initializer;
            if (field.getType().equalsToText(RedundantSlf4jDefinitionInspection.LOGGER_SLF4J_FQCN) && (initializer = field.getInitializer()) != null && containingClass != null && initializer.getText().contains(String.format(RedundantSlf4jDefinitionInspection.LOGGER_INITIALIZATION, containingClass.getQualifiedName()))) {
                this.holder.registerProblem((PsiElement)field, "Slf4j Logger is defined explicitly. Use Lombok @Slf4j annotation instead.", ProblemHighlightType.WARNING, new LocalQuickFix[]{new UseSlf4jAnnotationQuickFix((PsiNamedElement)field, containingClass)});
            }
        }
    }
}

