/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.lombokconfig;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.indexing.FileBasedIndex;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigIndexKey;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigValue;
import de.plushnikov.intellij.plugin.lombokconfig.LombokConfigIndex;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigDiscovery {
    public static ConfigDiscovery getInstance() {
        return (ConfigDiscovery)ApplicationManager.getApplication().getService(ConfigDiscovery.class);
    }

    @NotNull
    public String getStringLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        String canonicalPath;
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(1);
        }
        if (null != (canonicalPath = this.calculateCanonicalPath(psiClass))) {
            return this.discoverProperty(configKey, canonicalPath, psiClass.getProject());
        }
        String string = configKey.getConfigDefaultValue();
        if (string == null) {
            ConfigDiscovery.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean getBooleanLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(4);
        }
        String configProperty = this.getStringLombokConfigProperty(configKey, psiClass);
        return Boolean.parseBoolean(configProperty);
    }

    @NotNull
    public String[] getMultipleValueLombokConfigProperty(@NotNull ConfigKey configKey, @NotNull PsiClass psiClass) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(6);
        }
        HashSet<String> result = new HashSet<String>();
        String canonicalPath = this.calculateCanonicalPath(psiClass);
        if (null != canonicalPath) {
            List<String> properties = this.discoverProperties(configKey, canonicalPath, psiClass.getProject());
            Collections.reverse(properties);
            for (String configProperty : properties) {
                String[] values;
                if (!StringUtil.isNotEmpty((String)configProperty)) continue;
                for (String value : values = configProperty.split(";")) {
                    if (value.startsWith("+")) {
                        result.add(value.substring(1));
                        continue;
                    }
                    if (!value.startsWith("-")) continue;
                    result.remove(value.substring(1));
                }
            }
        } else {
            result.add(configKey.getConfigDefaultValue());
        }
        String[] stringArray = result.toArray(new String[0]);
        if (stringArray == null) {
            ConfigDiscovery.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    @Nullable
    private String calculateCanonicalPath(@NotNull PsiClass psiClass) {
        PsiClass containingClass;
        if (psiClass == null) {
            ConfigDiscovery.$$$reportNull$$$0(8);
        }
        String canonicalPath = null;
        Object psiFile = psiClass instanceof LombokLightClassBuilder ? (null != (containingClass = psiClass.getContainingClass()) ? containingClass.getContainingFile() : null) : psiClass.getContainingFile();
        if (null != psiFile && null == (canonicalPath = this.getDirectoryCanonicalPath((PsiFile)psiFile))) {
            canonicalPath = this.getDirectoryCanonicalPath(psiFile.getOriginalFile());
        }
        return PathUtil.toSystemIndependentName(canonicalPath);
    }

    @Nullable
    private String getDirectoryCanonicalPath(@NotNull PsiFile psiFile) {
        VirtualFile fileDirectory;
        VirtualFile virtualFile;
        if (psiFile == null) {
            ConfigDiscovery.$$$reportNull$$$0(9);
        }
        if (null != (virtualFile = psiFile.getVirtualFile()) && null != (fileDirectory = virtualFile.getParent())) {
            return fileDirectory.getCanonicalPath();
        }
        return null;
    }

    @NotNull
    private String discoverProperty(@NotNull ConfigKey configKey, @NotNull String canonicalPath, @NotNull Project project) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(10);
        }
        if (canonicalPath == null) {
            ConfigDiscovery.$$$reportNull$$$0(11);
        }
        if (project == null) {
            ConfigDiscovery.$$$reportNull$$$0(12);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
        FileBasedIndex fileBasedIndex = this.getFileBasedIndex();
        String currentPath = canonicalPath;
        while (null != currentPath) {
            ConfigValue configValue = this.readProperty(fileBasedIndex, searchScope, currentPath, configKey);
            if (null != configValue) {
                if (null == configValue.getValue()) {
                    if (configValue.isStopBubbling()) {
                        break;
                    }
                } else {
                    String string = configValue.getValue();
                    if (string == null) {
                        ConfigDiscovery.$$$reportNull$$$0(13);
                    }
                    return string;
                }
            }
            currentPath = this.bubbleUp(currentPath);
        }
        String string = configKey.getConfigDefaultValue();
        if (string == null) {
            ConfigDiscovery.$$$reportNull$$$0(14);
        }
        return string;
    }

    @VisibleForTesting
    protected FileBasedIndex getFileBasedIndex() {
        return (FileBasedIndex)ApplicationManager.getApplication().getService(FileBasedIndex.class);
    }

    @Nullable
    private String bubbleUp(@NotNull String currentPath) {
        int endIndex;
        if (currentPath == null) {
            ConfigDiscovery.$$$reportNull$$$0(15);
        }
        currentPath = (endIndex = currentPath.lastIndexOf(47)) > 0 ? currentPath.substring(0, endIndex) : null;
        return currentPath;
    }

    @Nullable
    private ConfigValue readProperty(FileBasedIndex fileBasedIndex, GlobalSearchScope searchScope, String directoryName, ConfigKey configKey) {
        ConfigIndexKey configIndexKey = new ConfigIndexKey(directoryName, configKey.getConfigKey());
        List values = fileBasedIndex.getValues(LombokConfigIndex.NAME, (Object)configIndexKey, searchScope);
        if (!values.isEmpty()) {
            return (ConfigValue)values.iterator().next();
        }
        return null;
    }

    @NotNull
    private List<String> discoverProperties(@NotNull ConfigKey configKey, @NotNull String canonicalPath, @NotNull Project project) {
        if (configKey == null) {
            ConfigDiscovery.$$$reportNull$$$0(16);
        }
        if (canonicalPath == null) {
            ConfigDiscovery.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ConfigDiscovery.$$$reportNull$$$0(18);
        }
        ArrayList<String> result = new ArrayList<String>();
        GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)project);
        FileBasedIndex fileBasedIndex = this.getFileBasedIndex();
        String currentPath = canonicalPath;
        while (null != currentPath) {
            ConfigValue configValue = this.readProperty(fileBasedIndex, searchScope, currentPath, configKey);
            if (null != configValue) {
                if (null == configValue.getValue()) {
                    if (configValue.isStopBubbling()) {
                        break;
                    }
                } else {
                    result.add(configValue.getValue());
                }
            }
            currentPath = this.bubbleUp(currentPath);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            ConfigDiscovery.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/lombokconfig/ConfigDiscovery";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalPath";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/lombokconfig/ConfigDiscovery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLombokConfigProperty";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultipleValueLombokConfigProperty";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverProperty";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "discoverProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringLombokConfigProperty";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanLombokConfigProperty";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMultipleValueLombokConfigProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateCanonicalPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryCanonicalPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "discoverProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "bubbleUp";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "discoverProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 14: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

