/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.JavaVarTypeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValProcessor
extends AbstractProcessor {
    private static final String LOMBOK_VAL_NAME = StringUtil.getShortName((String)"lombok.val");
    private static final String LOMBOK_VAR_NAME = StringUtil.getShortName((String)"lombok.var");

    public ValProcessor() {
        super(PsiElement.class, "lombok.val", "lombok.experimental.var", "lombok.var");
    }

    public static boolean isVal(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            ValProcessor.$$$reportNull$$$0(0);
        }
        if (psiVariable instanceof PsiLocalVariable) {
            return ValProcessor.isVal((PsiLocalVariable)psiVariable);
        }
        if (!(psiVariable instanceof PsiParameter)) {
            return false;
        }
        PsiParameter psiParameter = (PsiParameter)psiVariable;
        PsiTypeElement typeElement = psiParameter.getTypeElement();
        if (typeElement == null) {
            return false;
        }
        return ValProcessor.isPossibleVal(typeElement.getText()) && ValProcessor.isVal(ValProcessor.resolveQualifiedName(typeElement));
    }

    public static boolean isVar(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            ValProcessor.$$$reportNull$$$0(1);
        }
        if (psiVariable instanceof PsiLocalVariable) {
            return ValProcessor.isVar((PsiLocalVariable)psiVariable);
        }
        if (!(psiVariable instanceof PsiParameter)) {
            return false;
        }
        PsiParameter psiParameter = (PsiParameter)psiVariable;
        PsiTypeElement typeElement = psiParameter.getTypeElement();
        if (typeElement == null) {
            return false;
        }
        return ValProcessor.isPossibleVar(typeElement.getText()) && ValProcessor.isVar(ValProcessor.resolveQualifiedName(typeElement));
    }

    public static boolean isVal(@NotNull PsiLocalVariable psiLocalVariable) {
        if (psiLocalVariable == null) {
            ValProcessor.$$$reportNull$$$0(2);
        }
        if (psiLocalVariable.hasInitializer()) {
            PsiTypeElement typeElement = psiLocalVariable.getTypeElement();
            return ValProcessor.isPossibleVal(typeElement.getText()) && ValProcessor.isVal(ValProcessor.resolveQualifiedName(typeElement));
        }
        return false;
    }

    public static boolean isVar(@NotNull PsiLocalVariable psiLocalVariable) {
        if (psiLocalVariable == null) {
            ValProcessor.$$$reportNull$$$0(3);
        }
        if (psiLocalVariable.hasInitializer()) {
            PsiTypeElement typeElement = psiLocalVariable.getTypeElement();
            return ValProcessor.isPossibleVar(typeElement.getText()) && ValProcessor.isVar(ValProcessor.resolveQualifiedName(typeElement));
        }
        return false;
    }

    private static boolean isValOrVar(@NotNull PsiLocalVariable psiLocalVariable) {
        if (psiLocalVariable == null) {
            ValProcessor.$$$reportNull$$$0(4);
        }
        if (psiLocalVariable.hasInitializer()) {
            PsiTypeElement typeElement = psiLocalVariable.getTypeElement();
            return ValProcessor.isPossibleValOrVar(typeElement.getText()) && ValProcessor.isValOrVar(ValProcessor.resolveQualifiedName(typeElement));
        }
        return false;
    }

    private boolean isValOrVarForEach(@NotNull PsiParameter psiParameter) {
        if (psiParameter == null) {
            ValProcessor.$$$reportNull$$$0(5);
        }
        if (psiParameter.getParent() instanceof PsiForeachStatement) {
            PsiTypeElement typeElement = psiParameter.getTypeElement();
            return null != typeElement && ValProcessor.isPossibleValOrVar(typeElement.getText()) && ValProcessor.isValOrVar(ValProcessor.resolveQualifiedName(typeElement));
        }
        return false;
    }

    private static boolean isValOrVar(@Nullable String fullQualifiedName) {
        return ValProcessor.isVal(fullQualifiedName) || ValProcessor.isVar(fullQualifiedName);
    }

    private static boolean isPossibleValOrVar(@Nullable String shortName) {
        return ValProcessor.isPossibleVal(shortName) || ValProcessor.isPossibleVar(shortName);
    }

    private static boolean isPossibleVal(@Nullable String shortName) {
        return LOMBOK_VAL_NAME.equals(shortName);
    }

    private static boolean isVal(@Nullable String fullQualifiedName) {
        return "lombok.val".equals(fullQualifiedName);
    }

    private static boolean isPossibleVar(@Nullable String shortName) {
        return LOMBOK_VAR_NAME.equals(shortName);
    }

    private static boolean isVar(@Nullable String fullQualifiedName) {
        return "lombok.var".equals(fullQualifiedName) || "lombok.experimental.var".equals(fullQualifiedName);
    }

    @Nullable
    private static String resolveQualifiedName(@NotNull PsiTypeElement typeElement) {
        PsiJavaCodeReferenceElement reference;
        if (typeElement == null) {
            ValProcessor.$$$reportNull$$$0(6);
        }
        if ((reference = typeElement.getInnermostComponentReferenceElement()) == null) {
            return null;
        }
        return reference.getQualifiedName();
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ValProcessor.$$$reportNull$$$0(7);
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            ValProcessor.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            ValProcessor.$$$reportNull$$$0(9);
        }
        List<LombokProblem> list = Collections.emptyList();
        if (list == null) {
            ValProcessor.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void verifyVariable(@NotNull PsiLocalVariable psiLocalVariable, @NotNull ProblemsHolder holder) {
        String ann;
        PsiTypeElement typeElement;
        String typeElementText;
        if (psiLocalVariable == null) {
            ValProcessor.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            ValProcessor.$$$reportNull$$$0(12);
        }
        boolean isVal = ValProcessor.isPossibleVal(typeElementText = (typeElement = psiLocalVariable.getTypeElement()).getText()) && ValProcessor.isVal(ValProcessor.resolveQualifiedName(typeElement));
        boolean isVar = ValProcessor.isPossibleVar(typeElementText) && ValProcessor.isVar(ValProcessor.resolveQualifiedName(typeElement));
        String string = ann = isVal ? "val" : "var";
        if (isVal || isVar) {
            PsiElement typeParentParent;
            PsiExpression initializer = psiLocalVariable.getInitializer();
            if (initializer == null) {
                holder.registerProblem((PsiElement)psiLocalVariable, "'" + ann + "' on a local variable requires an initializer expression", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            } else if (initializer instanceof PsiArrayInitializerExpression) {
                holder.registerProblem((PsiElement)psiLocalVariable, "'" + ann + "' is not compatible with array initializer expressions. Use the full form (new int[] { ... } instead of just { ... })", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            } else if (initializer instanceof PsiLambdaExpression) {
                holder.registerProblem((PsiElement)psiLocalVariable, "'" + ann + "' is not allowed with lambda expressions.", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            } else if (isVal && (typeParentParent = psiLocalVariable.getParent()) instanceof PsiDeclarationStatement && typeParentParent.getParent() instanceof PsiForStatement) {
                holder.registerProblem((PsiElement)psiLocalVariable, "'" + ann + "' is not allowed in old-style for loops", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }

    public void verifyParameter(@NotNull PsiParameter psiParameter, @NotNull ProblemsHolder holder) {
        boolean isVar;
        PsiTypeElement typeElement;
        if (psiParameter == null) {
            ValProcessor.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            ValProcessor.$$$reportNull$$$0(14);
        }
        String typeElementText = null != (typeElement = psiParameter.getTypeElement()) ? typeElement.getText() : null;
        boolean isVal = ValProcessor.isPossibleVal(typeElementText) && ValProcessor.isVal(ValProcessor.resolveQualifiedName(typeElement));
        boolean bl = isVar = ValProcessor.isPossibleVar(typeElementText) && ValProcessor.isVar(ValProcessor.resolveQualifiedName(typeElement));
        if (isVar || isVal) {
            PsiElement scope = psiParameter.getDeclarationScope();
            boolean isForeachStatement = scope instanceof PsiForeachStatement;
            boolean isForStatement = scope instanceof PsiForStatement;
            if (isVal && !isForeachStatement) {
                holder.registerProblem((PsiElement)psiParameter, "'val' works only on local variables and on foreach loops", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            } else if (isVar && !isForeachStatement && !isForStatement) {
                holder.registerProblem((PsiElement)psiParameter, "'var' works only on local variables and on for/foreach loops", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }
    }

    public boolean canInferType(@NotNull PsiTypeElement typeElement) {
        PsiElement parent;
        if (typeElement == null) {
            ValProcessor.$$$reportNull$$$0(15);
        }
        return (parent = typeElement.getParent()) instanceof PsiLocalVariable && ValProcessor.isValOrVar((PsiLocalVariable)parent) || parent instanceof PsiParameter && this.isValOrVarForEach((PsiParameter)parent);
    }

    @Nullable
    public PsiType inferType(PsiTypeElement typeElement) {
        PsiElement parent;
        PsiType psiType = null;
        if (this.canInferType(typeElement) && null == (psiType = (parent = typeElement.getParent()) instanceof PsiLocalVariable ? this.processLocalVariableInitializer(((PsiLocalVariable)parent).getInitializer()) : this.processParameterDeclaration(((PsiParameter)parent).getDeclarationScope()))) {
            psiType = PsiType.getJavaLangObject((PsiManager)typeElement.getManager(), (GlobalSearchScope)typeElement.getResolveScope());
        }
        return psiType;
    }

    private PsiType processLocalVariableInitializer(PsiExpression psiExpression) {
        PsiType result = null;
        if (null != psiExpression && !(psiExpression instanceof PsiArrayInitializerExpression)) {
            result = (PsiType)RecursionManager.doPreventingRecursion((Object)psiExpression, (boolean)true, () -> {
                PsiType[] conjuncts;
                PsiType type = psiExpression.getType();
                if (type instanceof PsiIntersectionType && (conjuncts = ((PsiIntersectionType)type).getConjuncts()).length > 0) {
                    return conjuncts[0];
                }
                if (type != null) {
                    return JavaVarTypeUtil.getUpwardProjection((PsiType)type);
                }
                return null;
            });
        }
        return result;
    }

    private PsiType processParameterDeclaration(PsiElement parentDeclarationScope) {
        PsiForeachStatement foreachStatement;
        PsiExpression iteratedValue;
        PsiType result = null;
        if (parentDeclarationScope instanceof PsiForeachStatement && (iteratedValue = (foreachStatement = (PsiForeachStatement)parentDeclarationScope).getIteratedValue()) != null) {
            result = JavaGenericsUtil.getCollectionItemType((PsiExpression)iteratedValue);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiLocalVariable";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParameter";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/ValProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/ValProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isVal";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVar";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValOrVar";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValOrVarForEach";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "verifyVariable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "verifyParameter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "canInferType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

