/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.handler.EqualsAndHashCodeToStringHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EqualsAndHashCodeProcessor
extends AbstractClassProcessor {
    private static final String EQUALS_METHOD_NAME = "equals";
    private static final String HASH_CODE_METHOD_NAME = "hashCode";
    private static final String CAN_EQUAL_METHOD_NAME = "canEqual";
    private static final String INCLUDE_ANNOTATION_METHOD = "replaces";
    private static final String EQUALSANDHASHCODE_INCLUDE = "lombok.EqualsAndHashCode.Include";
    private static final String EQUALSANDHASHCODE_EXCLUDE = "lombok.EqualsAndHashCode.Exclude";
    private static final int PRIME_FOR_HASHCODE = 59;
    private static final int PRIME_FOR_TRUE = 79;
    private static final int PRIME_FOR_FALSE = 97;
    private static final int PRIME_FOR_NULL = 43;

    public EqualsAndHashCodeProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.EqualsAndHashCode");
    }

    private EqualsAndHashCodeToStringHandler getEqualsAndHashCodeToStringHandler() {
        return (EqualsAndHashCodeToStringHandler)ApplicationManager.getApplication().getService(EqualsAndHashCodeToStringHandler.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        boolean result;
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(2);
        }
        if (result = this.validateAnnotationOnRightType(psiClass, builder)) {
            this.validateExistingMethods(psiClass, builder);
        }
        Collection<String> excludeProperty = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "exclude", String.class);
        Collection<String> ofProperty = PsiAnnotationUtil.getAnnotationValues(psiAnnotation, "of", String.class);
        if (!excludeProperty.isEmpty() && !ofProperty.isEmpty()) {
            builder.addWarning("exclude and of are mutually exclusive; the 'exclude' parameter will be ignored", PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "exclude", null));
        } else {
            this.validateExcludeParam(psiClass, builder, psiAnnotation, excludeProperty);
        }
        this.validateOfParam(psiClass, builder, psiAnnotation, ofProperty);
        this.validateCallSuperParamIntern(psiAnnotation, psiClass, builder);
        this.validateCallSuperParamForObject(psiAnnotation, psiClass, builder);
        return result;
    }

    private void validateCallSuperParamIntern(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(5);
        }
        this.validateCallSuperParam(psiAnnotation, psiClass, builder, PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", "false"), PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", "true"));
    }

    void validateCallSuperParamExtern(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(8);
        }
        this.validateCallSuperParam(psiAnnotation, psiClass, builder, PsiQuickFixFactory.createAddAnnotationQuickFix(psiClass, "lombok.EqualsAndHashCode", "callSuper = true"));
    }

    private void validateCallSuperParam(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemBuilder builder, LocalQuickFix ... quickFixes) {
        String configProperty;
        Boolean declaredBooleanAnnotationValue;
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(9);
        }
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(11);
        }
        if (null == (declaredBooleanAnnotationValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(psiAnnotation, "callSuper")) && !"CALL".equalsIgnoreCase(configProperty = this.configDiscovery.getStringLombokConfigProperty(ConfigKey.EQUALSANDHASHCODE_CALL_SUPER, psiClass)) && !"SKIP".equalsIgnoreCase(configProperty) && PsiClassUtil.hasSuperClass(psiClass) && !this.hasOneOfMethodsDefined(psiClass)) {
            builder.addWarning("Generating equals/hashCode implementation but without a call to superclass, even though this class does not extend java.lang.Object. If this is intentional, add '(callSuper=false)' to your type.", quickFixes);
        }
    }

    private void validateCallSuperParamForObject(PsiAnnotation psiAnnotation, PsiClass psiClass, ProblemBuilder builder) {
        boolean callSuperProperty = PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "callSuper", false);
        if (callSuperProperty && !PsiClassUtil.hasSuperClass(psiClass)) {
            builder.addError("Generating equals/hashCode with a supercall to java.lang.Object is pointless.", PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", "false"), PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "callSuper", null));
        }
    }

    private boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(13);
        }
        boolean result = true;
        if (psiClass.isAnnotationType() || psiClass.isInterface() || psiClass.isEnum()) {
            builder.addError("@EqualsAndHashCode is only supported on a class type");
            result = false;
        }
        return result;
    }

    private void validateExistingMethods(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(15);
        }
        if (this.hasOneOfMethodsDefined(psiClass)) {
            builder.addWarning("Not generating equals and hashCode: A method with one of those names already exists. (Either both or none of these methods will be generated).");
        }
    }

    private boolean hasOneOfMethodsDefined(@NotNull PsiClass psiClass) {
        Collection<PsiMethod> classMethodsIntern;
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(16);
        }
        return PsiMethodUtil.hasMethodByName(classMethodsIntern = PsiClassUtil.collectClassMethodsIntern(psiClass), EQUALS_METHOD_NAME, 1) || PsiMethodUtil.hasMethodByName(classMethodsIntern, HASH_CODE_METHOD_NAME, 0);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(17);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(18);
        }
        if (target == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(19);
        }
        target.addAll(this.createEqualAndHashCode(psiClass, psiAnnotation));
    }

    protected Collection<PsiMethod> createEqualAndHashCode(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(20);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(21);
        }
        if (this.hasOneOfMethodsDefined(psiClass)) {
            return Collections.emptyList();
        }
        Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos = this.getEqualsAndHashCodeToStringHandler().filterFields(psiClass, psiAnnotation, true, INCLUDE_ANNOTATION_METHOD);
        boolean shouldGenerateCanEqual = this.shouldGenerateCanEqual(psiClass);
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>(3);
        result.add(this.createEqualsMethod(psiClass, psiAnnotation, shouldGenerateCanEqual, memberInfos));
        Collection<PsiMethod> classMethods = PsiClassUtil.collectClassMethodsIntern(psiClass);
        if (shouldGenerateCanEqual && !PsiMethodUtil.hasMethodByName(classMethods, CAN_EQUAL_METHOD_NAME, 1)) {
            result.add(this.createCanEqualMethod(psiClass, psiAnnotation));
        }
        result.add(this.createHashCodeMethod(psiClass, psiAnnotation, memberInfos));
        return result;
    }

    private boolean shouldGenerateCanEqual(@NotNull PsiClass psiClass) {
        boolean isNotDirectDescendantOfObject;
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(22);
        }
        if (isNotDirectDescendantOfObject = PsiClassUtil.hasSuperClass(psiClass)) {
            return true;
        }
        boolean isFinal = psiClass.hasModifierProperty("final") || PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Value") && PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.experimental.NonFinal");
        return !isFinal;
    }

    @NotNull
    private PsiMethod createEqualsMethod(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, boolean hasCanEqualMethod, Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(23);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(24);
        }
        PsiManager psiManager = psiClass.getManager();
        String blockText = this.createEqualsBlockString(psiClass, psiAnnotation, hasCanEqualMethod, memberInfos);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiManager, EQUALS_METHOD_NAME).withModifier("public").withMethodReturnType((PsiType)PsiType.BOOLEAN).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withFinalParameter("o", (PsiType)PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)psiClass.getResolveScope()));
        methodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(blockText, (PsiElement)methodBuilder));
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(25);
        }
        return lombokLightMethodBuilder;
    }

    @NotNull
    private PsiMethod createHashCodeMethod(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(26);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(27);
        }
        PsiManager psiManager = psiClass.getManager();
        String blockText = this.createHashcodeBlockString(psiClass, psiAnnotation, memberInfos);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiManager, HASH_CODE_METHOD_NAME).withModifier("public").withMethodReturnType((PsiType)PsiType.INT).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation);
        methodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(blockText, (PsiElement)methodBuilder));
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(28);
        }
        return lombokLightMethodBuilder;
    }

    @NotNull
    private PsiMethod createCanEqualMethod(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(29);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(30);
        }
        PsiManager psiManager = psiClass.getManager();
        String blockText = String.format("return other instanceof %s;", PsiTypesUtil.getClassType((PsiClass)psiClass).getCanonicalText());
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiManager, CAN_EQUAL_METHOD_NAME).withModifier("protected").withMethodReturnType((PsiType)PsiType.BOOLEAN).withContainingClass(psiClass).withNavigationElement((PsiElement)psiAnnotation).withFinalParameter("other", (PsiType)PsiType.getJavaLangObject((PsiManager)psiManager, (GlobalSearchScope)psiClass.getResolveScope()));
        methodBuilder.withBody(PsiMethodUtil.createCodeBlockFromText(blockText, (PsiElement)methodBuilder));
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(31);
        }
        return lombokLightMethodBuilder;
    }

    private String createEqualsBlockString(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, boolean hasCanEqualMethod, Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(32);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(33);
        }
        boolean callSuper = this.readCallSuperAnnotationOrConfigProperty(psiAnnotation, psiClass, ConfigKey.EQUALSANDHASHCODE_CALL_SUPER);
        boolean doNotUseGetters = this.readAnnotationOrConfigProperty(psiAnnotation, psiClass, "doNotUseGetters", ConfigKey.EQUALSANDHASHCODE_DO_NOT_USE_GETTERS);
        String canonicalClassName = PsiTypesUtil.getClassType((PsiClass)psiClass).getCanonicalText();
        String canonicalWildcardClassName = PsiClassUtil.getWildcardClassType(psiClass).getCanonicalText();
        StringBuilder builder = new StringBuilder();
        builder.append("if (o == this) return true;\n");
        builder.append("if (!(o instanceof ").append(canonicalClassName).append(")) return false;\n");
        builder.append("final ").append(canonicalWildcardClassName).append(" other = (").append(canonicalWildcardClassName).append(")o;\n");
        if (hasCanEqualMethod) {
            builder.append("if (!other.canEqual((java.lang.Object)this)) return false;\n");
        }
        if (callSuper) {
            builder.append("if (!super.equals(o)) return false;\n");
        }
        EqualsAndHashCodeToStringHandler handler = this.getEqualsAndHashCodeToStringHandler();
        for (EqualsAndHashCodeToStringHandler.MemberInfo memberInfo : memberInfos) {
            String memberAccessor = handler.getMemberAccessorName(memberInfo, doNotUseGetters, psiClass);
            PsiType memberType = memberInfo.getType();
            if (memberType instanceof PsiPrimitiveType) {
                if (PsiType.FLOAT.equals((Object)memberType)) {
                    builder.append("if (java.lang.Float.compare(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(") != 0) return false;\n");
                    continue;
                }
                if (PsiType.DOUBLE.equals((Object)memberType)) {
                    builder.append("if (java.lang.Double.compare(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(") != 0) return false;\n");
                    continue;
                }
                builder.append("if (this.").append(memberAccessor).append(" != other.").append(memberAccessor).append(") return false;\n");
                continue;
            }
            if (memberType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)memberType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    builder.append("if (!java.util.Arrays.equals(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(")) return false;\n");
                    continue;
                }
                builder.append("if (!java.util.Arrays.deepEquals(this.").append(memberAccessor).append(", other.").append(memberAccessor).append(")) return false;\n");
                continue;
            }
            String memberName = memberInfo.getName();
            builder.append("final java.lang.Object this$").append(memberName).append(" = this.").append(memberAccessor).append(";\n");
            builder.append("final java.lang.Object other$").append(memberName).append(" = other.").append(memberAccessor).append(";\n");
            builder.append("if (this$").append(memberName).append(" == null ? other$").append(memberName).append(" != null : !this$").append(memberName).append(".equals(other$").append(memberName).append(")) return false;\n");
        }
        builder.append("return true;\n");
        return builder.toString();
    }

    private String createHashcodeBlockString(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, Collection<EqualsAndHashCodeToStringHandler.MemberInfo> memberInfos) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(34);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(35);
        }
        boolean callSuper = this.readCallSuperAnnotationOrConfigProperty(psiAnnotation, psiClass, ConfigKey.EQUALSANDHASHCODE_CALL_SUPER);
        boolean doNotUseGetters = this.readAnnotationOrConfigProperty(psiAnnotation, psiClass, "doNotUseGetters", ConfigKey.EQUALSANDHASHCODE_DO_NOT_USE_GETTERS);
        StringBuilder builder = new StringBuilder();
        if (!memberInfos.isEmpty()) {
            builder.append("final int PRIME = ").append(59).append(";\n");
        }
        builder.append("int result = ");
        if (callSuper) {
            builder.append("super.hashCode();\n");
        } else {
            builder.append("1;\n");
        }
        EqualsAndHashCodeToStringHandler handler = this.getEqualsAndHashCodeToStringHandler();
        for (EqualsAndHashCodeToStringHandler.MemberInfo memberInfo : memberInfos) {
            String memberAccessor = handler.getMemberAccessorName(memberInfo, doNotUseGetters, psiClass);
            Object memberName = memberInfo.getMethod() == null ? memberInfo.getName() : "$" + memberInfo.getName();
            PsiType classFieldType = memberInfo.getType();
            if (classFieldType instanceof PsiPrimitiveType) {
                if (PsiType.BOOLEAN.equals((Object)classFieldType)) {
                    builder.append("result = result * PRIME + (this.").append(memberAccessor).append(" ? ").append(79).append(" : ").append(97).append(");\n");
                    continue;
                }
                if (PsiType.LONG.equals((Object)classFieldType)) {
                    builder.append("final long $").append((String)memberName).append(" = this.").append(memberAccessor).append(";\n");
                    builder.append("result = result * PRIME + (int)($").append((String)memberName).append(" >>> 32 ^ $").append((String)memberName).append(");\n");
                    continue;
                }
                if (PsiType.FLOAT.equals((Object)classFieldType)) {
                    builder.append("result = result * PRIME + java.lang.Float.floatToIntBits(this.").append(memberAccessor).append(");\n");
                    continue;
                }
                if (PsiType.DOUBLE.equals((Object)classFieldType)) {
                    builder.append("final long $").append((String)memberName).append(" = java.lang.Double.doubleToLongBits(this.").append(memberAccessor).append(");\n");
                    builder.append("result = result * PRIME + (int)($").append((String)memberName).append(" >>> 32 ^ $").append((String)memberName).append(");\n");
                    continue;
                }
                builder.append("result = result * PRIME + this.").append(memberAccessor).append(";\n");
                continue;
            }
            if (classFieldType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)classFieldType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    builder.append("result = result * PRIME + java.util.Arrays.hashCode(this.").append(memberAccessor).append(");\n");
                    continue;
                }
                builder.append("result = result * PRIME + java.util.Arrays.deepHashCode(this.").append(memberAccessor).append(");\n");
                continue;
            }
            builder.append("final java.lang.Object $").append((String)memberName).append(" = this.").append(memberAccessor).append(";\n");
            builder.append("result = result * PRIME + ($").append((String)memberName).append(" == null ? 43 : $").append((String)memberName).append(".hashCode());\n");
        }
        builder.append("return result;\n");
        return builder.toString();
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(36);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        this.addFieldsAnnotation(result, psiClass, EQUALSANDHASHCODE_INCLUDE, EQUALSANDHASHCODE_EXCLUDE);
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiField == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(38);
        }
        if (psiAnnotation == null) {
            EqualsAndHashCodeProcessor.$$$reportNull$$$0(39);
        }
        if (null != (containingClass = psiField.getContainingClass())) {
            String psiFieldName = StringUtil.notNullize((String)psiField.getName());
            if (this.getEqualsAndHashCodeToStringHandler().filterFields(containingClass, psiAnnotation, true, INCLUDE_ANNOTATION_METHOD).stream().map(EqualsAndHashCodeToStringHandler.MemberInfo::getName).anyMatch(psiFieldName::equals)) {
                return LombokPsiElementUsage.READ;
            }
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 29: 
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/EqualsAndHashCodeProcessor";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/EqualsAndHashCodeProcessor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createEqualsMethod";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createHashCodeMethod";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanEqualMethod";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateCallSuperParamIntern";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateCallSuperParamExtern";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateCallSuperParam";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingMethods";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasOneOfMethodsDefined";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createEqualAndHashCode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateCanEqual";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createEqualsMethod";
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 37: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createHashCodeMethod";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createCanEqualMethod";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createEqualsBlockString";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createHashcodeBlockString";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: 
            case 28: 
            case 31: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

