/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessorsInfo {
    public static final AccessorsInfo EMPTY = new AccessorsInfo(false, false, false, new String[0]);
    private final boolean fluent;
    private final boolean chain;
    private final String[] prefixes;
    private final boolean doNotUseIsPrefix;

    private AccessorsInfo(boolean fluentValue, boolean chainValue, boolean doNotUseIsPrefix, String ... prefixes) {
        this.fluent = fluentValue;
        this.chain = chainValue;
        this.doNotUseIsPrefix = doNotUseIsPrefix;
        this.prefixes = null == prefixes ? new String[]{} : prefixes;
    }

    @NotNull
    public static AccessorsInfo build(boolean fluentValue, boolean chainValue, boolean doNotUseIsPrefix, String ... prefixes) {
        return new AccessorsInfo(fluentValue, chainValue, doNotUseIsPrefix, prefixes);
    }

    @NotNull
    public static AccessorsInfo build(@NotNull PsiField psiField) {
        if (psiField == null) {
            AccessorsInfo.$$$reportNull$$$0(0);
        }
        return AccessorsInfo.build((PsiVariable)psiField, psiField.getContainingClass());
    }

    @NotNull
    public static AccessorsInfo build(@NotNull PsiVariable psiVariable, @Nullable PsiClass containingClass) {
        PsiAnnotation accessorsFieldAnnotation;
        if (psiVariable == null) {
            AccessorsInfo.$$$reportNull$$$0(1);
        }
        if (null != (accessorsFieldAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiVariable, "lombok.experimental.Accessors"))) {
            return AccessorsInfo.buildFromAnnotation(accessorsFieldAnnotation, containingClass);
        }
        return AccessorsInfo.build(containingClass);
    }

    @NotNull
    public static AccessorsInfo build(@NotNull PsiField psiField, @NotNull AccessorsInfo classAccessorsInfo) {
        PsiAnnotation accessorsFieldAnnotation;
        if (psiField == null) {
            AccessorsInfo.$$$reportNull$$$0(2);
        }
        if (classAccessorsInfo == null) {
            AccessorsInfo.$$$reportNull$$$0(3);
        }
        if (null != (accessorsFieldAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.experimental.Accessors"))) {
            return AccessorsInfo.buildFromAnnotation(accessorsFieldAnnotation, psiField.getContainingClass());
        }
        AccessorsInfo accessorsInfo = classAccessorsInfo;
        if (accessorsInfo == null) {
            AccessorsInfo.$$$reportNull$$$0(4);
        }
        return accessorsInfo;
    }

    @NotNull
    public static AccessorsInfo build(@Nullable PsiClass psiClass) {
        for (PsiClass containingClass = psiClass; null != containingClass; containingClass = containingClass.getContainingClass()) {
            PsiAnnotation accessorsClassAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)containingClass, "lombok.experimental.Accessors");
            if (null == accessorsClassAnnotation) continue;
            return AccessorsInfo.buildFromAnnotation(accessorsClassAnnotation, containingClass);
        }
        return AccessorsInfo.buildAccessorsInfo(psiClass, null, null, Collections.emptySet());
    }

    @NotNull
    private static AccessorsInfo buildFromAnnotation(@NotNull PsiAnnotation accessorsAnnotation, @Nullable PsiClass psiClass) {
        if (accessorsAnnotation == null) {
            AccessorsInfo.$$$reportNull$$$0(5);
        }
        Boolean chainDeclaredValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(accessorsAnnotation, "chain");
        Boolean fluentDeclaredValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(accessorsAnnotation, "fluent");
        Collection<String> prefixes = PsiAnnotationUtil.getAnnotationValues(accessorsAnnotation, "prefix", String.class);
        return AccessorsInfo.buildAccessorsInfo(psiClass, chainDeclaredValue, fluentDeclaredValue, prefixes);
    }

    @NotNull
    private static AccessorsInfo buildAccessorsInfo(@Nullable PsiClass psiClass, @Nullable Boolean chainDeclaredValue, @Nullable Boolean fluentDeclaredValue, @NotNull Collection<String> prefixDeclared) {
        boolean doNotUseIsPrefix;
        String[] prefixes;
        boolean isChained;
        boolean isFluent;
        if (prefixDeclared == null) {
            AccessorsInfo.$$$reportNull$$$0(6);
        }
        if (null != psiClass) {
            ConfigDiscovery configDiscovery = ConfigDiscovery.getInstance();
            isFluent = null == fluentDeclaredValue ? configDiscovery.getBooleanLombokConfigProperty(ConfigKey.ACCESSORS_FLUENT, psiClass) : fluentDeclaredValue.booleanValue();
            isChained = null == chainDeclaredValue ? configDiscovery.getBooleanLombokConfigProperty(ConfigKey.ACCESSORS_CHAIN, psiClass) : chainDeclaredValue.booleanValue();
            prefixes = prefixDeclared.isEmpty() ? configDiscovery.getMultipleValueLombokConfigProperty(ConfigKey.ACCESSORS_PREFIX, psiClass) : prefixDeclared.toArray(new String[0]);
            doNotUseIsPrefix = configDiscovery.getBooleanLombokConfigProperty(ConfigKey.GETTER_NO_IS_PREFIX, psiClass);
        } else {
            isFluent = null != fluentDeclaredValue && fluentDeclaredValue != false;
            isChained = null != chainDeclaredValue && chainDeclaredValue != false;
            prefixes = prefixDeclared.toArray(new String[0]);
            doNotUseIsPrefix = false;
        }
        boolean isChainDeclaredOrImplicit = isChained || isFluent && null == chainDeclaredValue;
        return new AccessorsInfo(isFluent, isChainDeclaredOrImplicit, doNotUseIsPrefix, prefixes);
    }

    public boolean isFluent() {
        return this.fluent;
    }

    public AccessorsInfo withFluent(boolean fluentValue) {
        if (this.fluent == fluentValue) {
            return this;
        }
        return new AccessorsInfo(fluentValue, this.chain, this.doNotUseIsPrefix, this.prefixes);
    }

    public boolean isChain() {
        return this.chain;
    }

    public boolean isDoNotUseIsPrefix() {
        return this.doNotUseIsPrefix;
    }

    public String[] getPrefixes() {
        return this.prefixes;
    }

    public boolean isPrefixUnDefinedOrNotStartsWith(String fieldName) {
        if (this.prefixes.length == 0) {
            return false;
        }
        for (String prefix : this.prefixes) {
            if (!this.canPrefixApply(fieldName, prefix)) continue;
            return false;
        }
        return true;
    }

    public String removePrefix(String fieldName) {
        for (String prefix : this.prefixes) {
            if (!this.canPrefixApply(fieldName, prefix)) continue;
            return prefix.isEmpty() ? fieldName : this.decapitalizeLikeLombok(fieldName.substring(prefix.length()));
        }
        return fieldName;
    }

    private boolean canPrefixApply(String fieldName, String prefix) {
        int prefixLength = prefix.length();
        return prefixLength == 0 || fieldName.startsWith(prefix) && fieldName.length() > prefixLength && (!Character.isLetter(prefix.charAt(prefix.length() - 1)) || !Character.isLowerCase(fieldName.charAt(prefixLength)));
    }

    private String decapitalizeLikeLombok(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiVariable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classAccessorsInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/AccessorsInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorsAnnotation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixDeclared";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/AccessorsInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildFromAnnotation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildAccessorsInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

