/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LombokLightModifierList
extends LightModifierList
implements SyntheticElement {
    private static final Set<String> ALL_MODIFIERS = new HashSet<String>(Arrays.asList(PsiModifier.MODIFIERS));
    private final Map<String, PsiAnnotation> myAnnotations = new HashMap<String, PsiAnnotation>();
    private final Set<String> myImplicitModifiers;

    public LombokLightModifierList(PsiManager manager, Language language, Collection<String> implicitModifiers, String ... modifiers) {
        super(manager, language, modifiers);
        this.myImplicitModifiers = new HashSet<String>(implicitModifiers);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            LombokLightModifierList.$$$reportNull$$$0(0);
        }
        return this.myImplicitModifiers.contains(name) || super.hasModifierProperty(name);
    }

    public void addImplicitModifierProperty(@PsiModifier.ModifierConstant @NotNull @NonNls String implicitModifier) {
        if (implicitModifier == null) {
            LombokLightModifierList.$$$reportNull$$$0(1);
        }
        this.myImplicitModifiers.add(implicitModifier);
    }

    public void setModifierProperty(@PsiModifier.ModifierConstant @NotNull @NonNls String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            LombokLightModifierList.$$$reportNull$$$0(2);
        }
        if (value) {
            this.addModifier(name);
        } else if (this.hasModifierProperty(name)) {
            this.removeModifier(name);
        }
    }

    private void removeModifier(@PsiModifier.ModifierConstant @NotNull @NonNls String name) {
        if (name == null) {
            LombokLightModifierList.$$$reportNull$$$0(3);
        }
        Collection<String> myModifiers = this.collectAllModifiers();
        myModifiers.remove(name);
        this.clearModifiers();
        for (String modifier : myModifiers) {
            this.addModifier(modifier);
        }
    }

    private Collection<String> collectAllModifiers() {
        HashSet<String> result = new HashSet<String>();
        for (String modifier : ALL_MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            result.add(modifier);
        }
        return result;
    }

    public void checkSetModifierProperty(@PsiModifier.ModifierConstant @NotNull @NonNls String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            LombokLightModifierList.$$$reportNull$$$0(4);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            LombokLightModifierList.$$$reportNull$$$0(5);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiAnnotation psiAnnotation = elementFactory.createAnnotationFromText("@" + qualifiedName, null);
        this.myAnnotations.put(qualifiedName, psiAnnotation);
        PsiAnnotation psiAnnotation2 = psiAnnotation;
        if (psiAnnotation2 == null) {
            LombokLightModifierList.$$$reportNull$$$0(6);
        }
        return psiAnnotation2;
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            LombokLightModifierList.$$$reportNull$$$0(7);
        }
        return this.myAnnotations.get(qualifiedName);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] result = PsiAnnotation.EMPTY_ARRAY;
        if (!this.myAnnotations.isEmpty()) {
            Collection<PsiAnnotation> annotations = this.myAnnotations.values();
            result = annotations.toArray(PsiAnnotation.EMPTY_ARRAY);
        }
        if (result == null) {
            LombokLightModifierList.$$$reportNull$$$0(8);
        }
        return result;
    }

    public TextRange getTextRange() {
        TextRange r = super.getTextRange();
        return r == null ? TextRange.EMPTY_RANGE : r;
    }

    public String toString() {
        return "LombokLightModifierList";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LombokLightModifierList that = (LombokLightModifierList)((Object)o);
        return this.myAnnotations.equals(that.myAnnotations);
    }

    public int hashCode() {
        return this.myAnnotations.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitModifier";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/psi/LombokLightModifierList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/psi/LombokLightModifierList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitModifierProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeModifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

