/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.DirtyUI;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class SelectInAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SelectInAction.$$$reportNull$$$0(0);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.select.in");
        SelectInContext context = SelectInContextImpl.createContext(e);
        if (context == null) {
            return;
        }
        SelectInAction.invoke(e.getDataContext(), context);
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SelectInAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) != null) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        }
        super.beforeActionPerformedUpdate(e);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectInAction.$$$reportNull$$$0(2);
        }
        Presentation presentation2 = event.getPresentation();
        if (SelectInContextImpl.createContext(event) == null) {
            presentation2.setEnabledAndVisible(false);
        } else {
            presentation2.setEnabledAndVisible(true);
        }
    }

    private static void invoke(@NotNull DataContext dataContext, @NotNull SelectInContext context) {
        ListPopup popup2;
        List targetVector;
        if (dataContext == null) {
            SelectInAction.$$$reportNull$$$0(3);
        }
        if (context == null) {
            SelectInAction.$$$reportNull$$$0(4);
        }
        if ((targetVector = SelectInManager.getInstance((Project)context.getProject()).getTargetList()).isEmpty()) {
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add((AnAction)new NoTargetsAction());
            popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"title.popup.select.target", (Object[])new Object[0]), (ActionGroup)group2, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, true);
        } else {
            popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new SelectInActionsStep(targetVector, context));
        }
        popup2.showInBestPositionFor(dataContext);
    }

    private static String numberingText(int n, String text2) {
        text2 = n < 9 ? "&" + (n + 1) + ". " + (String)text2 : (n == 9 ? "&0. " + (String)text2 : "&" + (char)(65 + n - 10) + ". " + (String)text2);
        return text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/SelectInAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class NoTargetsAction
    extends AnAction {
        NoTargetsAction() {
            super(IdeBundle.messagePointer((String)"message.no.targets.available", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NoTargetsAction.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/SelectInAction$NoTargetsAction", "actionPerformed"));
        }
    }

    private static final class SelectInActionsStep
    extends BaseListPopupStep<SelectInTarget> {
        private final SelectInContext mySelectInContext;
        private final List<SelectInTarget> myVisibleTargets;

        SelectInActionsStep(@NotNull Collection<SelectInTarget> targetVector, @NotNull SelectInContext selectInContext) {
            if (targetVector == null) {
                SelectInActionsStep.$$$reportNull$$$0(0);
            }
            if (selectInContext == null) {
                SelectInActionsStep.$$$reportNull$$$0(1);
            }
            this.mySelectInContext = selectInContext;
            this.myVisibleTargets = new ArrayList<SelectInTarget>(targetVector);
            List<Icon> icons = SelectInActionsStep.fillInIcons(targetVector, selectInContext);
            this.init(IdeBundle.message((String)"title.popup.select.target", (Object[])new Object[0]), this.myVisibleTargets, icons);
        }

        @NotNull
        private static List<Icon> fillInIcons(@NotNull Collection<? extends SelectInTarget> targets2, @NotNull SelectInContext selectInContext) {
            if (targets2 == null) {
                SelectInActionsStep.$$$reportNull$$$0(2);
            }
            if (selectInContext == null) {
                SelectInActionsStep.$$$reportNull$$$0(3);
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)selectInContext.getProject());
            ArrayList<Icon> list2 = new ArrayList<Icon>();
            for (SelectInTarget selectInTarget : targets2) {
                String id2 = selectInTarget.getMinorViewId() == null ? selectInTarget.getToolWindowId() : null;
                ToolWindow toolWindow = id2 == null ? null : toolWindowManager.getToolWindow(id2);
                Icon icon2 = toolWindow != null ? toolWindow.getIcon() : EmptyIcon.ICON_13;
                list2.add(icon2);
            }
            ArrayList<Icon> arrayList = list2;
            if (arrayList == null) {
                SelectInActionsStep.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @NotNull
        public String getTextFor(SelectInTarget value2) {
            ToolWindow toolWindow;
            String text2 = value2.toString();
            String id2 = value2.getMinorViewId() == null ? value2.getToolWindowId() : null;
            ToolWindow toolWindow2 = toolWindow = id2 == null ? null : ToolWindowManager.getInstance((Project)this.mySelectInContext.getProject()).getToolWindow(id2);
            if (toolWindow != null) {
                text2 = text2.replace(value2.getToolWindowId(), toolWindow.getStripeTitle());
            }
            int n = this.myVisibleTargets.indexOf(value2);
            String string = SelectInAction.numberingText(n, text2);
            if (string == null) {
                SelectInActionsStep.$$$reportNull$$$0(5);
            }
            return string;
        }

        @DirtyUI
        public PopupStep onChosen(SelectInTarget target2, boolean finalChoice) {
            ArrayList<SelectInTarget> subTargets;
            if (finalChoice) {
                PsiDocumentManager.getInstance((Project)this.mySelectInContext.getProject()).commitAllDocuments();
                target2.selectIn(this.mySelectInContext, true);
                return FINAL_CHOICE;
            }
            if (target2 instanceof CompositeSelectInTarget && (subTargets = new ArrayList<SelectInTarget>(((CompositeSelectInTarget)target2).getSubTargets(this.mySelectInContext))).size() > 0) {
                subTargets.sort((Comparator<SelectInTarget>)new SelectInManager.SelectInTargetComparator());
                return new SelectInActionsStep(subTargets, this.mySelectInContext);
            }
            return FINAL_CHOICE;
        }

        public boolean hasSubstep(SelectInTarget selectedValue) {
            return selectedValue instanceof CompositeSelectInTarget && ((CompositeSelectInTarget)selectedValue).getSubTargets(this.mySelectInContext).size() > 1;
        }

        @DirtyUI
        public boolean isSelectable(SelectInTarget target2) {
            if (DumbService.isDumb((Project)this.mySelectInContext.getProject()) && !DumbService.isDumbAware((Object)target2)) {
                return false;
            }
            return target2.canSelect(this.mySelectInContext);
        }

        public boolean isMnemonicsNavigationEnabled() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetVector";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectInContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/SelectInAction$SelectInActionsStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/SelectInAction$SelectInActionsStep";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fillInIcons";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillInIcons";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

