/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateLoadResult;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.project.ProjectKt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.UrlUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.runtime.ParserPool;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.directive.Stop;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTemplatesLoader
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileTemplatesLoader.class);
    static final String TEMPLATES_DIR = "fileTemplates";
    private static final String DEFAULT_TEMPLATES_ROOT = "fileTemplates";
    private static final String DESCRIPTION_FILE_EXTENSION = "html";
    private static final String DESCRIPTION_EXTENSION_SUFFIX = ".html";
    private static final Map<String, String> MANAGER_TO_DIR = ContainerUtil.newHashMap((Pair)Pair.create((Object)"Default", (Object)""), (Pair[])new Pair[]{Pair.create((Object)"Internal", (Object)"internal"), Pair.create((Object)"Includes", (Object)"includes"), Pair.create((Object)"Code", (Object)"code"), Pair.create((Object)"J2EE", (Object)"j2ee")});
    private final ClearableLazyValue<LoadedConfiguration> myManagers = ClearableLazyValue.createAtomic(() -> FileTemplatesLoader.loadConfiguration(project));

    FileTemplatesLoader(@Nullable Project project) {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.clearClassLeakViaStaticExceptionTrace();
                this.resetParserPool();
            }

            private void clearClassLeakViaStaticExceptionTrace() {
                Field field = ReflectionUtil.getDeclaredField(Stop.class, (String)"STOP_ALL");
                if (field != null) {
                    try {
                        ThrowableInterner.clearBacktrace((Throwable)((Throwable)field.get(null)));
                    }
                    catch (Throwable e) {
                        LOG.info(e);
                    }
                }
            }

            private void resetParserPool() {
                try {
                    Object pp;
                    RuntimeServices ri = RuntimeSingleton.getRuntimeServices();
                    Field ppField = ReflectionUtil.getDeclaredField(ri.getClass(), (String)"parserPool");
                    if (ppField != null && (pp = ppField.get(ri)) instanceof ParserPool) {
                        ((ParserPool)pp).initialize(ri);
                    }
                }
                catch (Throwable e) {
                    LOG.info(e);
                }
            }

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileTemplatesLoader.this.myManagers.drop();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                FileTemplatesLoader.this.myManagers.drop();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforePluginUnload";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    @NotNull Collection<@NotNull FTManager> getAllManagers() {
        Collection<FTManager> collection = ((LoadedConfiguration)this.myManagers.getValue()).getManagers();
        if (collection == null) {
            FileTemplatesLoader.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    FTManager getDefaultTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Default"));
    }

    @NotNull
    FTManager getInternalTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Internal"));
    }

    @NotNull
    FTManager getPatternsManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Includes"));
    }

    @NotNull
    FTManager getCodeTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("Code"));
    }

    @NotNull
    FTManager getJ2eeTemplatesManager() {
        return new FTManager(((LoadedConfiguration)this.myManagers.getValue()).getManager("J2EE"));
    }

    URL getDefaultTemplateDescription() {
        return ((LoadedConfiguration)this.myManagers.getValue()).defaultTemplateDescription;
    }

    URL getDefaultIncludeDescription() {
        return ((LoadedConfiguration)this.myManagers.getValue()).defaultIncludeDescription;
    }

    private static LoadedConfiguration loadConfiguration(@Nullable Project project) {
        Path configDir = project == null || project.isDefault() ? PathManager.getConfigDir().resolve("fileTemplates") : ProjectKt.getStateStore(project).getProjectFilePath().getParent().resolve("fileTemplates");
        FileTemplateLoadResult result2 = FileTemplatesLoader.loadDefaultTemplates(new ArrayList<String>(MANAGER_TO_DIR.values()));
        HashMap<String, FTManager> managers = new HashMap<String, FTManager>();
        for (Map.Entry<String, String> entry : MANAGER_TO_DIR.entrySet()) {
            String name = entry.getKey();
            String pathPrefix = entry.getValue();
            FTManager manager = new FTManager(name, configDir.resolve(pathPrefix), name.equals("Internal"));
            manager.setDefaultTemplates(result2.getResult().get((Object)pathPrefix));
            manager.loadCustomizedContent();
            managers.put(name, manager);
        }
        return new LoadedConfiguration(managers, result2.getDefaultTemplateDescription(), result2.getDefaultIncludeDescription());
    }

    @NotNull
    private static FileTemplateLoadResult loadDefaultTemplates(@NotNull List<String> prefixes) {
        if (prefixes == null) {
            FileTemplatesLoader.$$$reportNull$$$0(1);
        }
        FileTemplateLoadResult result2 = new FileTemplateLoadResult((MultiMap<String, DefaultTemplate>)new MultiMap());
        HashSet<URL> processedUrls = new HashSet<URL>();
        HashSet<ClassLoader> processedLoaders = new HashSet<ClassLoader>();
        for (IdeaPluginDescriptorImpl plugin2 : PluginManagerCore.getLoadedPlugins(null)) {
            ClassLoader loader2 = plugin2.getPluginClassLoader();
            if (loader2 instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)loader2).getUrls().isEmpty() || !processedLoaders.add(loader2)) continue;
            try {
                Enumeration<URL> systemResources = loader2.getResources("fileTemplates");
                if (!systemResources.hasMoreElements()) continue;
                while (systemResources.hasMoreElements()) {
                    URL url = systemResources.nextElement();
                    if (!processedUrls.add(url)) continue;
                    FileTemplatesLoader.loadDefaultsFromRoot(url, prefixes, result2);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        FileTemplateLoadResult fileTemplateLoadResult = result2;
        if (fileTemplateLoadResult == null) {
            FileTemplatesLoader.$$$reportNull$$$0(2);
        }
        return fileTemplateLoadResult;
    }

    private static void loadDefaultsFromRoot(@NotNull URL root, @NotNull List<String> prefixes, @NotNull FileTemplateLoadResult result2) throws IOException {
        List<String> children2;
        if (root == null) {
            FileTemplatesLoader.$$$reportNull$$$0(3);
        }
        if (prefixes == null) {
            FileTemplatesLoader.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            FileTemplatesLoader.$$$reportNull$$$0(5);
        }
        if ((children2 = UrlUtil.getChildrenRelativePaths(root)).isEmpty()) {
            return;
        }
        HashSet<String> descriptionPaths = new HashSet<String>();
        for (String path : children2) {
            if (path.equals("default.html")) {
                result2.setDefaultTemplateDescription(UrlUtilRt.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path)));
                continue;
            }
            if (path.equals("includes/default.html")) {
                result2.setDefaultIncludeDescription(UrlUtilRt.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path)));
                continue;
            }
            if (!path.endsWith(DESCRIPTION_EXTENSION_SUFFIX)) continue;
            descriptionPaths.add(path);
        }
        block1: for (String path : children2) {
            if (!path.endsWith(".ft")) continue;
            for (String prefix : prefixes) {
                URL descriptionUrl;
                if (!FileTemplatesLoader.matchesPrefix(path, prefix)) continue;
                String filename = path.substring(prefix.isEmpty() ? 0 : prefix.length() + 1, path.length() - ".ft".length());
                String extension = FileUtilRt.getExtension((String)filename);
                String templateName = filename.substring(0, filename.length() - extension.length() - 1);
                URL templateUrl = UrlUtilRt.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path));
                String descriptionPath = FileTemplatesLoader.getDescriptionPath(prefix, templateName, extension, descriptionPaths);
                URL uRL = descriptionUrl = descriptionPath == null ? null : UrlUtilRt.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + descriptionPath));
                assert (templateUrl != null);
                result2.getResult().putValue((Object)prefix, (Object)new DefaultTemplate(templateName, extension, templateUrl, descriptionUrl));
                continue block1;
            }
        }
    }

    private static boolean matchesPrefix(@NotNull String path, @NotNull String prefix) {
        if (path == null) {
            FileTemplatesLoader.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            FileTemplatesLoader.$$$reportNull$$$0(7);
        }
        if (prefix.isEmpty()) {
            return path.indexOf(47) == -1;
        }
        return FileUtil.startsWith((String)path, (String)prefix) && path.indexOf(47, prefix.length() + 1) == -1;
    }

    @Nullable
    private static String getDescriptionPath(@NotNull String pathPrefix, @NotNull String templateName, @NotNull String templateExtension, @NotNull Set<String> descriptionPaths) {
        Object descPath;
        if (pathPrefix == null) {
            FileTemplatesLoader.$$$reportNull$$$0(8);
        }
        if (templateName == null) {
            FileTemplatesLoader.$$$reportNull$$$0(9);
        }
        if (templateExtension == null) {
            FileTemplatesLoader.$$$reportNull$$$0(10);
        }
        if (descriptionPaths == null) {
            FileTemplatesLoader.$$$reportNull$$$0(11);
        }
        Locale locale = Locale.getDefault();
        Object descName = MessageFormat.format("{0}.{1}_{2}_{3}.html", templateName, templateExtension, locale.getLanguage(), locale.getCountry());
        Object object = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + "/" + (String)descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = MessageFormat.format("{0}.{1}_{2}.html", templateName, templateExtension, locale.getLanguage());
        Object object2 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + "/" + (String)descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = templateName + "." + templateExtension + DESCRIPTION_EXTENSION_SUFFIX;
        Object object3 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + "/" + (String)descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathPrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExtension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllManagers";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadDefaultTemplates";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadDefaultsFromRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchesPrefix";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoadedConfiguration {
        public final URL defaultTemplateDescription;
        public final URL defaultIncludeDescription;
        private final Map<String, FTManager> myManagers;

        LoadedConfiguration(@NotNull Map<String, FTManager> managers, URL defaultTemplateDescription, URL defaultIncludeDescription) {
            if (managers == null) {
                LoadedConfiguration.$$$reportNull$$$0(0);
            }
            this.myManagers = Collections.unmodifiableMap(managers);
            this.defaultTemplateDescription = defaultTemplateDescription;
            this.defaultIncludeDescription = defaultIncludeDescription;
        }

        public FTManager getManager(@NotNull String kind) {
            if (kind == null) {
                LoadedConfiguration.$$$reportNull$$$0(1);
            }
            return this.myManagers.get(kind);
        }

        public Collection<FTManager> getManagers() {
            return this.myManagers.values();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "managers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplatesLoader$LoadedConfiguration";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getManager";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

