/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef;

import com.intellij.internal.jcef.CookieManagerDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;

public class WebBrowser
extends AnAction
implements DumbAware {
    private static final String URL = "http://maps.google.com";
    private static final String myTitle = "Web Browser - JCEF";
    private static final String myCookieManagerText = "Cookie Manager";

    public void actionPerformed(@NotNull AnActionEvent e) {
        Window activeFrame;
        if (e == null) {
            WebBrowser.$$$reportNull$$$0(0);
        }
        if ((activeFrame = IdeFrameImpl.getActiveFrame()) == null) {
            return;
        }
        if (!JBCefApp.isSupported()) {
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)new JTextArea("Set the reg key to enable JCEF:\n\"ide.browser.jcef.enabled=true\""), null).setTitle("JCEF Web Browser Is not Supported").createPopup().showInCenterOf((Component)activeFrame);
            return;
        }
        Rectangle bounds2 = activeFrame.getGraphicsConfiguration().getBounds();
        final IdeFrameImpl frame = new IdeFrameImpl();
        ((Frame)frame).setTitle(myTitle);
        frame.setDefaultCloseOperation(2);
        frame.setBounds(bounds2.width / 4, bounds2.height / 4, bounds2.width / 2, bounds2.height / 2);
        frame.setLayout(new BorderLayout());
        final JBCefBrowser myJBCefBrowser = new JBCefBrowser(URL);
        final CookieManagerDialog myCookieManagerDialog = new CookieManagerDialog((Frame)frame, myJBCefBrowser);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Disposer.dispose((Disposable)myJBCefBrowser);
            }
        });
        myJBCefBrowser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadStart(CefBrowser browser2, CefFrame frame, CefRequest.TransitionType transitionType) {
                myCookieManagerDialog.setVisible(false);
            }
        }, myJBCefBrowser.getCefBrowser());
        frame.add((Component)myJBCefBrowser.getComponent(), "Center");
        final JTextField myUrlBar = new JTextField(URL);
        myUrlBar.addActionListener(event -> myJBCefBrowser.loadURL(myUrlBar.getText()));
        frame.add((Component)myUrlBar, "North");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton myShowCookieManagerButton = new JButton(myCookieManagerText);
        myShowCookieManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                myCookieManagerDialog.setVisible(true);
                List cookies = myJBCefBrowser.getJBCefCookieManager().getCookies();
                if (cookies != null) {
                    myCookieManagerDialog.update(cookies);
                }
            }
        });
        controlPanel.add(myShowCookieManagerButton);
        frame.add((Component)controlPanel, "South");
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu menu = new JMenu("Tools");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Load HTML with URL");
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog2 = new JDialog((Frame)frame, "Load HTML with URL");
                JPanel panel2 = new JPanel();
                JTextField url = new JTextField("file://");
                JTextArea html = new JTextArea("<html>\n</html>");
                JPanel buttonPanel = new JPanel();
                JButton cancelButton = new JButton("Cancel");
                cancelButton.addActionListener(ae -> dialog2.dispose());
                JButton loadButton = new JButton("Load");
                loadButton.addActionListener(ae -> {
                    dialog2.dispose();
                    myUrlBar.setText(url.getText());
                    SwingUtilities.invokeLater(() -> myJBCefBrowser.loadHTML(html.getText(), url.getText()));
                });
                buttonPanel.add(cancelButton);
                buttonPanel.add(loadButton);
                dialog2.add(panel2);
                panel2.setLayout(new BorderLayout());
                panel2.add((Component)url, "North");
                panel2.add((Component)html, "Center");
                panel2.add((Component)buttonPanel, "South");
                dialog2.setSize(640, 480);
                dialog2.setLocationRelativeTo(null);
                dialog2.setVisible(true);
            }
        });
        frame.setVisible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/jcef/WebBrowser", "actionPerformed"));
    }
}

