/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.model;

import com.intellij.openapi.editor.richcopy.model.ColorRegistry;
import com.intellij.openapi.editor.richcopy.model.FontNameRegistry;
import com.intellij.openapi.editor.richcopy.model.MarkupHandler;
import com.intellij.openapi.editor.richcopy.model.OutputInfoSerializer;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class SyntaxInfo {
    private final int myOutputInfoCount;
    private final byte[] myOutputInfosSerialized;
    @NotNull
    private final ColorRegistry myColorRegistry;
    @NotNull
    private final FontNameRegistry myFontNameRegistry;
    private final int myDefaultForeground;
    private final int myDefaultBackground;
    private final float myFontSize;

    private SyntaxInfo(int outputInfoCount, byte[] outputInfosSerialized, int defaultForeground, int defaultBackground, float fontSize, @NotNull FontNameRegistry fontNameRegistry, @NotNull ColorRegistry colorRegistry) {
        if (fontNameRegistry == null) {
            SyntaxInfo.$$$reportNull$$$0(0);
        }
        if (colorRegistry == null) {
            SyntaxInfo.$$$reportNull$$$0(1);
        }
        this.myOutputInfoCount = outputInfoCount;
        this.myOutputInfosSerialized = outputInfosSerialized;
        this.myDefaultForeground = defaultForeground;
        this.myDefaultBackground = defaultBackground;
        this.myFontSize = fontSize;
        this.myFontNameRegistry = fontNameRegistry;
        this.myColorRegistry = colorRegistry;
    }

    @NotNull
    public ColorRegistry getColorRegistry() {
        ColorRegistry colorRegistry = this.myColorRegistry;
        if (colorRegistry == null) {
            SyntaxInfo.$$$reportNull$$$0(2);
        }
        return colorRegistry;
    }

    @NotNull
    public FontNameRegistry getFontNameRegistry() {
        FontNameRegistry fontNameRegistry = this.myFontNameRegistry;
        if (fontNameRegistry == null) {
            SyntaxInfo.$$$reportNull$$$0(3);
        }
        return fontNameRegistry;
    }

    public int getDefaultForeground() {
        return this.myDefaultForeground;
    }

    public int getDefaultBackground() {
        return this.myDefaultBackground;
    }

    public float getFontSize() {
        return this.myFontSize;
    }

    public void processOutputInfo(MarkupHandler handler2) {
        MarkupIterator it = new MarkupIterator();
        try {
            while (it.hasNext()) {
                it.processNext(handler2);
                if (handler2.canHandleMore()) continue;
                break;
            }
        }
        finally {
            it.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        final StringBuilder b = new StringBuilder();
        b.append("default colors: foreground=").append(this.myDefaultForeground).append(", background=").append(this.myDefaultBackground).append("; output infos: ");
        boolean first = true;
        MarkupIterator it = new MarkupIterator();
        try {
            while (it.hasNext()) {
                if (first) {
                    b.append(',');
                }
                it.processNext(new MarkupHandler(){

                    @Override
                    public void handleText(int startOffset, int endOffset) throws Exception {
                        b.append("text(").append(startOffset).append(",").append(endOffset).append(")");
                    }

                    @Override
                    public void handleForeground(int foregroundId) throws Exception {
                        b.append("foreground(").append(foregroundId).append(")");
                    }

                    @Override
                    public void handleBackground(int backgroundId) throws Exception {
                        b.append("background(").append(backgroundId).append(")");
                    }

                    @Override
                    public void handleFont(int fontNameId) throws Exception {
                        b.append("font(").append(fontNameId).append(")");
                    }

                    @Override
                    public void handleStyle(int style) throws Exception {
                        b.append("style(").append(style).append(")");
                    }

                    @Override
                    public boolean canHandleMore() {
                        return true;
                    }
                });
                first = false;
            }
            String string = b.toString();
            return string;
        }
        finally {
            it.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontNameRegistry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorRegistry";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/model/SyntaxInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/model/SyntaxInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorRegistry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontNameRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MarkupIterator {
        private int pos;
        private final OutputInfoSerializer.InputStream myOutputInfoStream;

        public MarkupIterator() {
            this.myOutputInfoStream = new OutputInfoSerializer.InputStream(new ByteArrayInputStream(SyntaxInfo.this.myOutputInfosSerialized));
        }

        public boolean hasNext() {
            return this.pos < SyntaxInfo.this.myOutputInfoCount;
        }

        public void processNext(MarkupHandler handler2) {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            ++this.pos;
            try {
                this.myOutputInfoStream.read(handler2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void dispose() {
            try {
                this.myOutputInfoStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Builder {
        private final ColorRegistry myColorRegistry = new ColorRegistry();
        private final FontNameRegistry myFontNameRegistry = new FontNameRegistry();
        private final int myDefaultForeground;
        private final int myDefaultBackground;
        private final float myFontSize;
        private final ByteArrayOutputStream myStream = new ByteArrayOutputStream();
        private final OutputInfoSerializer.OutputStream myOutputInfoStream;
        private int myOutputInfoCount;

        public Builder(Color defaultForeground, Color defaultBackground, float fontSize) {
            this.myDefaultForeground = this.myColorRegistry.getId(defaultForeground);
            this.myDefaultBackground = this.myColorRegistry.getId(defaultBackground);
            this.myFontSize = fontSize;
            this.myOutputInfoStream = new OutputInfoSerializer.OutputStream(this.myStream);
        }

        public void addFontStyle(int fontStyle) {
            try {
                this.myOutputInfoStream.handleStyle(fontStyle);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.myOutputInfoCount;
        }

        public void addFontFamilyName(String fontFamilyName) {
            try {
                this.myOutputInfoStream.handleFont(this.myFontNameRegistry.getId(fontFamilyName));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.myOutputInfoCount;
        }

        public void addForeground(Color foreground) {
            try {
                this.myOutputInfoStream.handleForeground(this.myColorRegistry.getId(foreground));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.myOutputInfoCount;
        }

        public void addBackground(Color background) {
            try {
                this.myOutputInfoStream.handleBackground(this.myColorRegistry.getId(background));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.myOutputInfoCount;
        }

        public void addText(int startOffset, int endOffset) {
            try {
                this.myOutputInfoStream.handleText(startOffset, endOffset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.myOutputInfoCount;
        }

        public SyntaxInfo build() {
            this.myColorRegistry.seal();
            this.myFontNameRegistry.seal();
            try {
                this.myOutputInfoStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new SyntaxInfo(this.myOutputInfoCount, this.myStream.toByteArray(), this.myDefaultForeground, this.myDefaultBackground, this.myFontSize, this.myFontNameRegistry, this.myColorRegistry);
        }
    }
}

