/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.impl.source.tree.injected.ListenerWrapperMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CaretModelWindow
implements CaretModel {
    private final CaretModel myDelegate;
    private final EditorEx myHostEditor;
    private final EditorWindow myEditorWindow;
    private final Map<Caret, InjectedCaret> myInjectedCaretMap = new WeakHashMap<Caret, InjectedCaret>();
    private final ListenerWrapperMap<CaretListener> myCaretListeners = new ListenerWrapperMap();

    CaretModelWindow(CaretModel delegate, EditorWindow editorWindow) {
        this.myDelegate = delegate;
        this.myHostEditor = (EditorEx)editorWindow.getDelegate();
        this.myEditorWindow = editorWindow;
    }

    public void addCaretListener(final @NotNull CaretListener listener2) {
        if (listener2 == null) {
            CaretModelWindow.$$$reportNull$$$0(0);
        }
        CaretListener wrapper2 = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!CaretModelWindow.this.myEditorWindow.getDocument().isValid()) {
                    return;
                }
                Caret caret = e.getCaret();
                assert (caret != null);
                CaretEvent event = new CaretEvent((Caret)CaretModelWindow.this.createInjectedCaret(caret), CaretModelWindow.this.myEditorWindow.hostToInjected(e.getOldPosition()), CaretModelWindow.this.myEditorWindow.hostToInjected(e.getNewPosition()));
                listener2.caretPositionChanged(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/source/tree/injected/CaretModelWindow$1", "caretPositionChanged"));
            }
        };
        this.myCaretListeners.registerWrapper(listener2, wrapper2);
        this.myDelegate.addCaretListener(wrapper2);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        CaretListener wrapper2;
        if (listener2 == null) {
            CaretModelWindow.$$$reportNull$$$0(1);
        }
        if ((wrapper2 = this.myCaretListeners.removeWrapper(listener2)) != null) {
            this.myDelegate.removeCaretListener(wrapper2);
        }
    }

    public void disposeModel() {
        for (CaretListener wrapper2 : this.myCaretListeners.wrappers()) {
            this.myDelegate.removeCaretListener(wrapper2);
        }
        this.myCaretListeners.clear();
    }

    public TextAttributes getTextAttributes() {
        return this.myDelegate.getTextAttributes();
    }

    public boolean supportsMultipleCarets() {
        return this.myDelegate.supportsMultipleCarets();
    }

    public int getMaxCaretCount() {
        return this.myDelegate.getMaxCaretCount();
    }

    @NotNull
    public Caret getCurrentCaret() {
        InjectedCaret injectedCaret = this.createInjectedCaret(this.myDelegate.getCurrentCaret());
        if (injectedCaret == null) {
            CaretModelWindow.$$$reportNull$$$0(2);
        }
        return injectedCaret;
    }

    @NotNull
    public Caret getPrimaryCaret() {
        InjectedCaret injectedCaret = this.createInjectedCaret(this.myDelegate.getPrimaryCaret());
        if (injectedCaret == null) {
            CaretModelWindow.$$$reportNull$$$0(3);
        }
        return injectedCaret;
    }

    public int getCaretCount() {
        return this.myDelegate.getCaretCount();
    }

    @NotNull
    public List<Caret> getAllCarets() {
        List hostCarets = this.myDelegate.getAllCarets();
        ArrayList<Caret> carets = new ArrayList<Caret>(hostCarets.size());
        for (Caret hostCaret : hostCarets) {
            carets.add(this.createInjectedCaret(hostCaret));
        }
        ArrayList<Caret> arrayList = carets;
        if (arrayList == null) {
            CaretModelWindow.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(5);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        Caret caret = this.myDelegate.getCaretAt(this.myHostEditor.logicalToVisualPosition(hostPos));
        return this.createInjectedCaret(caret);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(6);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(this.myEditorWindow.visualToLogicalPosition(pos));
        Caret caret = this.myDelegate.addCaret(this.myHostEditor.logicalToVisualPosition(hostPos));
        return this.createInjectedCaret(caret);
    }

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition pos, boolean makePrimary) {
        if (pos == null) {
            CaretModelWindow.$$$reportNull$$$0(7);
        }
        LogicalPosition hostPos = this.myEditorWindow.injectedToHost(pos);
        Caret caret = this.myDelegate.addCaret(hostPos, makePrimary);
        return this.createInjectedCaret(caret);
    }

    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelWindow.$$$reportNull$$$0(8);
        }
        if (caret instanceof InjectedCaret) {
            caret = ((InjectedCaret)caret).myDelegate;
        }
        return this.myDelegate.removeCaret(caret);
    }

    public void removeSecondaryCarets() {
        this.myDelegate.removeSecondaryCarets();
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates) {
        if (caretStates == null) {
            CaretModelWindow.$$$reportNull$$$0(9);
        }
        List<CaretState> convertedStates = this.convertCaretStates(caretStates);
        this.myDelegate.setCaretsAndSelections(convertedStates);
    }

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> caretStates, boolean updateSystemSelection) {
        if (caretStates == null) {
            CaretModelWindow.$$$reportNull$$$0(10);
        }
        List<CaretState> convertedStates = this.convertCaretStates(caretStates);
        this.myDelegate.setCaretsAndSelections(convertedStates, updateSystemSelection);
    }

    private List<CaretState> convertCaretStates(List<? extends CaretState> caretStates) {
        ArrayList<CaretState> convertedStates = new ArrayList<CaretState>(caretStates.size());
        for (CaretState caretState : caretStates) {
            convertedStates.add(new CaretState(this.injectedToHost(caretState.getCaretPosition()), this.injectedToHost(caretState.getSelectionStart()), this.injectedToHost(caretState.getSelectionEnd())));
        }
        return convertedStates;
    }

    private LogicalPosition injectedToHost(@Nullable LogicalPosition position) {
        return position == null ? null : this.myEditorWindow.injectedToHost(position);
    }

    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        List caretsAndSelections = this.myDelegate.getCaretsAndSelections();
        ArrayList<CaretState> convertedStates = new ArrayList<CaretState>(caretsAndSelections.size());
        for (CaretState state : caretsAndSelections) {
            convertedStates.add(new CaretState(this.hostToInjected(state.getCaretPosition()), this.hostToInjected(state.getSelectionStart()), this.hostToInjected(state.getSelectionEnd())));
        }
        ArrayList<CaretState> arrayList = convertedStates;
        if (arrayList == null) {
            CaretModelWindow.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private LogicalPosition hostToInjected(@Nullable LogicalPosition position) {
        return position == null ? null : this.myEditorWindow.hostToInjected(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="null -> null; !null -> !null")
    private InjectedCaret createInjectedCaret(Caret caret) {
        if (caret == null) {
            return null;
        }
        Map<Caret, InjectedCaret> map2 = this.myInjectedCaretMap;
        synchronized (map2) {
            InjectedCaret injectedCaret = this.myInjectedCaretMap.get(caret);
            if (injectedCaret == null) {
                injectedCaret = new InjectedCaret(this.myEditorWindow, caret);
                this.myInjectedCaretMap.put(caret, injectedCaret);
            }
            return injectedCaret;
        }
    }

    public void runForEachCaret(@NotNull CaretAction action2) {
        if (action2 == null) {
            CaretModelWindow.$$$reportNull$$$0(12);
        }
        this.myDelegate.runForEachCaret(caret -> action2.perform((Caret)this.createInjectedCaret(caret)));
    }

    public void runForEachCaret(@NotNull CaretAction action2, boolean reverseOrder) {
        if (action2 == null) {
            CaretModelWindow.$$$reportNull$$$0(13);
        }
        this.myDelegate.runForEachCaret(caret -> action2.perform((Caret)this.createInjectedCaret(caret)), reverseOrder);
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable2) {
        if (listener2 == null) {
            CaretModelWindow.$$$reportNull$$$0(14);
        }
        if (disposable2 == null) {
            CaretModelWindow.$$$reportNull$$$0(15);
        }
        this.myDelegate.addCaretActionListener(listener2, disposable2);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CaretModelWindow.$$$reportNull$$$0(16);
        }
        this.myDelegate.runBatchCaretOperation(runnable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/CaretModelWindow";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStates";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/CaretModelWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeCaret";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCaretsAndSelections";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCaretActionListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

