/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.util.AbstractVariableData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDuplicatesFinder {
    private static final Key<PsiElement> PARAMETER = Key.create((String)"PARAMETER");
    protected PsiElement myReplacement;
    private final ArrayList<PsiElement> myPattern;
    private final Set<String> myParameters;
    private final Collection<String> myOutputVariables;

    public SimpleDuplicatesFinder(@NotNull PsiElement statement1, @NotNull PsiElement statement2, Collection<String> variables, AbstractVariableData[] variableData) {
        if (statement1 == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(0);
        }
        if (statement2 == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(1);
        }
        this.myOutputVariables = variables;
        this.myParameters = new HashSet<String>();
        for (AbstractVariableData data2 : variableData) {
            this.myParameters.add(data2.getOriginalName());
        }
        this.myPattern = new ArrayList();
        PsiElement sibling = statement1;
        do {
            this.myPattern.add(sibling);
        } while (sibling != statement2 && (sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)sibling)) != null);
    }

    public List<SimpleMatch> findDuplicates(@Nullable List<PsiElement> scope, @NotNull PsiElement generatedMethod) {
        if (generatedMethod == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(2);
        }
        ArrayList<SimpleMatch> result2 = new ArrayList<SimpleMatch>();
        this.annotatePattern();
        if (scope != null) {
            for (PsiElement element2 : scope) {
                this.findPatternOccurrences(result2, element2, generatedMethod);
            }
        }
        this.deannotatePattern();
        return result2;
    }

    private void deannotatePattern() {
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element2.getUserData(PARAMETER) != null) {
                        element2.putUserData(PARAMETER, null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder$1", "visitElement"));
                }
            });
        }
    }

    private void annotatePattern() {
        for (PsiElement patternComponent : this.myPattern) {
            patternComponent.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                public void visitElement(@NotNull PsiElement element2) {
                    if (element2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element2);
                    if (SimpleDuplicatesFinder.this.myParameters.contains(element2.getText())) {
                        element2.putUserData(PARAMETER, (Object)element2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder$2", "visitElement"));
                }
            });
        }
    }

    private void findPatternOccurrences(@NotNull List<? super SimpleMatch> array2, @NotNull PsiElement scope, @NotNull PsiElement generatedMethod) {
        PsiElement[] children2;
        if (array2 == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(4);
        }
        if (generatedMethod == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(5);
        }
        if (scope == generatedMethod) {
            return;
        }
        for (PsiElement child2 : children2 = scope.getChildren()) {
            SimpleMatch match2 = this.isDuplicateFragment(child2);
            if (match2 != null) {
                array2.add(match2);
                continue;
            }
            this.findPatternOccurrences(array2, child2, generatedMethod);
        }
    }

    @Nullable
    protected SimpleMatch isDuplicateFragment(@NotNull PsiElement candidate) {
        if (candidate == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(6);
        }
        if (!this.canReplace(this.myReplacement, candidate)) {
            return null;
        }
        for (PsiElement pattern : this.myPattern) {
            if (!PsiTreeUtil.isAncestor((PsiElement)pattern, (PsiElement)candidate, (boolean)false)) continue;
            return null;
        }
        PsiElement sibling = candidate;
        ArrayList<PsiElement> candidates = new ArrayList<PsiElement>();
        for (int i2 = 0; i2 != this.myPattern.size(); ++i2) {
            if (sibling == null) {
                return null;
            }
            candidates.add(sibling);
            sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)sibling);
        }
        if (this.myPattern.size() != candidates.size()) {
            return null;
        }
        if (candidates.size() <= 0) {
            return null;
        }
        SimpleMatch match2 = new SimpleMatch((PsiElement)candidates.get(0), (PsiElement)candidates.get(candidates.size() - 1));
        for (int i3 = 0; i3 < this.myPattern.size(); ++i3) {
            if (this.matchPattern(this.myPattern.get(i3), (PsiElement)candidates.get(i3), match2)) continue;
            return null;
        }
        return match2;
    }

    private boolean matchPattern(@Nullable PsiElement pattern, @Nullable PsiElement candidate, @NotNull SimpleMatch match2) {
        if (match2 == null) {
            SimpleDuplicatesFinder.$$$reportNull$$$0(7);
        }
        ProgressManager.checkCanceled();
        if (pattern == null || candidate == null) {
            return pattern == candidate;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren((PsiElement)pattern, null, (boolean)true);
        PsiElement[] children2 = PsiEquivalenceUtil.getFilteredChildren((PsiElement)candidate, null, (boolean)true);
        PsiElement patternParent = pattern.getParent();
        PsiElement candidateParent = candidate.getParent();
        if (patternParent == null || candidateParent == null) {
            return false;
        }
        if (pattern.getUserData(PARAMETER) != null && patternParent.getClass() == candidateParent.getClass()) {
            match2.changeParameter(pattern.getText(), candidate.getText());
            return true;
        }
        if (children1.length != children2.length) {
            return false;
        }
        for (int i2 = 0; i2 < children1.length; ++i2) {
            PsiElement child1 = children1[i2];
            PsiElement child2 = children2[i2];
            if (this.matchPattern(child1, child2, match2)) continue;
            return false;
        }
        if (children1.length == 0) {
            if (pattern.getUserData(PARAMETER) != null && patternParent.getClass() == candidateParent.getClass()) {
                match2.changeParameter(pattern.getText(), candidate.getText());
                return true;
            }
            if (this.myOutputVariables.contains(pattern.getText())) {
                match2.changeOutput(candidate.getText());
                return true;
            }
            if (!pattern.textMatches(candidate)) {
                return false;
            }
        }
        return true;
    }

    protected boolean canReplace(PsiElement replacement, PsiElement element2) {
        return !PsiTreeUtil.isAncestor((PsiElement)replacement, (PsiElement)element2, (boolean)false);
    }

    public void setReplacement(PsiElement replacement) {
        this.myReplacement = replacement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement2";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/SimpleDuplicatesFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findDuplicates";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findPatternOccurrences";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isDuplicateFragment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "matchPattern";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

