/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.agent.impl.CallerClassLoaderProvider;
import com.intellij.remoteServer.agent.impl.RemoteAgentClassLoaderCache;
import com.intellij.remoteServer.agent.impl.RemoteAgentProxyFactoryBase;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.Nullable;

public class RemoteAgentReflectiveProxyFactory
extends RemoteAgentProxyFactoryBase {
    private static final Logger LOG = Logger.getInstance(RemoteAgentReflectiveProxyFactory.class);
    private final RemoteAgentClassLoaderCache myClassLoaderCache;

    public RemoteAgentReflectiveProxyFactory(@Nullable RemoteAgentClassLoaderCache classLoaderCache, CallerClassLoaderProvider callerClassLoaderProvider) {
        super(callerClassLoaderProvider);
        this.myClassLoaderCache = classLoaderCache;
    }

    @Override
    protected ClassLoader createAgentClassLoader(URL[] agentLibraryUrls) throws Exception {
        HashSet<URL> urls = new HashSet<URL>();
        urls.addAll(Arrays.asList(agentLibraryUrls));
        return this.myClassLoaderCache == null ? RemoteAgentClassLoaderCache.createClassLoaderWithoutApplicationParent(urls) : this.myClassLoaderCache.getOrCreateClassLoader(urls);
    }

    @Override
    protected InvocationHandler createInvocationHandler(Object agentImpl, ClassLoader agentClassLoader, ClassLoader callerClassLoader) {
        return new ReflectiveInvocationHandler(agentImpl, agentClassLoader, callerClassLoader);
    }

    private static class Mirror {
        private final Class<?> myMirrorType;
        private final Object myMirrorValue;

        Mirror(Class<?> type, Object value2, ClassLoader classLoader, ClassLoader mirrorClassLoader) throws ClassNotFoundException {
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                Mirror componentMirror = new Mirror(componentType, null, classLoader, mirrorClassLoader);
                int length = value2 == null ? 0 : Array.getLength(value2);
                Object mirrorValue = Array.newInstance(componentMirror.getMirrorType(), length);
                for (int i2 = 0; i2 < length; ++i2) {
                    Mirror itemMirror = new Mirror(componentType, Array.get(value2, i2), classLoader, mirrorClassLoader);
                    Array.set(mirrorValue, i2, itemMirror.getMirrorValue());
                }
                this.myMirrorType = mirrorValue.getClass();
                this.myMirrorValue = value2 == null ? null : mirrorValue;
            } else if (type.isEnum()) {
                Class<?> mirroredEnum = mirrorClassLoader.loadClass(type.getName());
                this.myMirrorType = mirroredEnum;
                this.myMirrorValue = value2 == null ? null : Enum.valueOf(mirroredEnum, ((Enum)value2).name());
            } else if (type.isInterface()) {
                this.myMirrorType = mirrorClassLoader.loadClass(type.getName());
                this.myMirrorValue = value2 == null ? null : Proxy.newProxyInstance(mirrorClassLoader, new Class[]{this.myMirrorType}, (InvocationHandler)new ReflectiveInvocationHandler(value2, classLoader, mirrorClassLoader));
            } else {
                this.myMirrorType = type;
                this.myMirrorValue = value2;
            }
        }

        public Class<?> getMirrorType() {
            return this.myMirrorType;
        }

        public Object getMirrorValue() {
            return this.myMirrorValue;
        }
    }

    private static class ReflectiveInvocationHandler
    implements InvocationHandler {
        private final Object myTarget;
        private final ClassLoader myTargetClassLoader;
        private final ClassLoader mySourceClassLoader;

        ReflectiveInvocationHandler(Object target2, ClassLoader targetClassLoader, ClassLoader sourceClassLoader) {
            this.myTarget = target2;
            this.myTargetClassLoader = targetClassLoader;
            this.mySourceClassLoader = sourceClassLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object invoke(Object proxy, Method method2, Object[] args) {
            ClassLoader initialClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.myTargetClassLoader);
                Class<?>[] parameterTypes = method2.getParameterTypes();
                Class[] delegateParameterTypes = new Class[parameterTypes.length];
                Object[] delegateArgs = new Object[parameterTypes.length];
                for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
                    Mirror parameterMirror = new Mirror(parameterTypes[i2], args[i2], this.mySourceClassLoader, this.myTargetClassLoader);
                    delegateParameterTypes[i2] = parameterMirror.getMirrorType();
                    delegateArgs[i2] = parameterMirror.getMirrorValue();
                }
                Method delegateMethod = this.myTarget.getClass().getMethod(method2.getName(), delegateParameterTypes);
                delegateMethod.setAccessible(true);
                Object result2 = delegateMethod.invoke(this.myTarget, delegateArgs);
                Mirror resultMirror = new Mirror(delegateMethod.getReturnType(), result2, this.myTargetClassLoader, this.mySourceClassLoader);
                Object object = resultMirror.getMirrorValue();
                return object;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error((Throwable)e);
                Object var6_8 = null;
                return var6_8;
            }
            finally {
                Thread.currentThread().setContextClassLoader(initialClassLoader);
            }
        }
    }
}

