/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupListAdapter;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupTableAdapter;
import com.intellij.ui.popup.PopupTreeAdapter;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupFactoryImpl
extends JBPopupFactory {
    public static final Key<VisualPosition> ANCHOR_POPUP_POSITION = Key.create((String)"popup.anchor.position");
    public static final Key<Point> ANCHOR_POPUP_POINT = Key.create((String)"popup.anchor.point");
    private static final Logger LOG = Logger.getInstance(PopupFactoryImpl.class);
    private final Map<Disposable, List<Balloon>> myStorage = ContainerUtil.createWeakMap();

    @NotNull
    public <T> IPopupChooserBuilder<T> createPopupChooserBuilder(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(0);
        }
        return new PopupChooserBuilder((JList)new JBList((ListModel)new CollectionListModel(list2)));
    }

    @NotNull
    public ListPopup createConfirmation(@NlsContexts.PopupTitle String title, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(1);
        }
        return listPopup;
    }

    @NotNull
    public ListPopup createConfirmation(@NlsContexts.PopupTitle String title, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        ListPopup listPopup = this.createConfirmation(title, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    @NotNull
    public JBPopup createMessage(@NlsContexts.PopupTitle String text2) {
        ListPopup listPopup = this.createListPopup((ListPopupStep)new BaseListPopupStep(null, (Object[])new String[]{text2}));
        if (listPopup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(3);
        }
        return listPopup;
    }

    public Balloon getParentBalloonFor(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            Object balloon2;
            if (!(eachParent instanceof JComponent) || !((balloon2 = ((JComponent)eachParent).getClientProperty("Balloon.property")) instanceof Balloon)) continue;
            return (Balloon)balloon2;
        }
        return null;
    }

    protected <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> builder2, @NotNull JList<T> list2) {
        if (builder2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(4);
        }
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(5);
        }
        return new PopupListAdapter<T>(builder2, list2);
    }

    protected <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> builder2, @NotNull JTree tree) {
        if (builder2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(6);
        }
        if (tree == null) {
            PopupFactoryImpl.$$$reportNull$$$0(7);
        }
        return new PopupTreeAdapter(builder2, tree);
    }

    protected <T> // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PopupChooserBuilder.PopupComponentAdapter<T> createPopupComponentAdapter(@NotNull PopupChooserBuilder<T> builder2, @NotNull JTable table) {
        if (builder2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(8);
        }
        if (table == null) {
            PopupFactoryImpl.$$$reportNull$$$0(9);
        }
        return new PopupTableAdapter(builder2, table);
    }

    @NotNull
    public ListPopup createConfirmation(@NlsContexts.PopupTitle String title, final @NlsContexts.Label String yesText, @NlsContexts.Label String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(title, new String[]{yesText, noText}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(selectedValue.equals(yesText) ? onYes : onNo);
            }

            public void canceled() {
                onNo.run();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(defaultOptionIndex);
        Application app = ApplicationManager.getApplication();
        return app == null || !app.isUnitTestMode() ? new ListPopupImpl((ListPopupStep)step) : new MockConfirmation((ListPopupStep)step, yesText);
    }

    @NotNull
    private static Supplier<DataContext> getComponentContextSupplier(Component component2) {
        Supplier<DataContext> supplier2 = () -> DataManager.getInstance().getDataContext(component2);
        if (supplier2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(10);
        }
        return supplier2;
    }

    @NotNull
    public ListPopup createActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid aid, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(11);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(12);
        }
        return new ActionGroupPopup(title, actionGroup, dataContext, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING || aid == JBPopupFactory.ActionSelectionAid.NUMBERING, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, aid == JBPopupFactory.ActionSelectionAid.MNEMONICS, disposeCallback, maxRowCount, preselectActionCondition, actionPlace);
    }

    @NotNull
    public ListPopup createActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(13);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(14);
        }
        return new ActionGroupPopup(title, actionGroup, dataContext, showNumbers, true, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, null);
    }

    @NotNull
    public ListPopupStep<ActionItem> createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, @Nullable String actionPlace, boolean showNumbers, boolean showDisabledActions, @NlsContexts.PopupTitle String title, Component component2, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        if (actionGroup == null) {
            PopupFactoryImpl.$$$reportNull$$$0(15);
        }
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(16);
        }
        ListPopupStep<ActionItem> listPopupStep = ActionPopupStep.createActionsStep(actionGroup, dataContext, showNumbers, true, showDisabledActions, title, honorActionMnemonics, autoSelectionEnabled, PopupFactoryImpl.getComponentContextSupplier(component2), actionPlace, null, defaultOptionIndex, null);
        if (listPopupStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(17);
        }
        return listPopupStep;
    }

    private static boolean itemsHaveMnemonics(List<? extends ActionItem> items) {
        for (ActionItem actionItem : items) {
            if (actionItem.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(18);
        }
        return new ListPopupImpl(step);
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step, int maxRowCount) {
        if (step == null) {
            PopupFactoryImpl.$$$reportNull$$$0(19);
        }
        ListPopupImpl popup2 = new ListPopupImpl(step);
        popup2.setMaxRowCount(maxRowCount);
        ListPopupImpl listPopupImpl = popup2;
        if (listPopupImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(20);
        }
        return listPopupImpl;
    }

    @NotNull
    public TreePopup createTree(JBPopup parent, @NotNull TreePopupStep aStep, Object parentValue) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(21);
        }
        return new TreePopupImpl(aStep.getProject(), parent, (TreePopupStep<Object>)aStep, parentValue);
    }

    @NotNull
    public TreePopup createTree(@NotNull TreePopupStep aStep) {
        if (aStep == null) {
            PopupFactoryImpl.$$$reportNull$$$0(22);
        }
        return new TreePopupImpl(aStep.getProject(), null, (TreePopupStep<Object>)aStep, null);
    }

    @NotNull
    public ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent content2, JComponent preferableFocusComponent) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(23);
        }
        return new ComponentPopupBuilderImpl(content2, preferableFocusComponent);
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull DataContext dataContext) {
        Point point;
        Component component2;
        JComponent focusOwner;
        if (dataContext == null) {
            PopupFactoryImpl.$$$reportNull$$$0(24);
        }
        JComponent jComponent = focusOwner = (component2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)) instanceof JComponent ? (JComponent)component2 : null;
        if (focusOwner == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            JFrame frame = project == null ? null : WindowManager.getInstance().getFrame(project);
            JComponent jComponent2 = focusOwner = frame == null ? null : frame.getRootPane();
            if (focusOwner == null) {
                throw new IllegalArgumentException("focusOwner cannot be null");
            }
        }
        if ((point = (Point)PlatformDataKeys.CONTEXT_MENU_POINT.getData(dataContext)) != null) {
            return new RelativePoint((Component)focusOwner, point);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && focusOwner == editor.getContentComponent()) {
            RelativePoint relativePoint = this.guessBestPopupLocation(editor);
            if (relativePoint == null) {
                PopupFactoryImpl.$$$reportNull$$$0(25);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = this.guessBestPopupLocation(focusOwner);
        if (relativePoint == null) {
            PopupFactoryImpl.$$$reportNull$$$0(26);
        }
        return relativePoint;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull JComponent component2) {
        if (component2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(27);
        }
        Point popupMenuPoint = null;
        Rectangle visibleRect = component2.getVisibleRect();
        if (component2 instanceof JList) {
            int[] selectedIndices;
            JList list2 = (JList)component2;
            int firstVisibleIndex = list2.getFirstVisibleIndex();
            int lastVisibleIndex = list2.getLastVisibleIndex();
            for (int index : selectedIndices = list2.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list2.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height - 1);
                break;
            }
        } else if (component2 instanceof JTree) {
            JTree tree = (JTree)component2;
            TreePath[] paths = tree.getSelectionPaths();
            if (paths != null && paths.length > 0) {
                TreePath pathFound = null;
                int distanceFound = Integer.MAX_VALUE;
                int center = visibleRect.y + visibleRect.height / 2;
                for (TreePath path : paths) {
                    int distance2;
                    Rectangle bounds2 = tree.getPathBounds(path);
                    if (bounds2 == null || (distance2 = Math.abs(bounds2.y + bounds2.height / 2 - center)) >= distanceFound) continue;
                    popupMenuPoint = new Point(bounds2.x + 2, bounds2.y + bounds2.height - 1);
                    distanceFound = distance2;
                    pathFound = path;
                }
                if (pathFound != null) {
                    TreeUtil.scrollToVisible((JTree)tree, pathFound, (boolean)false);
                }
            }
        } else if (component2 instanceof JTable) {
            JTable table = (JTable)component2;
            int column = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int row = Math.max(table.getSelectionModel().getLeadSelectionIndex(), table.getSelectionModel().getAnchorSelectionIndex());
            Rectangle rect = table.getCellRect(row, column, false);
            if (!visibleRect.intersects(rect)) {
                table.scrollRectToVisible(rect);
            }
            popupMenuPoint = new Point(rect.x, rect.y + rect.height - 1);
        } else if (component2 instanceof PopupOwner) {
            popupMenuPoint = ((PopupOwner)((Object)component2)).getBestPopupPosition();
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        return new RelativePoint((Component)component2, popupMenuPoint);
    }

    public boolean isBestPopupLocationVisible(@NotNull Editor editor) {
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(28);
        }
        return PopupFactoryImpl.getVisibleBestPopupLocation(editor) != null;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        Point p;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(29);
        }
        if ((p = PopupFactoryImpl.getVisibleBestPopupLocation(editor)) == null) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            p = new Point(visibleArea.x + visibleArea.width / 3, visibleArea.y + visibleArea.height / 2);
        }
        return new RelativePoint((Component)editor.getContentComponent(), p);
    }

    @Nullable
    private static Point getVisibleBestPopupLocation(@NotNull Editor editor) {
        Rectangle visibleArea;
        if (editor == null) {
            PopupFactoryImpl.$$$reportNull$$$0(30);
        }
        int lineHeight = editor.getLineHeight();
        Point p = (Point)editor.getUserData(ANCHOR_POPUP_POINT);
        if (p == null) {
            VisualPosition visualPosition = (VisualPosition)editor.getUserData(ANCHOR_POPUP_POSITION);
            if (visualPosition == null) {
                CaretModel caretModel = editor.getCaretModel();
                visualPosition = caretModel.isUpToDate() ? caretModel.getVisualPosition() : editor.offsetToVisualPosition(caretModel.getOffset());
            }
            p = editor.visualPositionToXY(visualPosition);
            p.y += lineHeight;
        }
        return !(visibleArea = editor.getScrollingModel().getVisibleArea()).contains(p) && !visibleArea.contains(p.x, p.y - lineHeight) ? null : p;
    }

    public Point getCenterOf(JComponent container, JComponent content2) {
        return AbstractPopup.getCenterOf((Component)container, content2);
    }

    @NotNull
    public List<JBPopup> getChildPopups(@NotNull Component component2) {
        if (component2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(31);
        }
        List<JBPopup> list2 = AbstractPopup.getChildPopups(component2);
        if (list2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(32);
        }
        return list2;
    }

    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    @NotNull
    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content2) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(33);
        }
        return new BalloonPopupBuilderImpl(this.myStorage, content2);
    }

    @NotNull
    public BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent content2, @NlsContexts.PopupTitle String title) {
        if (content2 == null) {
            PopupFactoryImpl.$$$reportNull$$$0(34);
        }
        BalloonPopupBuilderImpl builder2 = new BalloonPopupBuilderImpl(this.myStorage, content2);
        Color bg = UIManager.getColor("Panel.background");
        Color borderOriginal = Color.darkGray;
        Color border = ColorUtil.toAlpha((Color)borderOriginal, (int)75);
        builder2.setDialogMode(true).setTitle(title).setAnimationCycle(200).setFillColor(bg).setBorderColor(border).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnAction(false).setCloseButtonEnabled(true).setShadow(true);
        BalloonPopupBuilderImpl balloonPopupBuilderImpl = builder2;
        if (balloonPopupBuilderImpl == null) {
            PopupFactoryImpl.$$$reportNull$$$0(35);
        }
        return balloonPopupBuilderImpl;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon2, Color textColor, Color fillColor, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(36);
        }
        JEditorPane text2 = IdeTooltipManager.initPane(htmlContent, new HintHint().setTextFg(textColor).setAwtTooltip(true), null);
        if (listener2 != null) {
            text2.addHyperlinkListener(listener2);
        }
        text2.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)text2);
        text2.setBorder(null);
        JLabel label2 = new JLabel();
        NonOpaquePanel content2 = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label2.getIconTextGap() * 1.5), (int)((double)label2.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        JScrollPane scrolledText = ScrollPaneFactory.createScrollPane((Component)text2, (boolean)true);
        scrolledText.setBackground(fillColor);
        scrolledText.getViewport().setBackground(fillColor);
        textWrapper.add((Component)scrolledText);
        content2.add((Component)textWrapper, "Center");
        if (icon2 != null) {
            NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
            north.add((Component)new JLabel(icon2), (Object)"North");
            content2.add((Component)north, "West");
        }
        content2.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
        BalloonBuilder builder2 = this.createBalloonBuilder((JComponent)content2);
        builder2.setFillColor(fillColor);
        BalloonBuilder balloonBuilder = builder2;
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(37);
        }
        return balloonBuilder;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, MessageType messageType, @Nullable HyperlinkListener listener2) {
        if (htmlContent == null) {
            PopupFactoryImpl.$$$reportNull$$$0(38);
        }
        BalloonBuilder balloonBuilder = this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getPopupBackground(), listener2);
        if (balloonBuilder == null) {
            PopupFactoryImpl.$$$reportNull$$$0(39);
        }
        return balloonBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 25: 
            case 26: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 25: 
            case 26: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 25: 
            case 26: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aStep";
                break;
            }
            case 23: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfirmation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentContextSupplier";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsStep";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createListPopup";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "guessBestPopupLocation";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPopups";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialogBalloonBuilder";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPopupChooserBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 25: 
            case 26: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPopupComponentAdapter";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroupPopup";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createActionsStep";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createListPopup";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createComponentPopupBuilder";
                break;
            }
            case 24: 
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "guessBestPopupLocation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isBestPopupLocationVisible";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleBestPopupLocation";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createBalloonBuilder";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createDialogBalloonBuilder";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlTextBalloonBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 17: 
            case 20: 
            case 25: 
            case 26: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActionItem
    implements ShortcutProvider,
    AnActionHolder {
        private final AnAction myAction;
        private @NlsContexts.ListItem String myText;
        private final boolean myIsEnabled;
        private final Icon myIcon;
        private final Icon mySelectedIcon;
        private final boolean myPrependWithSeparator;
        private final @NlsContexts.Separator String mySeparatorText;
        private final @NlsContexts.DetailedDescription String myDescription;
        private final @NlsContexts.ListItem String myValue;

        ActionItem(@NotNull AnAction action2, @NotNull @NlsContexts.ListItem String text2, @Nullable @NlsContexts.DetailedDescription String description, boolean enabled, @Nullable Icon icon2, @Nullable Icon selectedIcon, boolean prependWithSeparator, @NlsContexts.Separator String separatorText, @Nullable @NlsContexts.ListItem String value2) {
            if (action2 == null) {
                ActionItem.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                ActionItem.$$$reportNull$$$0(1);
            }
            this.myAction = action2;
            this.myText = text2;
            this.myIsEnabled = enabled;
            this.myIcon = icon2;
            this.mySelectedIcon = selectedIcon;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
            this.myDescription = description;
            this.myValue = value2;
            this.myAction.getTemplatePresentation().addPropertyChangeListener(evt -> {
                if (evt.getPropertyName() == "text") {
                    this.myText = this.myAction.getTemplatePresentation().getText();
                }
            });
        }

        @NotNull
        public AnAction getAction() {
            AnAction anAction = this.myAction;
            if (anAction == null) {
                ActionItem.$$$reportNull$$$0(2);
            }
            return anAction;
        }

        @NotNull
        @NlsContexts.ListItem
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ActionItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public Icon getIcon(boolean selected2) {
            return selected2 && this.mySelectedIcon != null ? this.mySelectedIcon : this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        @NlsContexts.Separator
        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        @NlsContexts.DetailedDescription
        public String getDescription() {
            return this.myDescription;
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction.getShortcutSet();
        }

        public String toString() {
            return this.myText;
        }

        @NlsContexts.ListItem
        public String getValue() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ActionGroupPopup
    extends ListPopupImpl {
        private final Runnable myDisposeCallback;
        private final Component myComponent;
        private final String myActionPlace;

        public ActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(1);
            }
            this(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace, null, false);
        }

        public ActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(2);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(3);
            }
            this(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace, null, autoSelection);
        }

        public ActionGroupPopup(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory, boolean autoSelection) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(4);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(5);
            }
            this(null, ActionGroupPopup.createStep(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, preselectActionCondition, actionPlace, presentationFactory, autoSelection), disposeCallback, dataContext, actionPlace, maxRowCount);
            UiInspectorUtil.registerProvider(this.getList(), () -> UiInspectorUtil.collectActionGroupInfo("Menu", actionGroup, actionPlace));
        }

        protected ActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep step, @Nullable Runnable disposeCallback, @NotNull DataContext dataContext, @Nullable String actionPlace, int maxRowCount) {
            if (step == null) {
                ActionGroupPopup.$$$reportNull$$$0(6);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(7);
            }
            super((Project)CommonDataKeys.PROJECT.getData(dataContext), aParent, step, null);
            this.setMaxRowCount(maxRowCount);
            this.myDisposeCallback = disposeCallback;
            this.myComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            this.myActionPlace = (String)ObjectUtils.notNull((Object)actionPlace, (Object)"popup");
            this.registerAction("handleActionToggle1", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleToggleAction();
                }
            });
            this.addListSelectionListener(e -> {
                JList list2 = (JList)e.getSource();
                ActionItem actionItem = (ActionItem)list2.getSelectedValue();
                if (actionItem == null) {
                    return;
                }
                Presentation presentation2 = this.updateActionItem(actionItem);
                ActionMenu.showDescriptionInStatusBar(true, this.myComponent, presentation2.getDescription());
            });
        }

        @NotNull
        private Presentation updateActionItem(@NotNull ActionItem actionItem) {
            if (actionItem == null) {
                ActionGroupPopup.$$$reportNull$$$0(8);
            }
            AnAction action2 = actionItem.getAction();
            Presentation presentation2 = new Presentation();
            presentation2.setDescription(action2.getTemplatePresentation().getDescription());
            AnActionEvent actionEvent = new AnActionEvent(null, DataManager.getInstance().getDataContext(this.myComponent), this.myActionPlace, presentation2, ActionManager.getInstance(), 0);
            actionEvent.setInjectedContext(action2.isInInjectedContext());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)actionEvent, (boolean)false);
            Presentation presentation3 = presentation2;
            if (presentation3 == null) {
                ActionGroupPopup.$$$reportNull$$$0(9);
            }
            return presentation3;
        }

        protected static ListPopupStep<ActionItem> createStep(@NlsContexts.PopupTitle String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Condition<? super AnAction> preselectActionCondition, @Nullable String actionPlace, @Nullable PresentationFactory presentationFactory, boolean autoSelection) {
            Component component2;
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(10);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(11);
            }
            LOG.assertTrue((component2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext)) != null, (Object)"dataContext has no component for new ListPopupStep");
            List<ActionItem> items = ActionPopupStep.createActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, presentationFactory);
            return new ActionPopupStep(items, title, PopupFactoryImpl.getComponentContextSupplier(component2), actionPlace, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, autoSelection, showDisabledActions, presentationFactory);
        }

        @Deprecated
        @NotNull
        public static List<ActionItem> getActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace) {
            if (actionGroup == null) {
                ActionGroupPopup.$$$reportNull$$$0(12);
            }
            if (dataContext == null) {
                ActionGroupPopup.$$$reportNull$$$0(13);
            }
            List<ActionItem> list2 = ActionPopupStep.createActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace, null);
            if (list2 == null) {
                ActionGroupPopup.$$$reportNull$$$0(14);
            }
            return list2;
        }

        @Override
        public void dispose() {
            if (this.myDisposeCallback != null) {
                this.myDisposeCallback.run();
            }
            ActionMenu.showDescriptionInStatusBar(true, this.myComponent, null);
            super.dispose();
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            KeepingPopupOpenAction dontClosePopupAction;
            Object selectedValue = this.getList().getSelectedValue();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class);
            if (actionPopupStep != null && (dontClosePopupAction = ActionGroupPopup.getActionByClass(selectedValue, actionPopupStep, KeepingPopupOpenAction.class)) != null) {
                actionPopupStep.performAction((AnAction)dontClosePopupAction, e != null ? e.getModifiers() : 0, e);
                for (ActionItem item : actionPopupStep.getValues()) {
                    this.updateActionItem(item);
                }
                this.getList().repaint();
                return;
            }
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleToggleAction() {
            Object[] selectedValues = this.getList().getSelectedValues();
            ListPopupStep<Object> listStep = this.getListStep();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(listStep, ActionPopupStep.class);
            if (actionPopupStep == null) {
                return;
            }
            List filtered2 = ContainerUtil.mapNotNull((Object[])selectedValues, o -> ActionGroupPopup.getActionByClass(o, actionPopupStep, ToggleAction.class));
            for (ToggleAction action2 : filtered2) {
                actionPopupStep.performAction((AnAction)action2, 0);
            }
            for (ActionItem item : actionPopupStep.getValues()) {
                this.updateActionItem(item);
            }
            this.getList().repaint();
        }

        @Nullable
        private static <T> T getActionByClass(@Nullable Object value2, @NotNull ActionPopupStep actionPopupStep, @NotNull Class<T> actionClass) {
            ActionItem item;
            if (actionPopupStep == null) {
                ActionGroupPopup.$$$reportNull$$$0(15);
            }
            if (actionClass == null) {
                ActionGroupPopup.$$$reportNull$$$0(16);
            }
            ActionItem actionItem = item = value2 instanceof ActionItem ? (ActionItem)value2 : null;
            if (item == null) {
                return null;
            }
            if (!actionPopupStep.isSelectable(item)) {
                return null;
            }
            return actionClass.isInstance(item.getAction()) ? (T)actionClass.cast(item.getAction()) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "step";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionItem";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionPopupStep";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupFactoryImpl$ActionGroupPopup";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateActionItem";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "updateActionItem";
                    break;
                }
                case 9: 
                case 14: {
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionItems";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionByClass";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

