/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Base64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\t2\b\u0010\n\u001a\u0004\u0018\u0001H\t\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\t0\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/IndexDataPresenter;", "", "()V", "getPresentableIndexKey", "", "K", "key", "(Ljava/lang/Object;)Ljava/lang/String;", "getPresentableIndexValue", "V", "value", "getPresentableKeyValueMap", "keyValueMap", "", "getPresentableSerializedStubTree", "Lcom/intellij/psi/stubs/SerializedStubTree;", "getPresentableStub", "node", "Lcom/intellij/psi/stubs/Stub;", "indent", "withIndent", "intellij.platform.indexing.impl"})
public final class IndexDataPresenter {
    public static final IndexDataPresenter INSTANCE;

    @NotNull
    public final <K> String getPresentableIndexKey(K key) {
        return String.valueOf(key);
    }

    @NotNull
    public final <V> String getPresentableIndexValue(@Nullable V value2) {
        String string;
        V v = value2;
        if (v == null) {
            string = "<no value>";
        } else if (v instanceof SerializedStubTree) {
            string = this.getPresentableSerializedStubTree((SerializedStubTree)value2);
        } else if (v instanceof ByteArraySequence) {
            String string2 = Base64.encode((byte[])((ByteArraySequence)value2).toBytes());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Base64.encode(value.toBytes())");
        } else {
            string = value2.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPresentableSerializedStubTree(@NotNull SerializedStubTree value2) {
        StringBuilder stringBuilder;
        block5: {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            boolean bl = false;
            boolean bl2 = false;
            stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            StringBuilder stringBuilder2 = $this$buildString;
            Object object = "Stub tree:";
            boolean bl6 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder3;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            stringBuilder2 = $this$buildString;
            Stub stub = value2.getStub();
            Intrinsics.checkNotNullExpressionValue((Object)stub, (String)"value.stub");
            object = INSTANCE.getPresentableStub(stub, "  ");
            bl6 = false;
            StringBuilder stringBuilder5 = stringBuilder2.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder4 = stringBuilder5;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            try {
                Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = value2.getStubIndicesValueMap();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"value.stubIndicesValueMap");
                object = map2;
            }
            catch (Exception e) {
                stringBuilder4 = $this$buildString;
                String string = "Failed-to-read stub tree forward index: (message = " + e.getMessage() + ") (exception class = " + e.getClass().getSimpleName() + ')';
                boolean bl8 = false;
                StringBuilder stringBuilder6 = stringBuilder4.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                StringBuilder stringBuilder7 = stringBuilder6;
                boolean bl9 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
                break block5;
            }
            Object stubIndicesValueMap = object;
            object = $this$buildString;
            Object object2 = "Stub tree forward index:";
            boolean bl10 = false;
            StringBuilder stringBuilder8 = ((StringBuilder)object).append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            StringBuilder stringBuilder9 = stringBuilder8;
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append('\\n')");
            Iterable $this$sortedBy$iv = stubIndicesValueMap.entrySet();
            boolean $i$f$sortedBy = false;
            bl11 = false;
            object2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)((StubIndexKey)it.getKey()).getName());
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = ((StubIndexKey)it.getKey()).getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            }).iterator();
            while (object2.hasNext()) {
                StringBuilder stringBuilder10;
                void stubIndexKey;
                Object object3 = object = (Map.Entry)object2.next();
                boolean bl12 = false;
                $this$sortedBy$iv = (StubIndexKey)object3.getKey();
                object3 = object;
                bl12 = false;
                Map stubIndexValues = (Map)object3.getValue();
                object3 = $this$buildString;
                Object object4 = "    " + stubIndexKey.getName();
                boolean bl13 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append((String)object4), (String)"append(value)");
                boolean bl14 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append('\\n')");
                Iterable<Object> $this$sortedBy$iv2 = stubIndexValues.entrySet();
                boolean $i$f$sortedBy2 = false;
                bl14 = false;
                object4 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Map.Entry it = (Map.Entry)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getKey().toString());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = it.getKey().toString();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                }).iterator();
                while (object4.hasNext()) {
                    StringBuilder stringBuilder11;
                    void key;
                    void $this$mapTo$iv$iv;
                    Object object5 = object3 = (Map.Entry)object4.next();
                    boolean bl15 = false;
                    $this$sortedBy$iv2 = object5.getKey();
                    object5 = object3;
                    bl15 = false;
                    StubIdList stubIdList = (StubIdList)object5.getValue();
                    Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)stubIdList.size());
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void it;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl16 = false;
                        Integer n2 = stubIdList.get((int)it);
                        collection.add(n2);
                    }
                    List stubIds = (List)destination$iv$iv;
                    StringBuilder stringBuilder12 = $this$buildString;
                    String string = "        " + key + " -> " + CollectionsKt.joinToString$default((Iterable)stubIds, null, null, null, (int)0, null, null, (int)63, null);
                    boolean bl17 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append(string), (String)"append(value)");
                    boolean bl18 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
                }
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> String getPresentableKeyValueMap(@NotNull Map<K, ? extends V> keyValueMap) {
        Intrinsics.checkNotNullParameter(keyValueMap, (String)"keyValueMap");
        if (keyValueMap.isEmpty()) {
            return "{empty map}";
        }
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        Map<K, V> map2 = keyValueMap;
        boolean bl6 = false;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            void key;
            Object object = entry;
            boolean bl7 = false;
            map2 = object.getKey();
            object = entry;
            bl7 = false;
            V value2 = object.getValue();
            object = $this$buildString;
            String string = INSTANCE.getPresentableIndexKey(key);
            boolean bl8 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)object).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl9 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            object = $this$buildString;
            string = INSTANCE.withIndent(INSTANCE.getPresentableIndexValue(value2), "  ");
            bl8 = false;
            StringBuilder stringBuilder4 = ((StringBuilder)object).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            stringBuilder3 = stringBuilder4;
            bl9 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final String getPresentableStub(@NotNull Stub node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getPresentableStub(node, "");
    }

    private final String getPresentableStub(Stub node, String indent) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append(indent);
        ObjectStubSerializer stubType = node.getStubType();
        if (stubType != null) {
            $this$buildString.append(stubType.toString()).append(':');
        }
        $this$buildString.append(node.toString());
        if (node instanceof ObjectStubBase) {
            $this$buildString.append(" (id = ").append(((ObjectStubBase)node).getStubId()).append(")");
        }
        for (Stub child2 : node.getChildrenStubs()) {
            StringBuilder stringBuilder2;
            StringBuilder stringBuilder3 = $this$buildString;
            Stub stub = child2;
            Intrinsics.checkNotNullExpressionValue((Object)stub, (String)"child");
            String string = INSTANCE.getPresentableStub(stub, indent + "  ");
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append(string), (String)"append(value)");
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final String withIndent(String $this$withIndent, String indent) {
        return SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)$this$withIndent), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(indent){
            final /* synthetic */ String $indent;

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$indent + it;
            }
            {
                this.$indent = string;
                super(1);
            }
        }), (int)30, null);
    }

    private IndexDataPresenter() {
    }

    static {
        IndexDataPresenter indexDataPresenter;
        INSTANCE = indexDataPresenter = new IndexDataPresenter();
    }
}

