/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectEntitiesLoaderKt;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsProjectSerializersImplKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/CachingJpsFileContentReader;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReader;", "projectBaseDirUrl", "", "(Ljava/lang/String;)V", "fileContentCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jdom/Element;", "projectPathMacroManager", "Lcom/intellij/openapi/components/impl/ProjectPathMacroManager;", "kotlin.jvm.PlatformType", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "fileUrl", "getMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "customModuleFilePath", "loadComponent", "componentName", "loadComponents", "intellij.platform.workspaceModel.ide"})
public final class CachingJpsFileContentReader
implements JpsFileContentReader {
    private final ProjectPathMacroManager projectPathMacroManager;
    private final ConcurrentHashMap<String, Map<String, Element>> fileContentCache;

    @Override
    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable String customModuleFilePath) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Map<String, Element> map2 = this.fileContentCache.computeIfAbsent(fileUrl, (Function<String, Map<String, Element>>)new Function<String, Map<String, ? extends Element>>(this, customModuleFilePath){
            final /* synthetic */ CachingJpsFileContentReader this$0;
            final /* synthetic */ String $customModuleFilePath;

            @NotNull
            public final Map<String, Element> apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CachingJpsFileContentReader.access$loadComponents(this.this$0, it, this.$customModuleFilePath);
            }
            {
                this.this$0 = cachingJpsFileContentReader;
                this.$customModuleFilePath = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue(map2, (String)"fileContentCache.compute\u2026stomModuleFilePath)\n    }");
        Map<String, Element> content2 = map2;
        return content2.get(componentName);
    }

    @Override
    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        ExpandMacroToPathMap expandMacroToPathMap = this.getMacroManager(fileUrl, null).getExpandMacroMap();
        Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"getMacroManager(fileUrl, null).expandMacroMap");
        return expandMacroToPathMap;
    }

    private final Map<String, Element> loadComponents(String fileUrl, String customModuleFilePath) {
        Map<String, Element> map2;
        PathMacroManager macroManager = this.getMacroManager(fileUrl, customModuleFilePath);
        Path file2 = Paths.get(JpsPathUtil.urlToPath((String)fileUrl), new String[0]);
        if (Files.isRegularFile(file2, new LinkOption[0])) {
            Path path = file2;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
            map2 = JpsProjectEntitiesLoaderKt.loadStorageFile(path, macroManager);
        } else {
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final PathMacroManager getMacroManager(String fileUrl, String customModuleFilePath) {
        PathMacroManager pathMacroManager;
        String path = JpsPathUtil.urlToPath((String)fileUrl);
        if (!FileUtil.extensionEquals((String)fileUrl, (String)"iml")) {
            String string = path;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            if (!JpsProjectSerializersImplKt.isExternalModuleFile(string)) {
                ProjectPathMacroManager projectPathMacroManager2 = this.projectPathMacroManager;
                Intrinsics.checkNotNullExpressionValue((Object)projectPathMacroManager2, (String)"projectPathMacroManager");
                pathMacroManager = projectPathMacroManager2;
                return pathMacroManager;
            }
        }
        ModulePathMacroManager modulePathMacroManager = ModulePathMacroManager.createInstance(new Supplier<String>(customModuleFilePath, path){
            final /* synthetic */ String $customModuleFilePath;
            final /* synthetic */ String $path;

            public final String get() {
                String string = this.$customModuleFilePath;
                if (string == null) {
                    string = this.$path;
                }
                return string;
            }
            {
                this.$customModuleFilePath = string;
                this.$path = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)modulePathMacroManager, (String)"ModulePathMacroManager.c\u2026mModuleFilePath ?: path }");
        pathMacroManager = modulePathMacroManager;
        return pathMacroManager;
    }

    public CachingJpsFileContentReader(@NotNull String projectBaseDirUrl) {
        Intrinsics.checkNotNullParameter((Object)projectBaseDirUrl, (String)"projectBaseDirUrl");
        this.projectPathMacroManager = ProjectPathMacroManager.createInstance(new Supplier<String>(projectBaseDirUrl){
            final /* synthetic */ String $projectBaseDirUrl;

            public final String get() {
                return JpsPathUtil.urlToPath((String)this.$projectBaseDirUrl);
            }
            {
                this.$projectBaseDirUrl = string;
            }
        }, null);
        this.fileContentCache = new ConcurrentHashMap();
    }

    public static final /* synthetic */ Map access$loadComponents(CachingJpsFileContentReader $this, String fileUrl, String customModuleFilePath) {
        return $this.loadComponents(fileUrl, customModuleFilePath);
    }
}

