/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.BiMap;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.EntityReference;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.ExternalEntityMapping;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.AbstractRefsTable;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverterKt;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntitiesBarrel;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.EntityId;
import com.intellij.workspaceModel.storage.impl.EntityStorageSerializerImpl;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.SimpleEntityTypesResolver;
import com.intellij.workspaceModel.storage.impl.StorageIndexes;
import com.intellij.workspaceModel.storage.impl.StrictMode;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.containers.IntIntUniqueBiMap;
import com.intellij.workspaceModel.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.workspaceModel.storage.impl.containers.NonNegativeIntIntBiMap;
import com.intellij.workspaceModel.storage.impl.external.EmptyExternalEntityMapping;
import com.intellij.workspaceModel.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlManagerImpl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 U2\u00020\u0001:\u0001UB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011JA\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 H\u0002J&\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020 2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0)2\u0006\u0010*\u001a\u00020\u0014H\u0002J,\u0010+\u001a\u00020\u00102\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020 0-2\u0006\u0010*\u001a\u00020\u0014H\u0002J \u0010/\u001a\u00020\u00102\u0006\u0010,\u001a\u0002002\u0006\u0010'\u001a\u00020 2\u0006\u00101\u001a\u00020 H\u0002J&\u00102\u001a\b\u0012\u0004\u0012\u0002H403\"\b\b\u0000\u00104*\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H407H\u0016JB\u00108\u001a(\u0012\u0004\u0012\u00020\u0017\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020507\u0012\n\u0012\b\u0012\u0004\u0012\u0002050:09092\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0016J\u001f\u0010;\u001a\f\u0012\u0006\b\u0001\u0012\u000205\u0018\u00010<2\u0006\u0010%\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b=J\u001d\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u0002050<2\u0006\u0010%\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b?J\u001c\u0010@\u001a\b\u0012\u0004\u0012\u0002HB0A\"\u0004\b\u0000\u0010B2\u0006\u0010C\u001a\u00020\u0014H\u0016J\b\u0010D\u001a\u00020EH\u0016JW\u0010F\u001a\b\u0012\u0004\u0012\u0002HG03\"\b\b\u0000\u00104*\u000205\"\b\b\u0001\u0010G*\u0002052\u0006\u0010H\u001a\u0002H42\f\u00106\u001a\b\u0012\u0004\u0012\u0002HG0I2\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u0002HG\u0012\n\u0012\b\u0012\u0004\u0012\u0002H40L0KH\u0016\u00a2\u0006\u0002\u0010MJ>\u0010F\u001a\b\u0012\u0004\u0012\u0002HG03\"\b\b\u0000\u00104*\u00020N\"\b\b\u0001\u0010G*\u0002052\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H40O2\f\u00106\u001a\b\u0012\u0004\u0012\u0002HG07H\u0016JK\u0010P\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010H\u001a\u00020Q2\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bRJ'\u0010S\u001a\u0004\u0018\u0001H4\"\b\b\u0000\u00104*\u00020N2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H40OH\u0016\u00a2\u0006\u0002\u0010TR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0002VW\u00a8\u0006X"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorage;", "()V", "entitiesByType", "Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "getEntitiesByType$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "indexes", "Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "getIndexes$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/StorageIndexes;", "refs", "Lcom/intellij/workspaceModel/storage/impl/AbstractRefsTable;", "getRefs$intellij_platform_workspaceModel_storage", "()Lcom/intellij/workspaceModel/storage/impl/AbstractRefsTable;", "assertConsistency", "", "assertConsistency$intellij_platform_workspaceModel_storage", "assertConsistencyInStrictModeForRbs", "message", "", "sourceFilter", "Lkotlin/Function1;", "Lcom/intellij/workspaceModel/storage/EntitySource;", "", "left", "right", "resulting", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "assertConsistencyInStrictModeForRbs$intellij_platform_workspaceModel_storage", "assertCorrectEntityClass", "connectionClass", "", "entityId", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "assertResolvable", "clazz", "id", "checkAllStrongConnections", "entityFamilyClass", "keys", "", "debugInfo", "checkStrongAbstractConnection", "connectionKeys", "", "entityFamilyClasses", "checkStrongConnection", "Lit/unimi/dsi/fastutil/ints/IntSet;", "connectionTo", "entities", "Lkotlin/sequences/Sequence;", "E", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "entityClass", "Ljava/lang/Class;", "entitiesBySource", "", "", "entityDataById", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "entityDataById$intellij_platform_workspaceModel_storage", "entityDataByIdOrDie", "entityDataByIdOrDie$intellij_platform_workspaceModel_storage", "getExternalMapping", "Lcom/intellij/workspaceModel/storage/ExternalEntityMapping;", "T", "identifier", "getVirtualFileUrlIndex", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlIndex;", "referrers", "R", "e", "Lkotlin/reflect/KClass;", "property", "Lkotlin/reflect/KProperty1;", "Lcom/intellij/workspaceModel/storage/EntityReference;", "(Lcom/intellij/workspaceModel/storage/WorkspaceEntity;Lkotlin/reflect/KClass;Lkotlin/reflect/KProperty1;)Lkotlin/sequences/Sequence;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithPersistentId;", "Lcom/intellij/workspaceModel/storage/PersistentEntityId;", "reportConsistencyIssue", "", "reportConsistencyIssue$intellij_platform_workspaceModel_storage", "resolve", "(Lcom/intellij/workspaceModel/storage/PersistentEntityId;)Lcom/intellij/workspaceModel/storage/WorkspaceEntityWithPersistentId;", "Companion", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageImpl;", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "intellij.platform.workspaceModel.storage"})
public abstract class AbstractEntityStorage
implements WorkspaceEntityStorage {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public abstract EntitiesBarrel getEntitiesByType$intellij_platform_workspaceModel_storage();

    @NotNull
    public abstract AbstractRefsTable getRefs$intellij_platform_workspaceModel_storage();

    @NotNull
    public abstract StorageIndexes getIndexes$intellij_platform_workspaceModel_storage();

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Sequence sequence;
        Sequence sequence2;
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        if (!((entityFamily != null && (entityFamily = entityFamily.all()) != null ? SequencesKt.map(entityFamily, (Function1)((Function1)new Function1<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntity>(this){
            final /* synthetic */ AbstractEntityStorage this$0;

            @NotNull
            public final WorkspaceEntity invoke(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.createEntity(this.this$0);
            }
            {
                this.this$0 = abstractEntityStorage;
                super(1);
            }
        })) : (sequence2 = null)) instanceof Sequence)) {
            sequence2 = sequence = null;
        }
        if (sequence2 == null) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    @Nullable
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataById$intellij_platform_workspaceModel_storage(@NotNull EntityId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(id2.getClazz());
        return entityFamily != null ? entityFamily.get(id2.getArrayId()) : null;
    }

    @NotNull
    public final WorkspaceEntityData<? extends WorkspaceEntity> entityDataByIdOrDie$intellij_platform_workspaceModel_storage(@NotNull EntityId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(id2.getClazz());
        if (entityFamily == null || (entityFamily = entityFamily.get(id2.getArrayId())) == null) {
            String string = "Cannot find an entity by id " + id2;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return entityFamily;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull E e, @NotNull KClass<R> entityClass, @NotNull KProperty1<R, ? extends EntityReference<? extends E>> property) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithPersistentId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull PersistentEntityId<? extends E> id2, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        Intrinsics.checkNotNullParameter(entityClass, (String)"entityClass");
        int classId = ClassToIntConverterKt.toClassId(entityClass);
        Set set2 = this.getIndexes$intellij_platform_workspaceModel_storage().getSoftLinks$intellij_platform_workspaceModel_storage().getIndex$intellij_platform_workspaceModel_storage().getKeys(id2);
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"indexes.softLinks.index.getKeys(id)");
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set2), (Function1)((Function1)new Function1<EntityId, Boolean>(classId){
            final /* synthetic */ int $classId;

            public final boolean invoke(EntityId it) {
                return it.getClazz() == this.$classId;
            }
            {
                this.$classId = n;
                super(1);
            }
        })), (Function1)new Function1<EntityId, R>(this){
            final /* synthetic */ AbstractEntityStorage this$0;

            @NotNull
            public final R invoke(EntityId it) {
                EntityId entityId = it;
                Intrinsics.checkNotNullExpressionValue((Object)entityId, (String)"it");
                WorkspaceEntity workspaceEntity = this.this$0.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(entityId).createEntity(this.this$0);
                if (workspaceEntity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type R");
                }
                return (R)workspaceEntity;
            }
            {
                this.this$0 = abstractEntityStorage;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <E extends WorkspaceEntityWithPersistentId> E resolve(@NotNull PersistentEntityId<? extends E> id2) {
        Intrinsics.checkNotNullParameter(id2, (String)"id");
        List<EntityId> list2 = this.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(id2);
        if (list2 == null) {
            return null;
        }
        List<EntityId> pids = list2;
        if (pids.isEmpty()) {
            return null;
        }
        if (pids.size() > 1) {
            Iterable $this$associateWith$iv = pids;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                EntityId entityId = (EntityId)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage((EntityId)it);
                map2.put(t, workspaceEntityData);
            }
            String entities2 = CollectionsKt.joinToString$default((Iterable)((Map)result$iv).entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)resolve.entities.2.INSTANCE, (int)30, null);
            LOG.error(StringsKt.trimMargin$default((String)("Cannot resolve persistent id " + id2 + ". The store contains " + pids.size() + " associated entities:\n        |" + entities2 + "\n      "), null, (int)1, null));
            WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage((EntityId)CollectionsKt.first(pids));
            return (E)((WorkspaceEntityWithPersistentId)(workspaceEntityData != null ? workspaceEntityData.createEntity(this) : null));
        }
        EntityId pid2 = (EntityId)CollectionsKt.single(pids);
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspaceModel_storage(pid2);
        return (E)((WorkspaceEntityWithPersistentId)(workspaceEntityData != null ? workspaceEntityData.createEntity(this) : null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<EntitySource, Map<Class<? extends WorkspaceEntity>, List<WorkspaceEntity>>> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Sequence $this$associateWith$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage()), (Function1)((Function1)new Function1<EntitySource, Boolean>(sourceFilter){
            final /* synthetic */ Function1 $sourceFilter;

            public final boolean invoke(@NotNull EntitySource it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Boolean)this.$sourceFilter.invoke((Object)it);
            }
            {
                this.$sourceFilter = function1;
                super(1);
            }
        }));
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$groupByTo$iv$iv;
            WorkspaceEntity it;
            Iterable $this$mapTo$iv$iv;
            void source;
            EntitySource entitySource2 = (EntitySource)element$iv$iv;
            Object e = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List<EntityId> list2 = this.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage((EntitySource)source);
            Intrinsics.checkNotNull(list2);
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                EntityId entityId = (EntityId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                WorkspaceEntity workspaceEntity = this.entityDataByIdOrDie$intellij_platform_workspaceModel_storage((EntityId)((Object)it)).createEntity(this);
                collection.add(workspaceEntity);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                Object object;
                Class<?> key$iv$iv;
                it = (WorkspaceEntity)element$iv$iv2;
                boolean bl3 = false;
                if (it.getClass() == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<out com.intellij.workspaceModel.storage.WorkspaceEntity>");
                }
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv2);
            }
            Object object = destination$iv$iv;
            map2.put(e, object);
        }
        return result$iv;
    }

    @Override
    @NotNull
    public <T> ExternalEntityMapping<T> getExternalMapping(@NotNull String identifier) {
        ExternalEntityMappingImpl<?> index;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        ExternalEntityMappingImpl<?> externalEntityMappingImpl = this.getIndexes$intellij_platform_workspaceModel_storage().getExternalMappings$intellij_platform_workspaceModel_storage().get(identifier);
        if (!(externalEntityMappingImpl instanceof ExternalEntityMappingImpl)) {
            externalEntityMappingImpl = null;
        }
        if ((index = externalEntityMappingImpl) == null) {
            EmptyExternalEntityMapping emptyExternalEntityMapping = EmptyExternalEntityMapping.INSTANCE;
            if (emptyExternalEntityMapping == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.ExternalEntityMapping<T>");
            }
            return emptyExternalEntityMapping;
        }
        index.setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
        return index;
    }

    @Override
    @NotNull
    public VirtualFileUrlIndex getVirtualFileUrlIndex() {
        this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage().setTypedEntityStorage$intellij_platform_workspaceModel_storage(this);
        return this.getIndexes$intellij_platform_workspaceModel_storage().getVirtualFileIndex$intellij_platform_workspaceModel_storage();
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency$intellij_platform_workspaceModel_storage() {
        Integer n;
        Collection<Integer> collection;
        Map.Entry<ConnectionId, NonNegativeIntIntBiMap> $this$map$iv332;
        boolean $i$f$map;
        AbstractEntityStorage abstractEntityStorage;
        Set set2;
        EntityId childId;
        EntityId parentId;
        boolean bl;
        Map.Entry $dstr$childId$parentId;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Object this_$iv22;
        Object map2;
        boolean $i$f$forEachKey;
        Object this_$iv332;
        boolean bl2;
        ConnectionId connectionId;
        Map.Entry<ConnectionId, NonNegativeIntIntBiMap> $dstr$connectionId$map;
        Map.Entry<ConnectionId, Object> element$iv;
        this.getEntitiesByType$intellij_platform_workspaceModel_storage().assertConsistency(this);
        Map<ConnectionId, NonNegativeIntIntBiMap> $this$forEach$iv2 = this.getRefs$intellij_platform_workspaceModel_storage().getOneToManyContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach2 = false;
        Map<ConnectionId, Object> map3 = $this$forEach$iv2;
        boolean bl3 = false;
        Iterator<Map.Entry<ConnectionId, Object>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            $dstr$connectionId$map = element$iv = iterator2.next();
            boolean bl4 = false;
            Map.Entry<ConnectionId, NonNegativeIntIntBiMap> entry = $dstr$connectionId$map;
            boolean bl5 = false;
            ConnectionId connectionId2 = entry.getKey();
            entry = $dstr$connectionId$map;
            bl5 = false;
            NonNegativeIntIntBiMap map22 = entry.getValue();
            boolean bl6 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_MANY;
            bl5 = false;
            bl2 = false;
            if (_Assertions.ENABLED && !bl6) {
                boolean bl7 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this_$iv332 = map22;
            $i$f$forEachKey = false;
            Int2IntMaps.fastForEach((Int2IntMap)((NonNegativeIntIntBiMap)this_$iv332).getAccess$key2Value(), (Consumer)new Consumer<Int2IntMap.Entry>(connectionId, this){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage this$0;
                {
                    this.$connectionId$inlined = connectionId;
                    this.this$0 = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry.getIntKey();
                    boolean bl = false;
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getParentClass(), parentId);
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (connectionId.isParentNullable()) continue;
            this.checkStrongConnection(map22.getKeys(), connectionId.getChildClass(), connectionId.getParentClass());
        }
        Map<ConnectionId, Object> $this$forEach$iv3 = this.getRefs$intellij_platform_workspaceModel_storage().getOneToOneContainer$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEach3 = false;
        map3 = $this$forEach$iv3;
        bl3 = false;
        iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            $dstr$connectionId$map = element$iv = iterator2.next();
            boolean bl8 = false;
            this_$iv332 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            connectionId = this_$iv332.getKey();
            this_$iv332 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            map2 = (IntIntUniqueBiMap)this_$iv332.getValue();
            boolean this_$iv332 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE;
            $i$f$forEachKey = false;
            bl2 = false;
            if (_Assertions.ENABLED && !this_$iv332) {
                boolean bl9 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            this_$iv22 = map2;
            $i$f$forEachKey = false;
            Int2IntMaps.fastForEach((Int2IntMap)((IntIntUniqueBiMap)this_$iv22).getAccess$key2Value(), (Consumer)new Consumer<Int2IntMap.Entry>(connectionId, this){
                final /* synthetic */ ConnectionId $connectionId$inlined;
                final /* synthetic */ AbstractEntityStorage this$0;
                {
                    this.$connectionId$inlined = connectionId;
                    this.this$0 = abstractEntityStorage;
                }

                public final void accept(Int2IntMap.Entry it) {
                    Int2IntMap.Entry entry = it;
                    Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"it");
                    int parentId = it.getIntValue();
                    int childId = entry.getIntKey();
                    boolean bl = false;
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getParentClass(), parentId);
                    AbstractEntityStorage.access$assertResolvable(this.this$0, this.$connectionId$inlined.getChildClass(), childId);
                }
            });
            if (!connectionId.isParentNullable()) {
                this.checkStrongConnection(((IntIntUniqueBiMap)map2).getKeys(), connectionId.getChildClass(), connectionId.getParentClass());
            }
            if (connectionId.isChildNullable()) continue;
            this.checkStrongConnection(((IntIntUniqueBiMap)map2).getValues(), connectionId.getParentClass(), connectionId.getChildClass());
        }
        $this$forEach$iv3 = this.getRefs$intellij_platform_workspaceModel_storage().getOneToAbstractManyContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach3 = false;
        map3 = $this$forEach$iv3;
        bl3 = false;
        iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv232;
            $dstr$connectionId$map = element$iv = iterator2.next();
            boolean bl10 = false;
            this_$iv22 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            connectionId = this_$iv22.getKey();
            this_$iv22 = $dstr$connectionId$map;
            $i$f$forEachKey = false;
            map2 = (LinkedBidirectionalMap)this_$iv22.getValue();
            boolean this_$iv22 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY;
            $i$f$forEachKey = false;
            boolean bl11 = false;
            if (_Assertions.ENABLED && !this_$iv22) {
                boolean bl12 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            $this$forEach$iv = (Map)map2;
            $i$f$forEach = false;
            Object object = $this$forEach$iv;
            boolean bl13 = false;
            Iterator iterator3 = object.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry;
                $dstr$childId$parentId = entry = iterator3.next();
                boolean bl14 = false;
                Map.Entry entry2 = $dstr$childId$parentId;
                bl = false;
                EntityId entityId = (EntityId)entry2.getKey();
                entry2 = $dstr$childId$parentId;
                bl = false;
                parentId = (EntityId)entry2.getValue();
                this.assertResolvable(parentId.getClazz(), parentId.getArrayId());
                this.assertResolvable(childId.getClazz(), childId.getArrayId());
                this.assertCorrectEntityClass(connectionId.getParentClass(), parentId);
                this.assertCorrectEntityClass(connectionId.getChildClass(), childId);
            }
            if (connectionId.isParentNullable()) continue;
            $this$forEach$iv = CollectionsKt.toMutableSet((Iterable)((LinkedBidirectionalMap)map2).keySet());
            set2 = CollectionsKt.toMutableSet((Iterable)((LinkedBidirectionalMap)map2).keySet());
            abstractEntityStorage = this;
            $i$f$map = false;
            object = $this$map$iv332;
            Collection destination$iv$iv232 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv332, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv232) {
                void it;
                EntityId bl14 = (EntityId)item$iv$iv;
                collection = destination$iv$iv232;
                boolean bl15 = false;
                n = it.getClazz();
                collection.add(n);
            }
            collection = (List)destination$iv$iv232;
            abstractEntityStorage.checkStrongAbstractConnection(set2, CollectionsKt.toSet((Iterable)collection), connectionId.debugStr());
        }
        $this$forEach$iv3 = this.getRefs$intellij_platform_workspaceModel_storage().getAbstractOneToOneContainer$intellij_platform_workspaceModel_storage();
        $i$f$forEach3 = false;
        map3 = $this$forEach$iv3;
        bl3 = false;
        iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            $dstr$connectionId$map = element$iv = iterator2.next();
            boolean bl16 = false;
            $this$map$iv332 = $dstr$connectionId$map;
            $i$f$map = false;
            connectionId = $this$map$iv332.getKey();
            $this$map$iv332 = $dstr$connectionId$map;
            $i$f$map = false;
            map2 = (BiMap)$this$map$iv332.getValue();
            boolean $this$map$iv332 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE;
            $i$f$map = false;
            boolean $this$mapTo$iv$iv232 = false;
            if (_Assertions.ENABLED && !$this$map$iv332) {
                boolean destination$iv$iv232 = false;
                String destination$iv$iv232 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)destination$iv$iv232));
            }
            $this$forEach$iv = (Map)map2;
            $i$f$forEach = false;
            Map $this$mapTo$iv$iv232 = $this$forEach$iv;
            boolean destination$iv$iv232 = false;
            for (Map.Entry entry : $this$mapTo$iv$iv232.entrySet()) {
                $dstr$childId$parentId = entry;
                boolean bl17 = false;
                Map.Entry bl15 = $dstr$childId$parentId;
                bl = false;
                childId = (EntityId)bl15.getKey();
                bl15 = $dstr$childId$parentId;
                bl = false;
                parentId = (EntityId)bl15.getValue();
                this.assertResolvable(parentId.getClazz(), parentId.getArrayId());
                this.assertResolvable(childId.getClazz(), childId.getArrayId());
                int n2 = connectionId.getParentClass();
                EntityId entityId = parentId;
                Intrinsics.checkNotNullExpressionValue((Object)entityId, (String)"parentId");
                this.assertCorrectEntityClass(n2, entityId);
                int n3 = connectionId.getChildClass();
                EntityId entityId2 = childId;
                Intrinsics.checkNotNullExpressionValue((Object)entityId2, (String)"childId");
                this.assertCorrectEntityClass(n3, entityId2);
            }
            if (!connectionId.isParentNullable()) {
                $this$forEach$iv = CollectionsKt.toMutableSet((Iterable)map2.keySet());
                set2 = CollectionsKt.toMutableSet((Iterable)map2.keySet());
                abstractEntityStorage = this;
                $i$f$map = false;
                $this$mapTo$iv$iv232 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    EntityId bl17 = (EntityId)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl18 = false;
                    n = it.getClazz();
                    collection.add(n);
                }
                collection = (List)destination$iv$iv;
                abstractEntityStorage.checkStrongAbstractConnection(set2, CollectionsKt.toSet((Iterable)collection), connectionId.debugStr());
            }
            if (connectionId.isChildNullable()) continue;
            Set set3 = (Set)map2.values();
            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"map.values");
            Set set4 = CollectionsKt.toMutableSet((Iterable)set3);
            Set set5 = (Set)map2.values();
            Intrinsics.checkNotNullExpressionValue((Object)set5, (String)"map.values");
            $this$map$iv = CollectionsKt.toMutableSet((Iterable)set5);
            set2 = set4;
            abstractEntityStorage = this;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                EntityId it = (EntityId)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl19 = false;
                n = it.getClazz();
                collection.add(n);
            }
            collection = (List)destination$iv$iv;
            abstractEntityStorage.checkStrongAbstractConnection(set2, CollectionsKt.toSet((Iterable)collection), connectionId.debugStr());
        }
        this.getIndexes$intellij_platform_workspaceModel_storage().assertConsistency(this);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkStrongConnection(IntSet connectionKeys, int entityFamilyClass, int connectionTo) {
        int counter = 0;
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            String string = "Entity family " + ClassToIntConverterKt.findWorkspaceEntity(entityFamilyClass) + " doesn't exist";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (entity == null) continue;
            int n2 = connectionKeys.contains(i2);
            boolean bl3 = false;
            if (_Assertions.ENABLED && n2 == 0) {
                boolean bl4 = false;
                String string = "Entity " + entity + " doesn't have a correct connection to " + ClassToIntConverterKt.findWorkspaceEntity(connectionTo);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            n2 = counter;
            counter = n2 + 1;
        }
        boolean bl = counter == connectionKeys.size();
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl6 = false;
            String string = "Store is inconsistent";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final void checkStrongAbstractConnection(Set<EntityId> connectionKeys, Set<Integer> entityFamilyClasses, String debugInfo) {
        Set keys2 = CollectionsKt.toMutableSet((Iterable)connectionKeys);
        Iterable $this$forEach$iv = entityFamilyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int entityFamilyClass = ((Number)element$iv).intValue();
            boolean bl = false;
            this.checkAllStrongConnections(entityFamilyClass, keys2, debugInfo);
        }
        boolean bl = keys2.isEmpty();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Store is inconsistent. " + debugInfo;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAllStrongConnections(int entityFamilyClass, Set<EntityId> keys2, String debugInfo) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().getEntityFamilies$intellij_platform_workspaceModel_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            String string = "Entity family doesn't exist. " + debugInfo;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i2 = n;
            boolean bl2 = false;
            if (entity == null) continue;
            boolean removed = keys2.remove(entity.createEntityId$intellij_platform_workspaceModel_storage());
            boolean bl3 = false;
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl4 = false;
            String string = "Entity " + entity + " doesn't have a correct connection. " + debugInfo;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public final void assertConsistencyInStrictModeForRbs$intellij_platform_workspaceModel_storage(@NotNull String message, @NotNull Function1<? super EntitySource, Boolean> sourceFilter, @NotNull WorkspaceEntityStorage left, @NotNull WorkspaceEntityStorage right, @NotNull WorkspaceEntityStorageBuilder resulting) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(sourceFilter, (String)"sourceFilter");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)resulting, (String)"resulting");
        if (StrictMode.INSTANCE.getRbsEnabled()) {
            try {
                this.assertConsistency$intellij_platform_workspaceModel_storage();
            }
            catch (Throwable e) {
                this.reportConsistencyIssue$intellij_platform_workspaceModel_storage(message, e, sourceFilter, left, right, resulting);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void reportConsistencyIssue$intellij_platform_workspaceModel_storage(@NotNull String message, @NotNull Throwable e, @Nullable Function1<? super EntitySource, Boolean> sourceFilter, @NotNull WorkspaceEntityStorage left, @NotNull WorkspaceEntityStorage right, @NotNull WorkspaceEntityStorageBuilder resulting) {
        void path$iv;
        void stream;
        String string;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)resulting, (String)"resulting");
        if (sourceFilter != null) {
            void $this$fold$iv;
            HashSet allEntitySources2 = CollectionsKt.toHashSet((Iterable)((AbstractEntityStorage)left).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage());
            allEntitySources2.addAll(((AbstractEntityStorage)right).getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage().entries$intellij_platform_workspaceModel_storage());
            Iterable $this$sortedBy$iv = allEntitySources2;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    EntitySource it = (EntitySource)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.toString());
                    it = (EntitySource)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.toString();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            String initial$iv = "";
            boolean $i$f$fold = false;
            String accumulator$iv = initial$iv;
            for (Object element$iv2 : $this$fold$iv) {
                void source;
                EntitySource entitySource2 = (EntitySource)element$iv2;
                String acc = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = acc + ((Boolean)sourceFilter.invoke((Object)source) != false ? "1" : "0");
            }
            string = accumulator$iv;
        } else {
            string = null;
        }
        String entitySourceFilter2 = string;
        String displayText = "Content of the workspace model in binary format";
        String _message = message + "\n\n!Please include all attachments to the report!";
        _message = _message + "\n\nEntity source filter: " + entitySourceFilter2;
        _message = _message + "\n\nVersion: v5";
        Attachment leftAttachment = ErrorReportingKt.asAttachment(left, "Left_Store", displayText);
        Attachment rightAttachment = ErrorReportingKt.asAttachment(right, "Right_Store", displayText);
        Attachment resAttachment = ErrorReportingKt.asAttachment(resulting, "Res_Store", displayText);
        element$iv2 = "ClassToIntConverter";
        String displayText$iv = "Class to int converter";
        boolean $i$f$createAttachment = false;
        ByteArrayOutputStream stream$iv = new ByteArrayOutputStream();
        EntityStorageSerializerImpl serializer$iv = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl());
        OutputStream outputStream = stream$iv;
        EntityStorageSerializerImpl serializer2 = serializer$iv;
        boolean bl3 = false;
        serializer2.serializeClassToIntConverter((OutputStream)stream);
        Object bytes$iv = stream$iv.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)bytes$iv, (String)"bytes");
        Attachment classToIntConverterAttachment = ErrorReportingKt.createAttachment((String)path$iv, bytes$iv, displayText$iv);
        Object[] attachments = new Attachment[]{leftAttachment, rightAttachment, resAttachment, classToIntConverterAttachment};
        if (right instanceof WorkspaceEntityStorageBuilder) {
            void path$iv2;
            void stream2;
            void serializer3;
            displayText$iv = "Right_Diff_Log";
            String displayText$iv2 = "Log of right builder";
            boolean $i$f$createAttachment2 = false;
            ByteArrayOutputStream stream$iv2 = new ByteArrayOutputStream();
            EntityStorageSerializerImpl serializer$iv2 = new EntityStorageSerializerImpl(SimpleEntityTypesResolver.INSTANCE, new VirtualFileUrlManagerImpl());
            bytes$iv = stream$iv2;
            EntityStorageSerializerImpl bl3 = serializer$iv2;
            Object[] objectArray = attachments;
            boolean bl4 = false;
            WorkspaceEntityStorageBuilderImpl cfr_ignored_0 = (WorkspaceEntityStorageBuilderImpl)right;
            serializer3.serializeDiffLog$intellij_platform_workspaceModel_storage((OutputStream)stream2, ((WorkspaceEntityStorageBuilderImpl)right).getChangeLog$intellij_platform_workspaceModel_storage());
            Unit unit = Unit.INSTANCE;
            byte[] bytes$iv2 = stream$iv2.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)bytes$iv2, (String)"bytes");
            attachments = (Attachment[])ArraysKt.plus((Object[])objectArray, (Object)ErrorReportingKt.createAttachment((String)path$iv2, bytes$iv2, displayText$iv2));
        }
        LOG.error(_message, e, Arrays.copyOf(attachments, attachments.length));
    }

    private final void assertResolvable(int clazz, int id2) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspaceModel_storage().get(clazz);
        boolean bl = (entityFamily != null ? entityFamily.get(id2) : null) != null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv = clazz;
            boolean $i$f$findEntityClass = false;
            Class<?> clazz2 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
            if (clazz2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string = "Reference to " + clazz2 + "-:-" + id2 + " cannot be resolved";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private final void assertCorrectEntityClass(int connectionClass, EntityId entityId) {
        int $this$findEntityClass$iv = connectionClass;
        boolean $i$f$findEntityClass = false;
        Class<?> clazz = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        $this$findEntityClass$iv = entityId.getClazz();
        $i$f$findEntityClass = false;
        Class<?> clazz2 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv);
        if (clazz2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
        }
        boolean bl = clazz.isAssignableFrom(clazz2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            int $this$findEntityClass$iv2 = connectionClass;
            boolean $i$f$findEntityClass2 = false;
            Class<?> clazz3 = ClassToIntConverter.INSTANCE.getClassOrDie($this$findEntityClass$iv2);
            if (clazz3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            String string = "Entity storage with connection class " + clazz3 + " contains entity data of wrong type " + entityId;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    private AbstractEntityStorage() {
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractEntityStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public /* synthetic */ AbstractEntityStorage(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ void access$assertResolvable(AbstractEntityStorage $this, int clazz, int id2) {
        $this.assertResolvable(clazz, id2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

