/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPropertiesSubPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class XSuspendPolicyPanel
extends XBreakpointPropertiesSubPanel {
    private JCheckBox mySuspendCheckBox;
    private JRadioButton mySuspendAll;
    private JRadioButton mySuspendThread;
    private JPanel myContentPane;
    private JButton myMakeDefaultButton;
    private JPanel myMakeDefaultPanel;
    private ButtonGroup mySuspendPolicyGroup;
    private Delegate myDelegate;

    public XSuspendPolicyPanel() {
        this.$$$setupUI$$$();
    }

    @Override
    public void init(Project project, XBreakpointManager breakpointManager, @NotNull XBreakpointBase breakpoint) {
        if (breakpoint == null) {
            XSuspendPolicyPanel.$$$reportNull$$$0(0);
        }
        super.init(project, breakpointManager, breakpoint);
        this.mySuspendCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean selected2 = XSuspendPolicyPanel.this.mySuspendCheckBox.isSelected();
                if (XSuspendPolicyPanel.this.myBreakpoint.getType().isSuspendThreadSupported()) {
                    XSuspendPolicyPanel.this.changeEnableState(selected2);
                }
                if (XSuspendPolicyPanel.this.myDelegate != null && !selected2) {
                    XSuspendPolicyPanel.this.myDelegate.showMoreOptionsIfNeeded();
                }
            }
        });
        if (!this.myBreakpoint.getType().isSuspendThreadSupported()) {
            return;
        }
        this.updateSuspendPolicyFont();
        ItemListener suspendPolicyChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XSuspendPolicyPanel.this.updateMakeDefaultEnableState();
            }
        };
        this.updateMakeDefaultEnableState();
        this.mySuspendAll.addItemListener(suspendPolicyChangeListener);
        this.mySuspendThread.addItemListener(suspendPolicyChangeListener);
        this.myMakeDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuspendPolicy suspendPolicy = XSuspendPolicyPanel.this.getSelectedSuspendPolicy();
                ((XBreakpointManagerImpl)XSuspendPolicyPanel.this.myBreakpointManager).getBreakpointDefaults(XSuspendPolicyPanel.this.myBreakpointType).setSuspendPolicy(suspendPolicy);
                XSuspendPolicyPanel.this.updateSuspendPolicyFont();
                JRadioButton comp = SuspendPolicy.THREAD == suspendPolicy ? XSuspendPolicyPanel.this.mySuspendThread : XSuspendPolicyPanel.this.mySuspendAll;
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)comp, true));
                XSuspendPolicyPanel.this.myMakeDefaultButton.setEnabled(false);
            }
        });
    }

    private void updateMakeDefaultEnableState() {
        boolean enabled = !this.getSelectedSuspendPolicy().equals((Object)((XBreakpointManagerImpl)this.myBreakpointManager).getBreakpointDefaults(this.myBreakpointType).getSuspendPolicy());
        ((CardLayout)this.myMakeDefaultPanel.getLayout()).show(this.myMakeDefaultPanel, enabled ? "Show" : "Hide");
        this.myMakeDefaultButton.setVisible(enabled);
        this.myMakeDefaultButton.setEnabled(enabled);
    }

    private void updateSuspendPolicyFont() {
        SuspendPolicy defaultPolicy = ((XBreakpointManagerImpl)this.myBreakpointManager).getBreakpointDefaults(this.myBreakpointType).getSuspendPolicy();
        Font font = this.mySuspendAll.getFont().deriveFont(0);
        Font boldFont = font.deriveFont(1);
        this.mySuspendAll.setFont(SuspendPolicy.ALL.equals((Object)defaultPolicy) ? boldFont : font);
        this.mySuspendThread.setFont(SuspendPolicy.THREAD.equals((Object)defaultPolicy) ? boldFont : font);
    }

    private void changeEnableState(boolean selected2) {
        this.mySuspendAll.setEnabled(selected2);
        this.mySuspendThread.setEnabled(selected2);
        if (selected2) {
            this.updateMakeDefaultEnableState();
        } else {
            this.myMakeDefaultButton.setEnabled(false);
        }
    }

    private void changeVisibleState(boolean suspendThreadSupported) {
        this.mySuspendAll.setVisible(suspendThreadSupported);
        this.mySuspendThread.setVisible(suspendThreadSupported);
        this.myMakeDefaultPanel.setVisible(suspendThreadSupported);
        if (!suspendThreadSupported) {
            this.mySuspendCheckBox.setText(XDebuggerBundle.message((String)"suspend.policy.panel.suspend.execution", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean lightVariant(boolean showAllOptions) {
        this.myContentPane.setBorder(null);
        return false;
    }

    public void hide() {
        this.myContentPane.getParent().remove(this.myContentPane);
    }

    @Override
    void loadProperties() {
        SuspendPolicy suspendPolicy = this.myBreakpoint.getSuspendPolicy();
        boolean selected2 = suspendPolicy != SuspendPolicy.NONE;
        boolean suspendThreadSupported = this.myBreakpoint.getType().isSuspendThreadSupported();
        this.changeVisibleState(suspendThreadSupported);
        if (suspendThreadSupported) {
            this.mySuspendPolicyGroup.setSelected(suspendPolicy == SuspendPolicy.THREAD ? this.mySuspendThread.getModel() : this.mySuspendAll.getModel(), true);
            this.changeEnableState(selected2);
        }
        this.mySuspendCheckBox.setSelected(selected2);
        if (!selected2 && this.myDelegate != null) {
            this.myDelegate.showMoreOptionsIfNeeded();
        }
    }

    private SuspendPolicy getSelectedSuspendPolicy() {
        if (!this.mySuspendCheckBox.isSelected()) {
            return SuspendPolicy.NONE;
        }
        if (this.myBreakpoint.getType().isSuspendThreadSupported()) {
            return this.mySuspendAll.isSelected() ? SuspendPolicy.ALL : SuspendPolicy.THREAD;
        }
        return this.myBreakpoint.getType().getDefaultSuspendPolicy();
    }

    @Override
    void saveProperties() {
        this.myBreakpoint.setSuspendPolicy(this.getSelectedSuspendPolicy());
    }

    public Delegate getDelegate() {
        return this.myDelegate;
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/xdebugger/impl/breakpoints/ui/XSuspendPolicyPanel", "init"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ButtonGroup buttonGroup2;
        JButton jButton;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        this.myContentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XSuspendPolicyPanel.class).getString("suspend.policy.panel.title"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySuspendAll = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XSuspendPolicyPanel.class).getString("suspend.policy.panel.all"));
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendThread = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XSuspendPolicyPanel.class).getString("suspend.policy.panel.thread"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySuspendCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XSuspendPolicyPanel.class).getString("suspend.policy.panel.suspend"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMakeDefaultPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMakeDefaultButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/XDebuggerBundle", XSuspendPolicyPanel.class).getString("suspend.policy.panel.makeDefault"));
        jPanel2.add((Component)jButton, "Show");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, "Hide");
        this.mySuspendPolicyGroup = buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public static interface Delegate {
        public void showMoreOptionsIfNeeded();
    }
}

