/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.ConversionException;
import org.jetbrains.idea.eclipse.config.EclipseModuleManagerImpl;
import org.jetbrains.idea.eclipse.conversion.EJavadocUtil;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;

public class EclipseClasspathWriter {
    public static final Logger LOG = Logger.getInstance(EclipseClasspathWriter.class);
    private final Map<String, Element> myOldEntries = new HashMap<String, Element>();

    @NotNull
    public Element writeClasspath(@Nullable Element oldRoot, @NotNull ModuleRootModel model) {
        if (model == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(0);
        }
        Element classpathElement = new Element("classpath");
        if (oldRoot != null) {
            for (Element oldChild : oldRoot.getChildren("classpathentry")) {
                String oldKind = oldChild.getAttributeValue("kind");
                String oldPath = oldChild.getAttributeValue("path");
                this.myOldEntries.put(oldKind + EclipseClasspathWriter.getJREKey(oldPath), oldChild);
            }
        }
        for (OrderEntry orderEntry : model.getOrderEntries()) {
            this.createClasspathEntry(orderEntry, classpathElement, model);
        }
        String outputPath = "bin";
        String compilerOutputUrl = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputUrl();
        EclipseModuleManagerImpl eclipseModuleManager = EclipseModuleManagerImpl.getInstance(model.getModule());
        String linkedPath = eclipseModuleManager.getEclipseLinkedVarPath(compilerOutputUrl);
        if (linkedPath != null) {
            outputPath = linkedPath;
        } else {
            VirtualFile contentRoot = EPathUtil.getContentRoot(model);
            VirtualFile output = ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).getCompilerOutputPath();
            if (contentRoot != null && output != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)output, (boolean)false)) {
                outputPath = EPathUtil.collapse2EclipsePath(output.getUrl(), model);
            } else if (output == null && compilerOutputUrl != null) {
                outputPath = EPathUtil.collapse2EclipsePath(compilerOutputUrl, model);
            }
        }
        for (String support : eclipseModuleManager.getUsedCons()) {
            EclipseClasspathWriter.addOrderEntry("con", support, classpathElement, eclipseModuleManager.getSrcPlace(support), this.myOldEntries);
        }
        EclipseClasspathWriter.setAttributeIfAbsent(this.addOrderEntry("output", outputPath, classpathElement), "path", "bin");
        Element element = classpathElement;
        if (element == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(1);
        }
        return element;
    }

    private void createClasspathEntry(@NotNull OrderEntry entry, @NotNull Element classpathRoot, @NotNull ModuleRootModel model) throws ConversionException {
        if (entry == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(2);
        }
        if (classpathRoot == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(3);
        }
        if (model == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(4);
        }
        EclipseModuleManagerImpl eclipseModuleManager = EclipseModuleManagerImpl.getInstance(entry.getOwnerModule());
        if (entry instanceof ModuleSourceOrderEntry) {
            boolean shouldPlaceSeparately = eclipseModuleManager.isExpectedModuleSourcePlace(ArrayUtil.find((Object[])model.getOrderEntries(), (Object)entry));
            for (ContentEntry contentEntry : model.getContentEntries()) {
                VirtualFile contentRoot = contentEntry.getFile();
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    String linkedPath;
                    String srcUrl = sourceFolder.getUrl();
                    String relativePath = EPathUtil.collapse2EclipsePath(srcUrl, model);
                    if (!Comparing.equal((Object)contentRoot, (Object)EPathUtil.getContentRoot(model)) && (linkedPath = EclipseModuleManagerImpl.getInstance(entry.getOwnerModule()).getEclipseLinkedSrcVariablePath(srcUrl)) != null) {
                        relativePath = linkedPath;
                    }
                    int index = eclipseModuleManager.getSrcPlace(srcUrl);
                    EclipseClasspathWriter.addOrderEntry("src", relativePath, classpathRoot, shouldPlaceSeparately && index != -1 ? index : -1, this.myOldEntries);
                }
            }
        } else if (entry instanceof ModuleOrderEntry) {
            String path = "/" + ((ModuleOrderEntry)entry).getModuleName();
            Element oldElement = EclipseClasspathWriter.getOldElement("src", path, this.myOldEntries);
            Element orderEntry = this.addOrderEntry("src", path, classpathRoot);
            if (oldElement == null) {
                EclipseClasspathWriter.setAttributeIfAbsent(orderEntry, "combineaccessrules", "false");
            }
            EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)entry);
        } else if (entry instanceof LibraryOrderEntry) {
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            String libraryName = libraryOrderEntry.getLibraryName();
            if (libraryOrderEntry.isModuleLevel()) {
                String[] files = libraryOrderEntry.getRootUrls(OrderRootType.CLASSES);
                if (files.length > 0) {
                    if (libraryName != null && libraryName.contains("junit") && Comparing.strEqual((String)files[0], (String)EclipseClasspathReader.getJunitClsUrl(libraryName.contains("4")))) {
                        Element orderEntry = this.addOrderEntry("con", "org.eclipse.jdt.junit.JUNIT_CONTAINER/" + libraryName.substring("junit".length()), classpathRoot);
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    } else {
                        String srcRelativePath;
                        Element orderEntry;
                        boolean newVarLibrary = false;
                        boolean link = false;
                        String eclipseVariablePath = eclipseModuleManager.getEclipseVariablePath(files[0]);
                        if (eclipseVariablePath == null) {
                            eclipseVariablePath = eclipseModuleManager.getEclipseLinkedVarPath(files[0]);
                            boolean bl = link = eclipseVariablePath != null;
                        }
                        if (eclipseVariablePath == null && !eclipseModuleManager.isEclipseLibUrl(files[0])) {
                            newVarLibrary = true;
                            eclipseVariablePath = EPathUtil.collapse2EclipseVariabledPath(libraryOrderEntry, OrderRootType.CLASSES);
                        }
                        if (eclipseVariablePath != null) {
                            orderEntry = this.addOrderEntry(link ? "lib" : "var", eclipseVariablePath, classpathRoot);
                        } else {
                            LOG.assertTrue(!StringUtil.isEmptyOrSpaces((String)files[0]), (Object)("Library: " + libraryName));
                            orderEntry = this.addOrderEntry("lib", EPathUtil.collapse2EclipsePath(files[0], model), classpathRoot);
                        }
                        Object eclipseSrcVariablePath = null;
                        boolean addSrcRoots = true;
                        String[] srcFiles = libraryOrderEntry.getRootUrls(OrderRootType.SOURCES);
                        if (srcFiles.length == 0) {
                            srcRelativePath = null;
                        } else {
                            String srcFile = srcFiles[0];
                            srcRelativePath = EPathUtil.collapse2EclipsePath(srcFile, model);
                            if (eclipseVariablePath != null) {
                                eclipseSrcVariablePath = eclipseModuleManager.getEclipseSrcVariablePath(srcFile);
                                if (eclipseSrcVariablePath == null) {
                                    eclipseSrcVariablePath = eclipseModuleManager.getEclipseLinkedSrcVariablePath(srcFile);
                                }
                                if (eclipseSrcVariablePath == null) {
                                    eclipseSrcVariablePath = EPathUtil.collapse2EclipseVariabledPath(libraryOrderEntry, OrderRootType.SOURCES);
                                    if (eclipseSrcVariablePath != null) {
                                        eclipseSrcVariablePath = "/" + (String)eclipseSrcVariablePath;
                                    } else if (newVarLibrary) {
                                        orderEntry.detach();
                                        orderEntry = this.addOrderEntry("lib", EPathUtil.collapse2EclipsePath(files[0], model), classpathRoot);
                                    } else {
                                        LOG.info("Added root " + srcRelativePath + " (in existing var library) can't be replaced with any variable; src roots placed in .eml only");
                                        addSrcRoots = false;
                                    }
                                }
                            }
                        }
                        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "sourcepath", addSrcRoots ? (eclipseSrcVariablePath != null ? eclipseSrcVariablePath : srcRelativePath) : null);
                        EJavadocUtil.setupJavadocAttributes(orderEntry, libraryOrderEntry, model);
                        String[] nativeRoots2 = libraryOrderEntry.getUrls(NativeLibraryOrderRootType.getInstance());
                        if (nativeRoots2.length > 0) {
                            EJavadocUtil.setupAttributes(orderEntry, nativeRoot -> EPathUtil.collapse2EclipsePath(nativeRoot, model), "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", nativeRoots2);
                        }
                        EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
                    }
                }
            } else {
                Element orderEntry = eclipseModuleManager.getUnknownCons().contains(libraryName) ? this.addOrderEntry("con", libraryName, classpathRoot) : (Comparing.strEqual((String)libraryName, (String)"ECLIPSE") ? this.addOrderEntry("con", "org.eclipse.pde.core.requiredPlugins", classpathRoot) : this.addOrderEntry("con", "org.eclipse.jdt.USER_LIBRARY/" + libraryName, classpathRoot));
                EclipseClasspathWriter.setExported(orderEntry, (ExportableOrderEntry)libraryOrderEntry);
            }
        } else if (entry instanceof JdkOrderEntry) {
            if (entry instanceof InheritedJdkOrderEntry) {
                if (!EclipseModuleManagerImpl.getInstance(entry.getOwnerModule()).isForceConfigureJDK()) {
                    this.addOrderEntry("con", "org.eclipse.jdt.launching.JRE_CONTAINER", classpathRoot);
                }
            } else {
                Object jdkLink;
                Sdk jdk = ((JdkOrderEntry)entry).getJdk();
                if (jdk == null) {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                } else {
                    jdkLink = "org.eclipse.jdt.launching.JRE_CONTAINER";
                    if (jdk.getSdkType() instanceof JavaSdkType) {
                        jdkLink = (String)jdkLink + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
                    }
                    jdkLink = (String)jdkLink + "/" + jdk.getName();
                }
                this.addOrderEntry("con", (String)jdkLink, classpathRoot);
            }
        } else {
            throw new ConversionException("Unknown EclipseProjectModel.ClasspathEntry: " + entry.getClass());
        }
    }

    private Element addOrderEntry(String kind, String path, Element classpathRoot) {
        return EclipseClasspathWriter.addOrderEntry(kind, path, classpathRoot, this.myOldEntries);
    }

    public static Element addOrderEntry(String kind, String path, Element classpathRoot, Map<String, Element> oldEntries) {
        return EclipseClasspathWriter.addOrderEntry(kind, path, classpathRoot, -1, oldEntries);
    }

    public static Element addOrderEntry(@NotNull String kind, String path, Element classpathRoot, int index, Map<String, Element> oldEntries) {
        Element element;
        if (kind == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(5);
        }
        if ((element = EclipseClasspathWriter.getOldElement(kind, path, oldEntries)) != null) {
            Element clonedElement = element.clone();
            if (index == -1 || index >= classpathRoot.getContentSize()) {
                classpathRoot.addContent(clonedElement);
            } else {
                classpathRoot.addContent(index, (Content)clonedElement);
            }
            return clonedElement;
        }
        Element orderEntry = new Element("classpathentry");
        orderEntry.setAttribute("kind", kind);
        if (path != null) {
            orderEntry.setAttribute("path", path);
        }
        if (index == -1 || index >= classpathRoot.getContentSize()) {
            classpathRoot.addContent(orderEntry);
        } else {
            classpathRoot.addContent(index, (Content)orderEntry);
        }
        return orderEntry;
    }

    public static Element getOldElement(@NotNull String kind, String path, Map<String, Element> entries) {
        if (kind == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(6);
        }
        return entries.get(kind + EclipseClasspathWriter.getJREKey(path));
    }

    public static String getJREKey(String path) {
        return path.startsWith("org.eclipse.jdt.launching.JRE_CONTAINER") ? "org.eclipse.jdt.launching.JRE_CONTAINER" : path;
    }

    private static void setExported(Element orderEntry, ExportableOrderEntry dependency) {
        EclipseClasspathWriter.setExported(orderEntry, dependency.isExported());
    }

    public static void setExported(Element orderEntry, boolean exported) {
        EclipseClasspathWriter.setOrRemoveAttribute(orderEntry, "exported", exported ? "true" : null);
    }

    public static void setOrRemoveAttribute(@NotNull Element element, @NotNull String name, @Nullable String value) {
        if (element == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(7);
        }
        if (name == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(8);
        }
        if (value == null) {
            element.removeAttribute(name);
        } else {
            element.setAttribute(name, value);
        }
    }

    public static void setAttributeIfAbsent(@NotNull Element element, String name, String value) {
        if (element == null) {
            EclipseClasspathWriter.$$$reportNull$$$0(9);
        }
        if (element.getAttribute(name) == null) {
            element.setAttribute(name, value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpathRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/conversion/EclipseClasspathWriter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "writeClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeClasspath";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createClasspathEntry";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addOrderEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOldElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOrRemoveAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeIfAbsent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

