/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.intellilang.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.intellilang.instrumentation.ErrorPostponingMethodVisitor;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationAdapter;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationException;
import org.jetbrains.jps.intellilang.instrumentation.InstrumentationType;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;

class PatternInstrumenter
extends ClassVisitor
implements Opcodes {
    static final String PATTERN_CACHE_NAME = "$_PATTERN_CACHE_$";
    static final String ASSERTIONS_DISABLED_NAME = "$assertionsDisabled";
    static final String JAVA_LANG_STRING = "Ljava/lang/String;";
    static final String JAVA_UTIL_REGEX_PATTERN = "[Ljava/util/regex/Pattern;";
    static final String NULL_PATTERN = "((((";
    private final String myPatternAnnotationClassName;
    private final boolean myDoAssert;
    private final InstrumentationClassFinder myClassFinder;
    private final Map<String, String> myAnnotationPatterns;
    private final LinkedHashSet<String> myPatterns;
    private String myClassName;
    private boolean myEnum;
    private boolean myInner;
    private boolean myHasAssertions;
    private boolean myHasStaticInitializer;
    private boolean myInstrumented;
    private RuntimeException myPostponedError;

    PatternInstrumenter(@NotNull String patternAnnotationClassName, ClassVisitor classvisitor, InstrumentationType instrumentation, InstrumentationClassFinder classFinder) {
        if (patternAnnotationClassName == null) {
            PatternInstrumenter.$$$reportNull$$$0(0);
        }
        super(589824, classvisitor);
        this.myAnnotationPatterns = new HashMap<String, String>();
        this.myPatterns = new LinkedHashSet();
        this.myPatternAnnotationClassName = patternAnnotationClassName;
        this.myDoAssert = instrumentation == InstrumentationType.ASSERT;
        this.myClassFinder = classFinder;
        this.myAnnotationPatterns.put(patternAnnotationClassName, NULL_PATTERN);
    }

    boolean instrumented() {
        return this.myInstrumented;
    }

    void markInstrumented() {
        this.myInstrumented = true;
        if (this.myPostponedError != null) {
            throw this.myPostponedError;
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.myClassName = name;
        this.myEnum = (access & 0x4000) != 0;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
        if (this.myClassName.equals(name)) {
            this.myInner = (access & 8) == 0;
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals(ASSERTIONS_DISABLED_NAME)) {
            this.myHasAssertions = true;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        if (this.myInstrumented) {
            for (String pattern : this.myPatterns) {
                try {
                    Pattern.compile(pattern);
                }
                catch (Exception e) {
                    throw new InstrumentationException("Illegal Pattern: " + pattern, e);
                }
            }
            this.addField(PATTERN_CACHE_NAME, 4122, JAVA_UTIL_REGEX_PATTERN);
            if (this.myDoAssert && !this.myHasAssertions) {
                this.addField(ASSERTIONS_DISABLED_NAME, 4120, "Z");
            }
            if (!this.myHasStaticInitializer) {
                MethodVisitor mv = this.cv.visitMethod(8, "<clinit>", "()V", null, null);
                mv.visitCode();
                this.patchStaticInitializer(mv);
                mv.visitInsn(177);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }
        super.visitEnd();
    }

    private void addField(String name, int access, String desc) {
        this.cv.visitField(access, name, desc, null, null).visitEnd();
    }

    private void patchStaticInitializer(MethodVisitor mv) {
        if (this.myDoAssert && !this.myHasAssertions) {
            mv.visitLdcInsn((Object)Type.getType((String)("L" + this.myClassName + ";")));
            mv.visitMethodInsn(182, "java/lang/Class", "desiredAssertionStatus", "()Z", false);
            Label l0 = new Label();
            mv.visitJumpInsn(154, l0);
            mv.visitInsn(4);
            Label l1 = new Label();
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l0);
            mv.visitInsn(3);
            mv.visitLabel(l1);
            mv.visitFieldInsn(179, this.myClassName, ASSERTIONS_DISABLED_NAME, "Z");
        }
        mv.visitIntInsn(16, this.myPatterns.size());
        mv.visitTypeInsn(189, "java/util/regex/Pattern");
        mv.visitFieldInsn(179, this.myClassName, PATTERN_CACHE_NAME, JAVA_UTIL_REGEX_PATTERN);
        int i = 0;
        for (String pattern : this.myPatterns) {
            mv.visitFieldInsn(178, this.myClassName, PATTERN_CACHE_NAME, JAVA_UTIL_REGEX_PATTERN);
            mv.visitIntInsn(16, i++);
            mv.visitLdcInsn((Object)pattern);
            mv.visitMethodInsn(184, "java/util/regex/Pattern", "compile", "(Ljava/lang/String;)Ljava/util/regex/Pattern;", false);
            mv.visitInsn(83);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type returnType;
        Type[] argTypes;
        boolean isStatic;
        MethodVisitor methodvisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        boolean bl = isStatic = (access & 8) != 0;
        if (isStatic && name.equals("<clinit>")) {
            this.myHasStaticInitializer = true;
            return new ErrorPostponingMethodVisitor(this, name, methodvisitor){

                public void visitCode() {
                    super.visitCode();
                    PatternInstrumenter.this.patchStaticInitializer(this.mv);
                }
            };
        }
        if ((access & 0x40) == 0 && PatternInstrumenter.isCandidate(argTypes = Type.getArgumentTypes((String)desc), returnType = Type.getReturnType((String)desc))) {
            int offset = !"<init>".equals(name) ? 0 : (this.myEnum ? 2 : (this.myInner ? 1 : 0));
            return new InstrumentationAdapter(this, methodvisitor, argTypes, returnType, this.myClassName, name, this.myDoAssert, isStatic, offset);
        }
        return new ErrorPostponingMethodVisitor(this, name, methodvisitor);
    }

    private static boolean isCandidate(Type[] argTypes, Type returnType) {
        if (PatternInstrumenter.isStringType(returnType)) {
            return true;
        }
        for (Type argType : argTypes) {
            if (!PatternInstrumenter.isStringType(argType)) continue;
            return true;
        }
        return false;
    }

    static boolean isStringType(Type type) {
        return type.getSort() == 10 && type.getDescriptor().equals(JAVA_LANG_STRING);
    }

    int addPattern(String s) {
        return this.myPatterns.add(s) ? this.myPatterns.size() - 1 : Arrays.asList(this.myPatterns.toArray()).indexOf(s);
    }

    @Nullable
    String getAnnotationPattern(final String annotationClassName) {
        if (!this.myAnnotationPatterns.containsKey(annotationClassName)) {
            this.myAnnotationPatterns.put(annotationClassName, null);
            try (InputStream is = this.myClassFinder.getClassBytesAsStream(annotationClassName);){
                if (is != null) {
                    new ClassReader(is).accept(new ClassVisitor(589824){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            boolean matches = PatternInstrumenter.this.myPatternAnnotationClassName.equals(Type.getType((String)desc).getClassName());
                            return !matches ? null : new AnnotationVisitor(589824){

                                public void visit(String name, Object value) {
                                    if ("value".equals(name) && value instanceof String) {
                                        PatternInstrumenter.this.myAnnotationPatterns.put(annotationClassName, (String)value);
                                    }
                                }
                            };
                        }
                    }, 7);
                }
            }
            catch (IOException e) {
                Logger.getInstance(PatternInstrumenter.class).info("failed to read " + annotationClassName, (Throwable)e);
            }
        }
        return this.myAnnotationPatterns.get(annotationClassName);
    }

    void registerError(String methodName, String op, Throwable e) {
        if (this.myPostponedError == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(out));
            String message = "Operation '" + op + "' failed for " + this.myClassName + '.' + methodName + "(): " + e.getMessage() + '\n' + out;
            this.myPostponedError = new RuntimeException(message, e);
        }
        if (this.myInstrumented) {
            throw this.myPostponedError;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patternAnnotationClassName", "org/jetbrains/jps/intellilang/instrumentation/PatternInstrumenter", "<init>"));
    }
}

