/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.metadata;

import org.gradle.internal.impldep.org.apache.maven.artifact.ArtifactScopeEnum;
import org.gradle.internal.impldep.org.apache.maven.repository.metadata.ArtifactMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataGraphVertex
implements Comparable<MetadataGraphVertex> {
    ArtifactMetadata md;
    private boolean compareVersion = false;
    private boolean compareScope = false;

    public MetadataGraphVertex(ArtifactMetadata md) {
        this.md = md;
    }

    public MetadataGraphVertex(ArtifactMetadata md, boolean compareVersion, boolean compareScope) {
        this(md);
        this.compareVersion = compareVersion;
        this.compareScope = compareScope;
    }

    public ArtifactMetadata getMd() {
        return this.md;
    }

    public void setMd(ArtifactMetadata md) {
        this.md = md;
    }

    public boolean isCompareVersion() {
        return this.compareVersion;
    }

    public void setCompareVersion(boolean compareVersion) {
        this.compareVersion = compareVersion;
    }

    public boolean isCompareScope() {
        return this.compareScope;
    }

    public void setCompareScope(boolean compareScope) {
        this.compareScope = compareScope;
    }

    public String toString() {
        return "[" + (this.md == null ? "no metadata" : this.md.toString()) + "]";
    }

    private static int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null && s2 != null) {
            return -1;
        }
        if (s1 != null && s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    @Override
    public int compareTo(MetadataGraphVertex vertex) {
        if (vertex == null || vertex.getMd() == null) {
            return 1;
        }
        ArtifactMetadata vmd = vertex.getMd();
        if (vmd == null) {
            if (this.md == null) {
                return 0;
            }
            return 1;
        }
        int g = MetadataGraphVertex.compareStrings(this.md.groupId, vmd.groupId);
        if (g == 0) {
            int a = MetadataGraphVertex.compareStrings(this.md.artifactId, vmd.artifactId);
            if (a == 0) {
                if (this.compareVersion) {
                    int v = MetadataGraphVertex.compareStrings(this.md.version, vmd.version);
                    if (v == 0) {
                        if (this.compareScope) {
                            String s1 = ArtifactScopeEnum.checkScope(this.md.artifactScope).getScope();
                            String s2 = ArtifactScopeEnum.checkScope(vmd.artifactScope).getScope();
                            return s1.compareTo(s2);
                        }
                        return 0;
                    }
                    return v;
                }
                return 0;
            }
            return a;
        }
        return g;
    }

    public boolean equals(Object vo) {
        if (vo == null || !(vo instanceof MetadataGraphVertex)) {
            return false;
        }
        return this.compareTo((MetadataGraphVertex)vo) == 0;
    }

    public int hashCode() {
        if (this.md == null) {
            return super.hashCode();
        }
        StringBuilder hashString = new StringBuilder(128);
        hashString.append(this.md.groupId + "|");
        hashString.append(this.md.artifactId + "|");
        if (this.compareVersion) {
            hashString.append(this.md.version + "|");
        }
        if (this.compareScope) {
            hashString.append((Object)((Object)this.md.getArtifactScope()) + "|");
        }
        return hashString.toString().hashCode();
    }
}

