/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.internal.impldep.org.testng.internal.Utils;
import org.gradle.internal.impldep.org.testng.internal.XmlMethodSelector;
import org.gradle.internal.impldep.org.testng.xml.Parser;
import org.gradle.internal.impldep.org.testng.xml.XmlClass;
import org.gradle.internal.impldep.org.testng.xml.XmlInclude;
import org.gradle.internal.impldep.org.testng.xml.XmlPackage;
import org.gradle.internal.impldep.org.testng.xml.XmlSuite;
import org.gradle.internal.impldep.org.testng.xml.XmlTest;
import org.gradle.internal.impldep.org.yaml.snakeyaml.Loader;
import org.gradle.internal.impldep.org.yaml.snakeyaml.TypeDescription;
import org.gradle.internal.impldep.org.yaml.snakeyaml.constructor.BaseConstructor;
import org.gradle.internal.impldep.org.yaml.snakeyaml.constructor.Constructor;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Yaml {
    private static final String SP = "  ";

    public static XmlSuite parse(String filePath, InputStream is) throws FileNotFoundException {
        Constructor constructor = new Constructor(XmlSuite.class);
        TypeDescription suiteDescription = new TypeDescription(XmlSuite.class);
        suiteDescription.putListPropertyType("packages", XmlPackage.class);
        suiteDescription.putListPropertyType("listeners", String.class);
        suiteDescription.putListPropertyType("tests", XmlTest.class);
        suiteDescription.putListPropertyType("method-selectors", XmlMethodSelector.class);
        constructor.addTypeDescription(suiteDescription);
        TypeDescription testDescription = new TypeDescription(XmlTest.class);
        testDescription.putListPropertyType("classes", XmlClass.class);
        testDescription.putMapPropertyType("metaGroups", String.class, List.class);
        testDescription.putListPropertyType("method-selectors", XmlMethodSelector.class);
        constructor.addTypeDescription(testDescription);
        Loader loader = new Loader((BaseConstructor)constructor);
        org.gradle.internal.impldep.org.yaml.snakeyaml.Yaml y = new org.gradle.internal.impldep.org.yaml.snakeyaml.Yaml(loader);
        if (is == null) {
            is = new FileInputStream(new File(filePath));
        }
        XmlSuite result = (XmlSuite)y.load(is);
        result.setFileName(filePath);
        for (XmlTest t : result.getTests()) {
            t.setSuite(result);
            int index = 0;
            for (XmlClass c : t.getClasses()) {
                c.setIndex(index++);
            }
        }
        return result;
    }

    private static void maybeAdd(StringBuilder sb, String key, Object value, Object def) {
        Yaml.maybeAdd(sb, "", key, value, def);
    }

    private static void maybeAdd(StringBuilder sb, String sp, String key, Object value, Object def) {
        if (value != null && !value.equals(def)) {
            sb.append(sp).append(key).append(": ").append(value.toString()).append("\n");
        }
    }

    public static StringBuilder toYaml(XmlSuite suite) {
        StringBuilder result = new StringBuilder();
        Yaml.maybeAdd(result, "name", suite.getName(), null);
        Yaml.maybeAdd(result, "junit", suite.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        Yaml.maybeAdd(result, "verbose", suite.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        Yaml.maybeAdd(result, "threadCount", suite.getThreadCount(), XmlSuite.DEFAULT_THREAD_COUNT);
        Yaml.maybeAdd(result, "dataProviderThreadCount", suite.getDataProviderThreadCount(), XmlSuite.DEFAULT_DATA_PROVIDER_THREAD_COUNT);
        Yaml.maybeAdd(result, "timeOut", suite.getTimeOut(), null);
        Yaml.maybeAdd(result, "parallel", suite.getParallel(), XmlSuite.DEFAULT_PARALLEL);
        Yaml.maybeAdd(result, "skipFailedInvocationCounts", suite.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        Yaml.toYaml(result, "parameters", "", suite.getParameters());
        Yaml.toYaml(result, suite.getPackages());
        if (suite.getListeners().size() > 0) {
            result.append("listeners:\n");
            Yaml.toYaml(result, SP, suite.getListeners());
        }
        if (suite.getPackages().size() > 0) {
            result.append("packages:\n");
            Yaml.toYaml(result, suite.getPackages());
        }
        if (suite.getTests().size() > 0) {
            result.append("tests:\n");
            for (XmlTest t : suite.getTests()) {
                Yaml.toYaml(result, SP, t);
            }
        }
        if (suite.getChildSuites().size() > 0) {
            result.append("suite-files:\n");
            Yaml.toYaml(result, SP, suite.getSuiteFiles());
        }
        return result;
    }

    private static void toYaml(StringBuilder result, String sp, XmlTest t) {
        Map<String, List<String>> mg;
        String sp2 = sp + SP;
        result.append(sp).append("- name: ").append(t.getName()).append("\n");
        Yaml.maybeAdd(result, sp2, "junit", t.isJUnit(), XmlSuite.DEFAULT_JUNIT);
        Yaml.maybeAdd(result, sp2, "verbose", t.getVerbose(), XmlSuite.DEFAULT_VERBOSE);
        Yaml.maybeAdd(result, sp2, "timeOut", t.getTimeOut(), null);
        Yaml.maybeAdd(result, sp2, "parallel", t.getParallel(), XmlSuite.DEFAULT_PARALLEL);
        Yaml.maybeAdd(result, sp2, "skipFailedInvocationCounts", t.skipFailedInvocationCounts(), XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS);
        Yaml.maybeAdd(result, "preserveOrder", sp2, t.getPreserveOrder(), XmlSuite.DEFAULT_PRESERVE_ORDER);
        Yaml.toYaml(result, "parameters", sp2, t.getTestParameters());
        if (t.getIncludedGroups().size() > 0) {
            result.append(sp2).append("includedGroups: [ ").append(Utils.join(t.getIncludedGroups(), ",")).append(" ]\n");
        }
        if (t.getExcludedGroups().size() > 0) {
            result.append(sp2).append("excludedGroups: [ ").append(Utils.join(t.getExcludedGroups(), ",")).append(" ]\n");
        }
        if ((mg = t.getMetaGroups()).size() > 0) {
            result.append(sp2).append("metaGroups: { ");
            boolean first = true;
            for (String group : mg.keySet()) {
                if (!first) {
                    result.append(", ");
                }
                result.append(group).append(": [ ").append(Utils.join(mg.get(group), ",")).append(" ] ");
                first = false;
            }
            result.append(" }\n");
        }
        if (t.getXmlPackages().size() > 0) {
            result.append(sp2).append("xmlPackages:\n");
            for (XmlPackage xp : t.getXmlPackages()) {
                Yaml.toYaml(result, sp2 + "  - ", xp);
            }
        }
        if (t.getXmlClasses().size() > 0) {
            result.append(sp2).append("classes:\n");
            for (XmlClass xc : t.getXmlClasses()) {
                Yaml.toYaml(result, sp2 + SP, xc);
            }
        }
        result.append("\n");
    }

    private static void toYaml(StringBuilder result, String sp2, XmlClass xc) {
        List<XmlInclude> im = xc.getIncludedMethods();
        List<String> em = xc.getExcludedMethods();
        String name = im.size() > 0 || em.size() > 0 ? "name: " : "";
        result.append(sp2).append("- " + name).append(xc.getName()).append("\n");
        if (im.size() > 0) {
            result.append(sp2 + "  includedMethods:\n");
            for (XmlInclude xi : im) {
                Yaml.toYaml(result, sp2 + "    ", xi);
            }
        }
        if (em.size() > 0) {
            result.append(sp2 + "  excludedMethods:\n");
            Yaml.toYaml(result, sp2 + "    ", em);
        }
    }

    private static void toYaml(StringBuilder result, String sp2, XmlInclude xi) {
        result.append(sp2 + "- " + xi.getName()).append("\n");
    }

    private static void toYaml(StringBuilder result, String sp, List<String> strings) {
        for (String l : strings) {
            result.append(sp).append("- ").append(l).append("\n");
        }
    }

    private static void toYaml(StringBuilder sb, List<XmlPackage> packages) {
        if (packages.size() > 0) {
            sb.append("packages:\n");
            for (XmlPackage p : packages) {
                Yaml.toYaml(sb, SP, p);
            }
        }
        for (XmlPackage p : packages) {
            Yaml.toYaml(sb, SP, p);
        }
    }

    private static void toYaml(StringBuilder sb, String sp, XmlPackage p) {
        sb.append(sp).append("name: ").append(p.getName()).append("\n");
        Yaml.generateIncludeExclude(sb, sp, "includes", p.getInclude());
        Yaml.generateIncludeExclude(sb, sp, "excludes", p.getExclude());
    }

    private static void generateIncludeExclude(StringBuilder sb, String sp, String key, List<String> includes) {
        if (includes.size() > 0) {
            sb.append(sp).append(SP).append(key).append("\n");
            for (String inc : includes) {
                sb.append(sp).append("    ").append(inc);
            }
        }
    }

    private static void mapToYaml(Map<String, String> map, StringBuilder out) {
        if (map.size() > 0) {
            out.append("{ ");
            boolean first = true;
            for (Map.Entry<String, String> e : map.entrySet()) {
                if (!first) {
                    out.append(", ");
                }
                first = false;
                out.append(e.getKey() + ": " + e.getValue());
            }
            out.append(" }\n");
        }
    }

    private static void toYaml(StringBuilder sb, String key, String sp, Map<String, String> parameters) {
        if (parameters.size() > 0) {
            sb.append(sp).append(key).append(": ");
            Yaml.mapToYaml(parameters, sb);
        }
    }

    public static void main(String[] args) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        Collection<XmlSuite> s = new Parser(args[0]).parse();
        System.out.println(s.iterator().next().toXml());
    }
}

