/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.fest.util.Preconditions;

public final class Lists {
    private Lists() {
    }

    @Nonnull
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        Preconditions.checkNotNull(elements);
        ArrayList<T> list = Lists.newArrayList();
        for (T e : elements) {
            list.add(e);
        }
        return list;
    }

    @Nonnull
    public static <T> ArrayList<T> newArrayList(@Nonnull Iterable<? extends T> elements) {
        Preconditions.checkNotNull(elements);
        ArrayList<T> list = Lists.newArrayList();
        for (T e : elements) {
            list.add(e);
        }
        return list;
    }

    @Nonnull
    public static <T> ArrayList<T> newArrayList(@Nonnull Iterator<? extends T> elements) {
        Preconditions.checkNotNull(elements);
        ArrayList<T> list = Lists.newArrayList();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    @Nonnull
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @Nonnull
    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }
}

