/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchPanel;
import org.jetbrains.idea.maven.model.MavenId;

public final class MavenArtifactSearchDialog
extends DialogWrapper {
    private List<MavenId> myResult = Collections.emptyList();
    public static List<MavenId> ourResultForTest;
    private TabbedPaneWrapper myTabbedPane;
    private MavenArtifactSearchPanel myArtifactsPanel;
    private MavenArtifactSearchPanel myClassesPanel;
    private final Map<Pair<String, String>, String> myManagedDependenciesMap = new HashMap<Pair<String, String>, String>();
    private final Map<MavenArtifactSearchPanel, Boolean> myOkButtonStates = new THashMap();

    @NotNull
    public static List<MavenId> searchForClass(Project project, String className) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (ourResultForTest != null);
            List<MavenId> res = ourResultForTest;
            ourResultForTest = null;
            List<MavenId> list = res;
            if (list == null) {
                MavenArtifactSearchDialog.$$$reportNull$$$0(0);
            }
            return list;
        }
        MavenArtifactSearchDialog d = new MavenArtifactSearchDialog(project, className, true);
        if (!d.showAndGet()) {
            List<MavenId> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactSearchDialog.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<MavenId> list = d.getResult();
        if (list == null) {
            MavenArtifactSearchDialog.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<MavenId> searchForArtifact(Project project, Collection<MavenDomDependency> managedDependencies) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (ourResultForTest != null);
            List<MavenId> res = ourResultForTest;
            ourResultForTest = null;
            List<MavenId> list = res;
            if (list == null) {
                MavenArtifactSearchDialog.$$$reportNull$$$0(3);
            }
            return list;
        }
        MavenArtifactSearchDialog d = new MavenArtifactSearchDialog(project, "", false);
        d.setManagedDependencies(managedDependencies);
        if (!d.showAndGet()) {
            List<MavenId> list = Collections.emptyList();
            if (list == null) {
                MavenArtifactSearchDialog.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<MavenId> list = d.getResult();
        if (list == null) {
            MavenArtifactSearchDialog.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void setManagedDependencies(Collection<MavenDomDependency> managedDependencies) {
        this.myManagedDependenciesMap.clear();
        for (MavenDomDependency dependency : managedDependencies) {
            String groupId = dependency.getGroupId().getStringValue();
            String artifactId = dependency.getArtifactId().getStringValue();
            String version = dependency.getVersion().getStringValue();
            if (!StringUtil.isNotEmpty((String)groupId) || !StringUtil.isNotEmpty((String)artifactId) || !StringUtil.isNotEmpty((String)version)) continue;
            this.myManagedDependenciesMap.put((Pair<String, String>)Pair.create((Object)groupId, (Object)artifactId), version);
        }
    }

    private MavenArtifactSearchDialog(Project project, @NlsSafe String initialText, boolean classMode) {
        super(project, true);
        this.initComponents(project, initialText, classMode);
        this.setTitle(MavenDomBundle.message("maven.artifact.pom.search.title", new Object[0]));
        this.updateOkButtonState();
        this.init();
        this.myArtifactsPanel.scheduleSearch();
        this.myClassesPanel.scheduleSearch();
    }

    private void initComponents(Project project, @NlsSafe String initialText, boolean classMode) {
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        MavenArtifactSearchPanel.Listener listener2 = new MavenArtifactSearchPanel.Listener(){

            @Override
            public void itemSelected() {
                MavenArtifactSearchDialog.this.clickDefaultButton();
            }

            @Override
            public void canSelectStateChanged(@NotNull MavenArtifactSearchPanel from, boolean canSelect) {
                if (from == null) {
                    1.$$$reportNull$$$0(0);
                }
                MavenArtifactSearchDialog.this.myOkButtonStates.put(from, canSelect);
                MavenArtifactSearchDialog.this.updateOkButtonState();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/idea/maven/indices/MavenArtifactSearchDialog$1", "canSelectStateChanged"));
            }
        };
        this.myArtifactsPanel = new MavenArtifactSearchPanel(project, !classMode ? initialText : "", false, listener2, this, this.myManagedDependenciesMap);
        this.myClassesPanel = new MavenArtifactSearchPanel(project, classMode ? initialText : "", true, listener2, this, this.myManagedDependenciesMap);
        this.myTabbedPane.addTab(MavenDomBundle.message("maven.search.for.artifact.tab.title", new Object[0]), (JComponent)this.myArtifactsPanel);
        this.myTabbedPane.addTab(MavenDomBundle.message("maven.search.for.class.tab.title", new Object[0]), (JComponent)this.myClassesPanel);
        this.myTabbedPane.setSelectedIndex(classMode ? 1 : 0);
        this.myTabbedPane.getComponent().setPreferredSize((Dimension)JBUI.size((int)900, (int)600));
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MavenArtifactSearchDialog.this.updateOkButtonState();
            }
        });
        this.updateOkButtonState();
    }

    private void updateOkButtonState() {
        Boolean canSelect = this.myOkButtonStates.get(this.myTabbedPane.getSelectedComponent());
        if (canSelect == null) {
            canSelect = false;
        }
        this.setOKActionEnabled(canSelect);
    }

    @NotNull
    protected Action getOKAction() {
        Action result = super.getOKAction();
        result.putValue("Name", MavenDomBundle.message("maven.artifact.pom.search.add", new Object[0]));
        Action action = result;
        if (action == null) {
            MavenArtifactSearchDialog.$$$reportNull$$$0(6);
        }
        return action;
    }

    protected JComponent createCenterPanel() {
        return this.myTabbedPane.getComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTabbedPane.getSelectedIndex() == 0 ? this.myArtifactsPanel.getSearchField() : this.myClassesPanel.getSearchField();
    }

    protected String getDimensionServiceKey() {
        return "Maven.ArtifactSearchDialog";
    }

    @NotNull
    public List<MavenId> getResult() {
        List<MavenId> list = this.myResult;
        if (list == null) {
            MavenArtifactSearchDialog.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected void doOKAction() {
        MavenArtifactSearchPanel panel2 = this.myTabbedPane.getSelectedIndex() == 0 ? this.myArtifactsPanel : this.myClassesPanel;
        this.myResult = panel2.getResult();
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/indices/MavenArtifactSearchDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "searchForClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "searchForArtifact";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

