/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.AdditionalMavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettingsForm;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenImportingConfigurable
implements SearchableConfigurable {
    private final MavenImportingSettings myImportingSettings;
    private final MavenImportingSettingsForm mySettingsForm;
    private final List<UnnamedConfigurable> myAdditionalConfigurables;
    private final Project myProject;

    public MavenImportingConfigurable(@NotNull Project project) {
        if (project == null) {
            MavenImportingConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myImportingSettings = MavenProjectsManager.getInstance(project).getImportingSettings();
        this.myAdditionalConfigurables = new ArrayList<UnnamedConfigurable>();
        for (AdditionalMavenImportingSettings additionalSettings : (AdditionalMavenImportingSettings[])AdditionalMavenImportingSettings.EP_NAME.getExtensions()) {
            this.myAdditionalConfigurables.add(additionalSettings.createConfigurable(project));
        }
        this.mySettingsForm = new MavenImportingSettingsForm(this.myProject);
    }

    public JComponent createComponent() {
        JPanel panel2 = this.mySettingsForm.getAdditionalSettingsPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(Box.createVerticalStrut(5));
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            panel2.add(Box.createVerticalStrut(3));
            panel2.add(additionalConfigurable.createComponent());
        }
        return this.mySettingsForm.createComponent();
    }

    public void disposeUIResources() {
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.disposeUIResources();
        }
    }

    public boolean isModified() {
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            if (!additionalConfigurable.isModified()) continue;
            return true;
        }
        return this.mySettingsForm.isModified(this.myImportingSettings, this.myProject);
    }

    public void apply() throws ConfigurationException {
        this.mySettingsForm.getData(this.myImportingSettings);
        ExternalProjectsManagerImpl.getInstance((Project)this.myProject).setStoreExternally(this.mySettingsForm.isStoreExternally());
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.apply();
        }
    }

    public void reset() {
        this.mySettingsForm.setData(this.myImportingSettings, this.myProject);
        for (UnnamedConfigurable additionalConfigurable : this.myAdditionalConfigurables) {
            additionalConfigurable.reset();
        }
    }

    @Nls
    public String getDisplayName() {
        return MavenProjectBundle.message("maven.tab.importing", new Object[0]);
    }

    @NotNull
    @NonNls
    public String getHelpTopic() {
        return "reference.settings.project.maven.importing";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            MavenImportingConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenImportingConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

