/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashMap;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.tasks.MavenKeymapExtension;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenShortcutsManager
implements Disposable {
    private final Project myProject;
    private static final String ACTION_ID_PREFIX = "Maven_";
    private final AtomicBoolean isInitialized;
    private final List<Listener> myListeners;

    @NotNull
    public static MavenShortcutsManager getInstance(Project project) {
        MavenShortcutsManager mavenShortcutsManager = (MavenShortcutsManager)project.getService(MavenShortcutsManager.class);
        if (mavenShortcutsManager == null) {
            MavenShortcutsManager.$$$reportNull$$$0(0);
        }
        return mavenShortcutsManager;
    }

    public MavenShortcutsManager(@NotNull Project project) {
        if (project == null) {
            MavenShortcutsManager.$$$reportNull$$$0(1);
        }
        this.isInitialized = new AtomicBoolean();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> this.doInit(project)));
    }

    @TestOnly
    public void doInit(@NotNull Project project) {
        if (project == null) {
            MavenShortcutsManager.$$$reportNull$$$0(2);
        }
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        MyProjectsTreeListener listener2 = new MyProjectsTreeListener();
        MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(project);
        mavenProjectManager.addManagerListener(listener2);
        mavenProjectManager.addProjectsTreeListener(listener2);
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                MavenShortcutsManager.this.fireShortcutsUpdated();
            }

            public void shortcutChanged(@NotNull Keymap keymap, @NotNull String actionId) {
                if (keymap == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actionId == null) {
                    1.$$$reportNull$$$0(1);
                }
                MavenShortcutsManager.this.fireShortcutsUpdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "keymap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actionId";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager$1";
                objectArray[2] = "shortcutChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        MavenKeymapExtension.clearActions(this.myProject);
    }

    @NotNull
    public String getActionId(@Nullable String projectPath, @Nullable String goal) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            result.append(new File(portablePath).getParentFile().getName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (goal != null) {
                result.append(goal);
            }
        }
        String string = result.toString();
        if (string == null) {
            MavenShortcutsManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getDescription(MavenProject project, String goal) {
        Shortcut[] shortcuts = this.getShortcuts(project, goal);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    boolean hasShortcuts(MavenProject project, String goal) {
        return this.getShortcuts(project, goal).length > 0;
    }

    private Shortcut @NotNull [] getShortcuts(MavenProject project, String goal) {
        String actionId = this.getActionId(project.getPath(), goal);
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
        if (shortcutArray == null) {
            MavenShortcutsManager.$$$reportNull$$$0(4);
        }
        return shortcutArray;
    }

    private void fireShortcutsUpdated() {
        for (Listener listener2 : this.myListeners) {
            listener2.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener2) {
        this.myListeners.add(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProjectsTreeListener
    implements MavenProjectsManager.Listener,
    MavenProjectsTree.Listener {
        private final Map<MavenProject, Boolean> mySheduledProjects = new THashMap();
        private final MergingUpdateQueue myUpdateQueue = new MavenMergingUpdateQueue("MavenShortcutsManager: Keymap Update", 500, true, MavenShortcutsManager.this).usePassThroughInUnitTestMode();

        private MyProjectsTreeListener() {
        }

        @Override
        public void activated() {
            this.scheduleKeymapUpdate(MavenProjectsManager.getInstance(MavenShortcutsManager.this.myProject).getNonIgnoredProjects(), true);
        }

        @Override
        public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            if (ignored == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(0);
            }
            if (unignored == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(1);
            }
            this.scheduleKeymapUpdate(unignored, true);
            this.scheduleKeymapUpdate(ignored, false);
        }

        @Override
        public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            if (updated == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(2);
            }
            if (deleted == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(3);
            }
            this.scheduleKeymapUpdate(MavenUtil.collectFirsts(updated), true);
            this.scheduleKeymapUpdate(deleted, false);
        }

        @Override
        public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
            if (projectWithChanges == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(4);
            }
            this.scheduleKeymapUpdate(Collections.singletonList((MavenProject)projectWithChanges.first), true);
        }

        @Override
        public void pluginsResolved(@NotNull MavenProject project) {
            if (project == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(5);
            }
            this.scheduleKeymapUpdate(Collections.singletonList(project), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleKeymapUpdate(List<? extends MavenProject> mavenProjects, boolean forUpdate) {
            Map<MavenProject, Boolean> map = this.mySheduledProjects;
            synchronized (map) {
                for (MavenProject mavenProject : mavenProjects) {
                    this.mySheduledProjects.put(mavenProject, forUpdate);
                }
            }
            this.myUpdateQueue.queue(new Update(MavenShortcutsManager.this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List<MavenProject> projectToDelete;
                    List<MavenProject> projectToUpdate;
                    Map<MavenProject, Boolean> map = MyProjectsTreeListener.this.mySheduledProjects;
                    synchronized (map) {
                        projectToUpdate = MyProjectsTreeListener.this.selectScheduledProjects(true);
                        projectToDelete = MyProjectsTreeListener.this.selectScheduledProjects(false);
                        MyProjectsTreeListener.this.mySheduledProjects.clear();
                    }
                    if (!MavenShortcutsManager.this.myProject.isDisposed()) {
                        MavenKeymapExtension.clearActions(MavenShortcutsManager.this.myProject, projectToDelete);
                        MavenKeymapExtension.updateActions(MavenShortcutsManager.this.myProject, projectToUpdate);
                    }
                }
            });
        }

        private List<MavenProject> selectScheduledProjects(boolean forUpdate) {
            return ContainerUtil.mapNotNull(this.mySheduledProjects.entrySet(), eachEntry -> forUpdate == (Boolean)eachEntry.getValue() ? (MavenProject)eachEntry.getKey() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unignored";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updated";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleted";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectWithChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager$MyProjectsTreeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsIgnoredStateChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsUpdated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectResolved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginsResolved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void shortcutsUpdated();
    }
}

