/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp.debugger;

import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.DefaultConsoleFiltersProvider;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.konan.KonanLog;
import com.jetbrains.konan.debugger.KonanLocalDebugProcess;
import com.jetbrains.mpp.runconfig.AttachmentStrategy;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\r\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u001c\u0010\u001a\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J\u001c\u0010\u001d\u001a\u00060\u000eR\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/mpp/debugger/KonanRemoteDebugProcess;", "Lcom/jetbrains/konan/debugger/KonanLocalDebugProcess;", "parameters", "Lcom/jetbrains/cidr/execution/RunParameters;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "consoleBuilder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "executableFile", "Ljava/io/File;", "attachmentStrategy", "Lcom/jetbrains/mpp/runconfig/AttachmentStrategy;", "(Lcom/jetbrains/cidr/execution/RunParameters;Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/execution/filters/TextConsoleBuilder;Ljava/io/File;Lcom/jetbrains/mpp/runconfig/AttachmentStrategy;)V", "doLoadTarget", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Inferior;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "driver", "ensureProcessReady", "", "isReady", "Lkotlin/Function0;", "", "executeCommand", "", "", "command", "loadTargetByName", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "name", "loadTargetByPort", "port", "", "kotlin-ultimate.common-noncidr-native"})
public final class KonanRemoteDebugProcess
extends KonanLocalDebugProcess {
    private final File executableFile;
    private final AttachmentStrategy attachmentStrategy;

    private final List<String> executeCommand(String command) {
        boolean bl = false;
        List result = new ArrayList();
        try {
            Process p;
            Process process = p = Runtime.getRuntime().exec(command);
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"p");
            BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            input.lines().forEach(new Consumer<String>(result){
                final /* synthetic */ List $result;

                public final void accept(String line) {
                    String string = line;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"line");
                    CharSequence charSequence = string;
                    boolean bl = false;
                    if (charSequence.length() > 0) {
                        this.$result.add(line);
                    }
                }
                {
                    this.$result = list;
                }
            });
            input.close();
        }
        catch (Exception e) {
            KonanLog.INSTANCE.getLOG().warn('\'' + command + "' failed");
        }
        return result;
    }

    private final void ensureProcessReady(Function0<Boolean> isReady) {
        Iterator iterator = CollectionsKt.listOf((Object[])new Long[]{1000L, 2000L, 4000L}).iterator();
        while (iterator.hasNext()) {
            long timing = ((Number)iterator.next()).longValue();
            if (((Boolean)isReady.invoke()).booleanValue()) break;
            Thread.sleep(timing);
        }
    }

    private final DebuggerDriver.Inferior loadTargetByName(LLDBDriver driver, String name) {
        String string = name;
        int n = StringsKt.lastIndexOf$default((CharSequence)name, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String shortName = string3;
        this.ensureProcessReady((Function0<Boolean>)((Function0)new Function0<Boolean>(this, shortName){
            final /* synthetic */ KonanRemoteDebugProcess this$0;
            final /* synthetic */ String $shortName;

            public final boolean invoke() {
                Collection collection = KonanRemoteDebugProcess.access$executeCommand(this.this$0, "pgrep " + this.$shortName);
                boolean bl = false;
                return !collection.isEmpty();
            }
            {
                this.this$0 = konanRemoteDebugProcess;
                this.$shortName = string;
                super(0);
            }
        }));
        DebuggerDriver.Inferior inferior = driver.loadForAttach(name, false);
        Intrinsics.checkNotNullExpressionValue((Object)inferior, (String)"driver.loadForAttach(name, false)");
        return inferior;
    }

    private final DebuggerDriver.Inferior loadTargetByPort(LLDBDriver driver, int port) {
        String url = "connect://127.0.0.1:" + port;
        this.ensureProcessReady((Function0<Boolean>)((Function0)new Function0<Boolean>(this, port){
            final /* synthetic */ KonanRemoteDebugProcess this$0;
            final /* synthetic */ int $port;

            public final boolean invoke() {
                Object v0;
                block1: {
                    Iterable iterable = KonanRemoteDebugProcess.access$executeCommand(this.this$0, "netstat -an");
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        String it = (String)t;
                        boolean bl3 = false;
                        if (!(StringsKt.contains$default((CharSequence)it, (CharSequence)"LISTEN", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)it, (CharSequence)String.valueOf(this.$port), (boolean)false, (int)2, null))) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0 != null;
            }
            {
                this.this$0 = konanRemoteDebugProcess;
                this.$port = n;
                super(0);
            }
        }));
        DebuggerDriver.Inferior inferior = driver.loadForAttachDebugServer(url, this.executableFile, null, CollectionsKt.emptyList(), null);
        Intrinsics.checkNotNullExpressionValue((Object)inferior, (String)"driver.loadForAttachDebu\u2026 null, emptyList(), null)");
        return inferior;
    }

    @NotNull
    protected DebuggerDriver.Inferior doLoadTarget(@NotNull DebuggerDriver driver) {
        DebuggerDriver.Inferior inferior;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        AttachmentStrategy attachmentStrategy = this.attachmentStrategy;
        if (attachmentStrategy instanceof AttachmentStrategy.ByName) {
            LLDBDriver lLDBDriver = (LLDBDriver)driver;
            String string = this.executableFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executableFile.absolutePath");
            inferior = this.loadTargetByName(lLDBDriver, string);
        } else if (attachmentStrategy instanceof AttachmentStrategy.ByPort) {
            inferior = this.loadTargetByPort((LLDBDriver)driver, ((AttachmentStrategy.ByPort)this.attachmentStrategy).getPort());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return inferior;
    }

    public KonanRemoteDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull File executableFile, @NotNull AttachmentStrategy attachmentStrategy) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)consoleBuilder, (String)"consoleBuilder");
        Intrinsics.checkNotNullParameter((Object)executableFile, (String)"executableFile");
        Intrinsics.checkNotNullParameter((Object)attachmentStrategy, (String)"attachmentStrategy");
        super(parameters, session, consoleBuilder, (ConsoleFilterProvider)new DefaultConsoleFiltersProvider());
        this.executableFile = executableFile;
        this.attachmentStrategy = attachmentStrategy;
    }

    public static final /* synthetic */ List access$executeCommand(KonanRemoteDebugProcess $this, String command) {
        return $this.executeCommand(command);
    }
}

