/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TableToolbarDecorator
extends ToolbarDecorator {
    private final JTable myTable;
    @Nullable
    private final ElementProducer<?> myProducer;

    TableToolbarDecorator(@NotNull JTable table, @Nullable ElementProducer<?> producer) {
        if (table == null) {
            TableToolbarDecorator.$$$reportNull$$$0(0);
        }
        this.myTable = table;
        this.myProducer = producer;
        this.myUpActionEnabled = this.myDownActionEnabled = this.isModelEditable();
        this.myRemoveActionEnabled = this.myDownActionEnabled;
        this.myAddActionEnabled = this.myDownActionEnabled;
        if (this.isModelEditable()) {
            this.createDefaultTableActions(producer);
        }
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableToolbarDecorator.this.updateButtons();
            }
        });
        this.myTable.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableToolbarDecorator.this.updateButtons();
            }
        });
    }

    @Override
    @NotNull
    public ToolbarDecorator initPosition() {
        this.setToolbarPosition(ActionToolbarPosition.BOTTOM);
        TableToolbarDecorator tableToolbarDecorator = this;
        if (tableToolbarDecorator == null) {
            TableToolbarDecorator.$$$reportNull$$$0(1);
        }
        return tableToolbarDecorator;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JTable jTable = this.myTable;
        if (jTable == null) {
            TableToolbarDecorator.$$$reportNull$$$0(2);
        }
        return jTable;
    }

    @Override
    protected void updateButtons() {
        CommonActionsPanel p = this.getActionsPanel();
        if (p != null) {
            boolean someElementSelected;
            if (this.myTable.isEnabled()) {
                int index = this.myTable.getSelectedRow();
                int size = this.myTable.getModel().getRowCount();
                boolean bl = someElementSelected = 0 <= index && index < size;
                if (someElementSelected) {
                    boolean downEnable = this.myTable.getSelectionModel().getMaxSelectionIndex() < size - 1;
                    boolean upEnable = this.myTable.getSelectionModel().getMinSelectionIndex() > 0;
                    boolean editEnabled = this.myTable.getSelectedRowCount() == 1;
                    p.setEnabled(CommonActionsPanel.Buttons.EDIT, editEnabled);
                    p.setEnabled(CommonActionsPanel.Buttons.UP, upEnable);
                    p.setEnabled(CommonActionsPanel.Buttons.DOWN, downEnable);
                } else {
                    p.setEnabled(CommonActionsPanel.Buttons.EDIT, false);
                    p.setEnabled(CommonActionsPanel.Buttons.UP, false);
                    p.setEnabled(CommonActionsPanel.Buttons.DOWN, false);
                }
                p.setEnabled(CommonActionsPanel.Buttons.ADD, this.myProducer == null || this.myProducer.canCreateElement());
            } else {
                someElementSelected = false;
                p.setEnabled(CommonActionsPanel.Buttons.ADD, false);
                p.setEnabled(CommonActionsPanel.Buttons.EDIT, false);
                p.setEnabled(CommonActionsPanel.Buttons.UP, false);
                p.setEnabled(CommonActionsPanel.Buttons.DOWN, false);
            }
            p.setEnabled(CommonActionsPanel.Buttons.REMOVE, someElementSelected);
            this.updateExtraElementActions(someElementSelected);
        }
    }

    private void createDefaultTableActions(final @Nullable ElementProducer<?> producer) {
        final JTable table = this.myTable;
        final EditableModel tableModel = (EditableModel)table.getModel();
        this.myAddAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.stopEditing((JTable)table);
                int rowCount = table.getRowCount();
                if (tableModel instanceof ListTableModel && producer != null) {
                    ((ListTableModel)tableModel).addRow(producer.createElement());
                } else {
                    tableModel.addRow();
                }
                if (rowCount == table.getRowCount()) {
                    return;
                }
                int index = table.getModel().getRowCount() - 1;
                table.setRowSelectionInterval(index, index);
                table.setColumnSelectionInterval(0, 0);
                table.editCellAt(index, 0);
                TableUtil.updateScroller((JTable)table);
                SwingUtilities.invokeLater(() -> {
                    Component editorComponent = table.getEditorComponent();
                    if (editorComponent != null) {
                        Rectangle bounds = editorComponent.getBounds();
                        table.scrollRectToVisible(bounds);
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(editorComponent, true));
                    }
                });
            }
        };
        this.myRemoveAction = new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (TableUtil.doRemoveSelectedItems((JTable)table, (ItemRemovable)tableModel, null)) {
                    TableToolbarDecorator.this.updateButtons();
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(table, true));
                    TableUtil.updateScroller((JTable)table);
                }
            }
        };
        class MoveRunnable
        implements AnActionButtonRunnable {
            final int delta;

            MoveRunnable(int delta) {
                this.delta = delta;
            }

            public void run(AnActionButton button) {
                int newEditingRow;
                int row = table.getEditingRow();
                int col = table.getEditingColumn();
                int rowCount = table.getModel().getRowCount();
                TableUtil.stopEditing((JTable)table);
                int[] idx = table.getSelectedRows();
                Arrays.sort(idx);
                if (this.delta > 0) {
                    idx = ArrayUtil.reverseArray((int[])idx);
                }
                if (idx.length == 0) {
                    return;
                }
                if (idx[0] + this.delta < 0) {
                    return;
                }
                if (idx[idx.length - 1] + this.delta > rowCount) {
                    return;
                }
                int i = 0;
                while (i < idx.length) {
                    tableModel.exchangeRows(idx[i], idx[i] + this.delta);
                    int n = i++;
                    idx[n] = idx[n] + this.delta;
                }
                TableUtil.selectRows((JTable)table, (int[])idx);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(table, true));
                if (row != -1 && col != -1 && (newEditingRow = row + this.delta) != -1 && newEditingRow < rowCount) {
                    table.editCellAt(newEditingRow, col);
                }
            }
        }
        this.myUpAction = new MoveRunnable(-1);
        this.myDownAction = new MoveRunnable(1);
    }

    @Override
    protected void installDnDSupport() {
        RowsDnDSupport.install(this.myTable, (EditableModel)this.myTable.getModel());
    }

    @Override
    protected boolean isModelEditable() {
        return this.myTable.getModel() instanceof EditableModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/TableToolbarDecorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/TableToolbarDecorator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initPosition";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

