/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.usages.NamedPresentably;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileGroupingRule
extends SingleParentUsageGroupingRule
implements DumbAware,
UsageGroupingRuleEx {
    private final Project myProject;

    public FileGroupingRule(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public UsageGroup getParentGroupFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        VirtualFile virtualFile2;
        if (usage == null) {
            FileGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            FileGroupingRule.$$$reportNull$$$0(1);
        }
        if (usage instanceof UsageInFile && (virtualFile2 = ((UsageInFile)usage).getFile()) != null) {
            return new FileUsageGroup(this.myProject, virtualFile2);
        }
        return null;
    }

    @Override
    @Nullable
    public String getGroupingActionId() {
        return "UsageGrouping.FileStructure";
    }

    @Override
    public boolean isGroupingActionInverted() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/usages/impl/rules/FileGroupingRule";
        objectArray[2] = "getParentGroupFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider,
    NamedPresentably {
        private final Project myProject;
        private final VirtualFile myFile;
        @NlsSafe
        private String myPresentableName;
        private Icon myIcon;

        public FileUsageGroup(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                FileUsageGroup.$$$reportNull$$$0(0);
            }
            if (file == null) {
                FileUsageGroup.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFile = file instanceof VirtualFileWindow ? ((VirtualFileWindow)((Object)file)).getDelegate() : file;
            this.myPresentableName = this.myFile.getName();
            this.update();
        }

        private Icon getIconImpl() {
            return IconUtil.getIcon((VirtualFile)this.myFile, (int)2, (Project)this.myProject);
        }

        @Override
        public void update() {
            if (this.isValid()) {
                this.myIcon = this.getIconImpl();
                this.myPresentableName = this.myFile.getName();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileUsageGroup)) {
                return false;
            }
            FileUsageGroup fileUsageGroup = (FileUsageGroup)o;
            return this.myFile.equals(fileUsageGroup.myFile);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myPresentableName;
            if (string == null) {
                FileUsageGroup.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return !this.myProject.isDisposed() && this.isValid() ? FileStatusManager.getInstance(this.myProject).getStatus(this.myFile) : null;
        }

        @Override
        public boolean isValid() {
            return this.myFile.isValid();
        }

        @Override
        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (!this.myProject.isDisposed()) {
                FileEditorManager.getInstance(this.myProject).openFile(this.myFile, focus);
            }
        }

        @Override
        public boolean canNavigate() {
            return this.myFile.isValid();
        }

        @Override
        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        @Override
        public int compareTo(@NotNull UsageGroup otherGroup) {
            int compareTexts;
            if (otherGroup == null) {
                FileUsageGroup.$$$reportNull$$$0(3);
            }
            if ((compareTexts = this.getText(null).compareToIgnoreCase(otherGroup.getText(null))) != 0) {
                return compareTexts;
            }
            if (otherGroup instanceof FileUsageGroup) {
                return this.myFile.getPath().compareTo(((FileUsageGroup)otherGroup).myFile.getPath());
            }
            return 0;
        }

        @Override
        public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
            if (key == null) {
                FileUsageGroup.$$$reportNull$$$0(4);
            }
            if (sink == null) {
                FileUsageGroup.$$$reportNull$$$0(5);
            }
            if (!this.isValid()) {
                return;
            }
            if (key == CommonDataKeys.VIRTUAL_FILE) {
                sink.put(CommonDataKeys.VIRTUAL_FILE, this.myFile);
            }
            if (key == CommonDataKeys.PSI_ELEMENT) {
                sink.put(CommonDataKeys.PSI_ELEMENT, this.getPsiFile());
            }
        }

        @Nullable
        public PsiFile getPsiFile() {
            return this.myFile.isValid() ? PsiManager.getInstance(this.myProject).findFile(this.myFile) : null;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            String string = this.myPresentableName;
            if (string == null) {
                FileUsageGroup.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/FileGroupingRule$FileUsageGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherGroup";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/FileGroupingRule$FileUsageGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "calcData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

