/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.OutputFileObject;
import org.jetbrains.org.objectweb.asm.ClassReader;

final class OutputFilesSink
implements OutputFileConsumer {
    private static final Logger LOG = Logger.getInstance(OutputFilesSink.class);
    private final CompileContext myContext;
    private final ModuleLevelBuilder.OutputConsumer myOutputConsumer;
    private final Callbacks.Backend myMappingsCallback;
    private final String myChunkName;
    private final Set<File> mySuccessfullyCompiled = FileCollectionFactory.createCanonicalFileSet();

    OutputFilesSink(CompileContext context, ModuleLevelBuilder.OutputConsumer outputConsumer, Callbacks.Backend callback, String chunkName) {
        this.myContext = context;
        this.myOutputConsumer = outputConsumer;
        this.myMappingsCallback = callback;
        this.myChunkName = "[" + chunkName + "]";
    }

    public void save(@NotNull OutputFileObject fileObject) {
        if (fileObject == null) {
            OutputFilesSink.$$$reportNull$$$0(0);
        }
        BinaryContent content = fileObject.getContent();
        boolean isTemp = false;
        JavaFileObject.Kind outKind = fileObject.getKind();
        List sourceFiles = ContainerUtil.collect(fileObject.getSourceFiles().iterator());
        if (!sourceFiles.isEmpty() && content != null) {
            List sourcePaths = ContainerUtil.map((Collection)sourceFiles, f -> FileUtil.toSystemIndependentName((String)f.getPath()));
            JavaSourceRootDescriptor rootDescriptor = null;
            for (File srcFile : sourceFiles) {
                rootDescriptor = this.myContext.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(this.myContext, srcFile);
                if (rootDescriptor == null) continue;
                break;
            }
            try {
                if (rootDescriptor != null) {
                    isTemp = rootDescriptor.isTemp;
                    if (!isTemp) {
                        if (outKind == JavaFileObject.Kind.CLASS) {
                            this.myOutputConsumer.registerCompiledClass(rootDescriptor.target, new CompiledClass(fileObject.getFile(), sourceFiles, fileObject.getClassName(), content));
                        } else {
                            this.myOutputConsumer.registerOutputFile(rootDescriptor.target, fileObject.getFile(), sourcePaths);
                        }
                    }
                } else if (outKind == JavaFileObject.Kind.CLASS) {
                    this.myOutputConsumer.registerCompiledClass(null, new CompiledClass(fileObject.getFile(), sourceFiles, fileObject.getClassName(), content));
                }
            }
            catch (IOException e) {
                this.myContext.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), e));
            }
            if (!isTemp && outKind == JavaFileObject.Kind.CLASS) {
                try {
                    FailSafeClassReader reader = new FailSafeClassReader(content.getBuffer(), content.getOffset(), content.getLength());
                    this.myMappingsCallback.associate(FileUtil.toSystemIndependentName((String)fileObject.getFile().getPath()), sourcePaths, (ClassReader)reader, fileObject.isGenerated());
                }
                catch (Throwable e) {
                    String message = JpsBuildBundle.message("build.message.class.dependency.information.may.be.incomplete", fileObject.getFile().getPath());
                    LOG.info(message, e);
                    for (String sourcePath : sourcePaths) {
                        this.myContext.processMessage(new CompilerMessage(JavaBuilder.getBuilderName(), BuildMessage.Kind.WARNING, message + "\n" + CompilerMessage.getTextFromThrowable(e), sourcePath));
                    }
                }
            }
        }
        if (outKind == JavaFileObject.Kind.CLASS) {
            this.myContext.processMessage(new ProgressMessage(JpsBuildBundle.message("progress.message.writing.classes.0", this.myChunkName)));
            if (!isTemp && !sourceFiles.isEmpty()) {
                this.mySuccessfullyCompiled.addAll(sourceFiles);
            }
        }
    }

    public Set<File> getSuccessfullyCompiled() {
        return Collections.unmodifiableSet(this.mySuccessfullyCompiled);
    }

    public void markError(@NotNull File sourceFile) {
        if (sourceFile == null) {
            OutputFilesSink.$$$reportNull$$$0(1);
        }
        this.mySuccessfullyCompiled.remove(sourceFile);
    }

    public void markError(@NotNull Set<File> problematic) {
        if (problematic == null) {
            OutputFilesSink.$$$reportNull$$$0(2);
        }
        this.mySuccessfullyCompiled.removeAll(problematic);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problematic";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/java/OutputFilesSink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

