/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberValueConverter<T extends Number>
extends ResolvingConverter<T> {
    private final Class myNumberClass;
    private final boolean myAllowEmpty;

    public NumberValueConverter(@NotNull Class<T> numberClass, boolean allowEmpty) {
        if (numberClass == null) {
            NumberValueConverter.$$$reportNull$$$0(0);
        }
        this.myNumberClass = numberClass;
        this.myAllowEmpty = allowEmpty;
    }

    @Override
    public T fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (this.myAllowEmpty && s.trim().length() == 0) {
            return null;
        }
        return (T)NumberValueConverter.parseNumber(s, this.myNumberClass);
    }

    @Override
    public String toString(@Nullable T value, ConvertContext context) {
        return value == null ? null : NumberValueConverter.parseText(value, this.myNumberClass);
    }

    @Override
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        boolean isEmpty;
        if (s == null) {
            return super.getErrorMessage(null, context);
        }
        boolean bl = isEmpty = s.trim().length() == 0;
        if (isEmpty && this.myAllowEmpty) {
            return null;
        }
        return isEmpty ? XmlDomBundle.message("dom.converter.format.exception.empty.string", this.myNumberClass.getName()) : XmlDomBundle.message("dom.converter.format.exception", s, this.myNumberClass.getName());
    }

    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        Set set = Collections.emptySet();
        if (set == null) {
            NumberValueConverter.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public static String parseText(@NotNull Number value, @NotNull Class targetClass) {
        if (value == null) {
            NumberValueConverter.$$$reportNull$$$0(2);
        }
        if (targetClass == null) {
            NumberValueConverter.$$$reportNull$$$0(3);
        }
        if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
            return Byte.toString((Byte)value);
        }
        if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
            return Short.toString((Short)value);
        }
        if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
            return Integer.toString((Integer)value);
        }
        if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
            return Long.toString((Long)value);
        }
        if (targetClass.equals(BigInteger.class)) {
            return value.toString();
        }
        if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
            return Float.toString(((Float)value).floatValue());
        }
        if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
            return Double.toString((Double)value);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return ((BigDecimal)value).toPlainString();
        }
        return null;
    }

    @Nullable
    public static Number parseNumber(@NotNull String text, @NotNull Class targetClass) {
        if (text == null) {
            NumberValueConverter.$$$reportNull$$$0(4);
        }
        if (targetClass == null) {
            NumberValueConverter.$$$reportNull$$$0(5);
        }
        try {
            String trimmed = text.trim();
            if (targetClass.equals(Byte.class) || targetClass.equals(Byte.TYPE)) {
                return Byte.decode(trimmed);
            }
            if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
                return Short.decode(trimmed);
            }
            if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
                return Integer.decode(trimmed);
            }
            if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
                return Long.decode(trimmed);
            }
            if (targetClass.equals(BigInteger.class)) {
                return NumberValueConverter.decodeBigInteger(trimmed);
            }
            if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
                return Float.valueOf(trimmed);
            }
            if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
                return Double.valueOf(trimmed);
            }
            if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
                return new BigDecimal(trimmed);
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return null;
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numberClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/converters/values/NumberValueConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/converters/values/NumberValueConverter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseNumber";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

