/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionProfileActionProvider;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.InspectionProfileUtil;
import com.intellij.structuralsearch.inspection.SSBasedInspection;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.FormBuilder;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchProfileActionProvider
extends InspectionProfileActionProvider {
    @NotNull
    public List<AnAction> getActions(@NotNull SingleInspectionProfilePanel panel) {
        InspectionProfileModifiableModel profile;
        if (panel == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(0);
        }
        if ((profile = panel.getProfile()).getToolsOrNull("SSBasedInspection", null) != null && !profile.isToolEnabled(HighlightDisplayKey.find((String)"SSBasedInspection"))) {
            profile.setToolEnabled("SSBasedInspection", true);
            for (ScopeToolState tool : profile.getAllTools()) {
                InspectionToolWrapper wrapper = tool.getTool();
                if (!(wrapper instanceof StructuralSearchInspectionToolWrapper)) continue;
                tool.setEnabled(false);
            }
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{new AddInspectionAction(panel, false), new AddInspectionAction(panel, true)});
        actionGroup.setPopup(true);
        actionGroup.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)panel);
        Presentation presentation = actionGroup.getTemplatePresentation();
        presentation.setIcon(AllIcons.General.Add);
        presentation.setText(SSRBundle.messagePointer("add.inspection.button", new Object[0]));
        List<AnAction> list = Arrays.asList(new AnAction[]{actionGroup, new RemoveInspectionAction(panel)});
        if (list == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static void createNewInspection(@NotNull Configuration configuration, @NotNull Project project) {
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(3);
        }
        StructuralSearchProfileActionProvider.createNewInspection(configuration, project, InspectionProfileManager.getInstance((Project)project).getCurrentProfile());
    }

    private static boolean createNewInspection(@NotNull Configuration configuration, @NotNull Project project, @NotNull InspectionProfileImpl profile) {
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(5);
        }
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(6);
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            configuration.setOrder(0);
            configuration.setName(SSRBundle.message("new.template.defaultname", new Object[0]));
            configuration.setDescription("");
            configuration.setProblemDescriptor("");
            configuration.setSuppressId("");
            InspectionDataDialog dialog = new InspectionDataDialog(project, inspection, configuration, true);
            if (!dialog.showAndGet()) {
                return false;
            }
        }
        configuration.setUuid(null);
        inspection.addConfiguration(configuration);
        StructuralSearchProfileActionProvider.addInspectionToProfile(project, profile, configuration);
        if (profile instanceof InspectionProfileModifiableModel) {
            ((InspectionProfileModifiableModel)profile).setModified(true);
        }
        InspectionProfileUtil.fireProfileChanged(profile);
        profile.getProfileManager().fireProfileChanged(profile);
        return true;
    }

    private static void addInspectionToProfile(@NotNull Project project, @NotNull InspectionProfileImpl profile, @NotNull Configuration configuration) {
        String shortName;
        InspectionToolWrapper toolWrapper;
        if (project == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(7);
        }
        if (profile == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            StructuralSearchProfileActionProvider.$$$reportNull$$$0(9);
        }
        if ((toolWrapper = profile.getInspectionTool(shortName = configuration.getUuid().toString(), project)) != null) {
            return;
        }
        StructuralSearchInspectionToolWrapper wrapped = new StructuralSearchInspectionToolWrapper(Collections.singletonList(configuration));
        profile.addTool(project, (InspectionToolWrapper)wrapped, null);
        profile.setToolEnabled(shortName, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addInspectionToProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class InspectionDataDialog
    extends DialogWrapper {
        private final Pattern mySuppressIdPattern;
        private final SSBasedInspection myInspection;
        @NotNull
        private final Configuration myConfiguration;
        private final boolean myNewInspection;
        private final JTextField myNameTextField;
        private final JTextField myProblemDescriptorTextField;
        private final EditorTextField myDescriptionTextArea;
        private final JTextField mySuppressIdTextField;

        InspectionDataDialog(Project project, @NotNull SSBasedInspection inspection, @NotNull Configuration configuration, boolean newInspection) {
            if (inspection == null) {
                InspectionDataDialog.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                InspectionDataDialog.$$$reportNull$$$0(1);
            }
            super(null);
            this.mySuppressIdPattern = Pattern.compile("[a-zA-Z_0-9.-]+");
            this.myInspection = inspection;
            this.myConfiguration = configuration;
            this.myNewInspection = newInspection;
            assert (this.myConfiguration.getOrder() == 0);
            this.myNameTextField = new JTextField(configuration.getName());
            this.myProblemDescriptorTextField = new JTextField(configuration.getProblemDescriptor());
            this.myDescriptionTextArea = new EditorTextField((String)ObjectUtils.notNull((Object)configuration.getDescription(), (Object)""), project, (FileType)HtmlFileType.INSTANCE);
            this.myDescriptionTextArea.setOneLineMode(false);
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.myDescriptionTextArea.setFont(scheme.getFont(EditorFontType.PLAIN));
            this.myDescriptionTextArea.setPreferredSize(new Dimension(375, 125));
            this.myDescriptionTextArea.setMinimumSize(new Dimension(200, 50));
            this.mySuppressIdTextField = new JTextField(configuration.getSuppressId());
            this.setTitle(SSRBundle.message("meta.data.dialog.title", new Object[0]));
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myNameTextField;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            SmartList warnings = new SmartList();
            List<Configuration> configurations = this.myInspection.getConfigurations();
            String name = this.getName();
            if (StringUtil.isEmpty((String)name)) {
                warnings.add(new ValidationInfo(SSRBundle.message("name.must.not.be.empty.warning", new Object[0]), (JComponent)this.myNameTextField));
            } else {
                for (Configuration configuration : configurations) {
                    if (configuration.getOrder() != 0) continue;
                    if (this.myNewInspection) {
                        if (!configuration.getName().equals(name)) continue;
                        warnings.add(new ValidationInfo(SSRBundle.message("inspection.with.name.exists.warning", name), (JComponent)this.myNameTextField));
                        break;
                    }
                    if (configuration.getUuid().equals(this.myConfiguration.getUuid()) || !configuration.getName().equals(name)) continue;
                    warnings.add(new ValidationInfo(SSRBundle.message("inspection.with.name.exists.warning", name), (JComponent)this.myNameTextField));
                    break;
                }
            }
            String suppressId = this.getSuppressId();
            if (!StringUtil.isEmpty((String)suppressId)) {
                if (!this.mySuppressIdPattern.matcher(suppressId).matches()) {
                    warnings.add(new ValidationInfo(SSRBundle.message("suppress.id.must.match.regex.warning", new Object[0]), (JComponent)this.mySuppressIdTextField));
                } else {
                    HighlightDisplayKey key = HighlightDisplayKey.findById((String)suppressId);
                    if (key != null && key != HighlightDisplayKey.find((String)this.myConfiguration.getUuid().toString())) {
                        warnings.add(new ValidationInfo(SSRBundle.message("suppress.id.in.use.warning", suppressId), (JComponent)this.mySuppressIdTextField));
                    } else {
                        for (Configuration configuration : configurations) {
                            if (!suppressId.equals(configuration.getSuppressId()) || this.myConfiguration.getUuid().equals(configuration.getUuid())) continue;
                            warnings.add(new ValidationInfo(SSRBundle.message("suppress.id.in.use.warning", suppressId), (JComponent)this.mySuppressIdTextField));
                            break;
                        }
                    }
                }
            }
            SmartList smartList = warnings;
            if (smartList == null) {
                InspectionDataDialog.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        protected void doOKAction() {
            super.doOKAction();
            if (this.getOKAction().isEnabled()) {
                this.myConfiguration.setName(this.getName());
                this.myConfiguration.setDescription(this.getDescription());
                this.myConfiguration.setSuppressId(this.getSuppressId());
                this.myConfiguration.setProblemDescriptor(this.getProblemDescriptor());
            }
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new FormBuilder().addLabeledComponent(SSRBundle.message("inspection.name.label", new Object[0]), (JComponent)this.myNameTextField, true).addLabeledComponent(SSRBundle.message("problem.descriptor.label", new Object[0]), (JComponent)this.myProblemDescriptorTextField, true).addLabeledComponentFillVertically(SSRBundle.message("description.label", new Object[0]), (JComponent)this.myDescriptionTextArea).addLabeledComponent(SSRBundle.message("suppress.id.label", new Object[0]), (JComponent)this.mySuppressIdTextField).getPanel();
        }

        public String getName() {
            return this.myNameTextField.getText().trim();
        }

        @Nullable
        public String getDescription() {
            return InspectionDataDialog.convertEmptyToNull(this.myDescriptionTextArea.getText());
        }

        @Nullable
        public String getSuppressId() {
            return InspectionDataDialog.convertEmptyToNull(this.mySuppressIdTextField.getText());
        }

        @Nullable
        public String getProblemDescriptor() {
            return InspectionDataDialog.convertEmptyToNull(this.myProblemDescriptorTextField.getText());
        }

        private static String convertEmptyToNull(String s) {
            return StringUtil.isEmpty((String)s.trim()) ? null : s;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$InspectionDataDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$InspectionDataDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidateAll";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class AddInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;
        private final boolean myReplace;

        private AddInspectionAction(@NotNull SingleInspectionProfilePanel panel, boolean replace) {
            if (panel == null) {
                AddInspectionAction.$$$reportNull$$$0(0);
            }
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myPanel = panel;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SearchContext context;
            StructuralSearchDialog dialog;
            if (e == null) {
                AddInspectionAction.$$$reportNull$$$0(1);
            }
            if (!(dialog = new StructuralSearchDialog(context = new SearchContext(e.getDataContext()), this.myReplace, true)).showAndGet()) {
                return;
            }
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project != null);
            Configuration configuration = dialog.getConfiguration();
            if (!StructuralSearchProfileActionProvider.createNewInspection(configuration, project, (InspectionProfileImpl)profile)) {
                return;
            }
            this.myPanel.selectInspectionTool(configuration.getUuid().toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$AddInspectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RemoveInspectionAction
    extends DumbAwareAction {
        private final SingleInspectionProfilePanel myPanel;

        private RemoveInspectionAction(@NotNull SingleInspectionProfilePanel panel) {
            if (panel == null) {
                RemoveInspectionAction.$$$reportNull$$$0(0);
            }
            super(SSRBundle.message("remove.inspection.button", new Object[0]), null, AllIcons.General.Remove);
            this.myPanel = panel;
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)this.myPanel);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveInspectionAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myPanel.getSelectedTool() instanceof StructuralSearchInspectionToolWrapper);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveInspectionAction.$$$reportNull$$$0(2);
            }
            InspectionToolWrapper selectedTool = this.myPanel.getSelectedTool();
            String shortName = selectedTool.getShortName();
            this.myPanel.removeSelectedRow();
            InspectionProfileModifiableModel profile = this.myPanel.getProfile();
            SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection((InspectionProfile)profile);
            inspection.removeConfigurationsWithUuid(UUID.fromString(shortName));
            profile.removeTool(shortName);
            profile.setModified(true);
            InspectionProfileUtil.fireProfileChanged((InspectionProfileImpl)profile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchProfileActionProvider$RemoveInspectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

