/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchTemplateBuilder {
    private final TemplateBuilder myBuilder;
    private final PsiFile myPsiFile;
    private final PlaceholderCount myClassCount;
    private final PlaceholderCount myVarCount;
    private final PlaceholderCount myFunCount;
    private int myShift;

    public StructuralSearchTemplateBuilder(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            StructuralSearchTemplateBuilder.$$$reportNull$$$0(0);
        }
        this.myClassCount = new PlaceholderCount("Class");
        this.myVarCount = new PlaceholderCount("Var");
        this.myFunCount = new PlaceholderCount("Fun");
        this.myBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)psiFile);
        this.myPsiFile = psiFile;
    }

    public TemplateBuilder buildTemplate() {
        int textOffset;
        JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){

            public void visitIdentifier(PsiIdentifier identifier) {
                PsiElement parent = identifier.getParent();
                if (parent instanceof PsiClass) {
                    StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myClassCount, true);
                } else if (parent instanceof PsiReferenceExpression) {
                    if (parent.getParent() instanceof PsiMethodCallExpression) {
                        StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myFunCount, true);
                    } else {
                        StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myVarCount, false);
                    }
                } else if (parent instanceof PsiJavaCodeReferenceElement) {
                    StructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, StructuralSearchTemplateBuilder.this.myClassCount, false);
                }
            }

            public void visitReferenceList(PsiReferenceList list) {
                PsiJavaCodeReferenceElement[] elements;
                for (PsiJavaCodeReferenceElement element : elements = list.getReferenceElements()) {
                    StructuralSearchTemplateBuilder.this.replaceElement(element.getReferenceNameElement(), StructuralSearchTemplateBuilder.this.myClassCount, false);
                }
            }
        };
        MatchOptions matchOptions = new MatchOptions();
        String text = this.myPsiFile.getText();
        for (textOffset = 0; textOffset < text.length() && StringUtil.isWhiteSpace((char)text.charAt(textOffset)); ++textOffset) {
        }
        this.myShift -= textOffset;
        matchOptions.setSearchPattern(text);
        PsiElement[] elements = MatcherImplUtil.createTreeFromText(text, PatternTreeContext.Block, (LanguageFileType)this.myPsiFile.getFileType(), this.myPsiFile.getProject());
        if (elements.length > 0) {
            PsiElement element = elements[0];
            this.myShift += element.getTextRange().getStartOffset();
            element.accept((PsiElementVisitor)visitor);
        }
        return this.myBuilder;
    }

    void replaceElement(@Nullable PsiElement element, PlaceholderCount count, boolean preferOriginal) {
        if (element == null) {
            return;
        }
        String placeholder = count.getPlaceholder();
        String originalText = element.getText();
        Object[] elements = new LookupElement[]{LookupElementBuilder.create((String)placeholder), LookupElementBuilder.create((String)originalText)};
        this.myBuilder.replaceRange(element.getTextRange().shiftLeft(this.myShift), (Expression)new ConstantNode(preferOriginal ? originalText : placeholder).withLookupItems((LookupElement[])(preferOriginal ? (LookupElement[])ArrayUtil.reverseArray((Object[])elements) : elements)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/structuralsearch/plugin/ui/StructuralSearchTemplateBuilder", "<init>"));
    }

    private static final class PlaceholderCount {
        private final String myName;
        private int myCount;

        private PlaceholderCount(String name) {
            this.myName = name;
        }

        public String getPlaceholder() {
            return "$" + this.myName + ++this.myCount + "$";
        }
    }
}

