/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.FileAttributeProperty;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u000b\u001ah\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0019\b\u0004\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00020\t\u00a2\u0006\u0002\b\u000b2\u001f\b\u0004\u0010\f\u001a\u0019\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u000bH\u0086\b\u00f8\u0001\u0000\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014*\u00020\u0012\u001a4\u0010\u0015\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00122\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00020\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\u0017\u001a\u001e\u0010\u0018\u001a\u0002H\u0002\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u0019\u001a\n\u0010\u001a\u001a\u00020\u0005*\u00020\u0012\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u00020\u0012\u001a\u0012\u0010\u001c\u001a\u00020\u000f*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011\u001a\u0018\u0010\u001f\u001a\u00020\u000f*\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!\u001aB\u0010\"\u001a\u00020\u000f\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u0001H\u00022\u001d\u0010$\u001a\u0019\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010%\u001a&\u0010&\u001a\u00020\u000f\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\u000e2\u0006\u0010'\u001a\u0002H\u0002H\u0086\b\u00a2\u0006\u0002\u0010(\u001a\u0012\u0010)\u001a\u00020\u000f*\u00020\u001d2\u0006\u0010*\u001a\u00020\u0005\u001a\u0018\u0010+\u001a\u00020\u000f*\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006,"}, d2={"cachedFileAttribute", "Lorg/jetbrains/kotlin/idea/core/util/FileAttributeProperty;", "T", "", "name", "", "version", "", "read", "Lkotlin/Function1;", "Ljava/io/DataInputStream;", "Lkotlin/ExtensionFunctionType;", "write", "Lkotlin/Function2;", "Ljava/io/DataOutputStream;", "", "readFile", "Ljava/io/File;", "Ljava/io/DataInput;", "readFileList", "", "readNullable", "readT", "(Ljava/io/DataInput;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readObject", "(Ljava/io/DataInputStream;)Ljava/lang/Object;", "readString", "readStringList", "writeFile", "Ljava/io/DataOutput;", "it", "writeFileList", "iterable", "", "writeNullable", "nullable", "writeT", "(Ljava/io/DataOutput;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "writeObject", "obj", "(Ljava/io/DataOutputStream;Ljava/lang/Object;)V", "writeString", "string", "writeStringList", "kotlin.core"})
public final class FileAttributeUtilsKt {
    @NotNull
    public static final <T> FileAttributeProperty<T> cachedFileAttribute(@NotNull String name, int version, @NotNull Function1<? super DataInputStream, ? extends T> read, @NotNull Function2<? super DataOutputStream, ? super T, Unit> write) {
        int $i$f$cachedFileAttribute = 0;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(read, (String)"read");
        Intrinsics.checkNotNullParameter(write, (String)"write");
        return new FileAttributeProperty<T>(read, write, name, version, name, version){
            final /* synthetic */ Function1 $read;
            final /* synthetic */ Function2 $write;
            final /* synthetic */ String $name;
            final /* synthetic */ int $version;

            @NotNull
            public T readValue(@NotNull DataInputStream input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return (T)this.$read.invoke((Object)input);
            }

            public void writeValue(@NotNull DataOutputStream output, @NotNull T value) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                Intrinsics.checkNotNullParameter(value, (String)"value");
                this.$write.invoke((Object)output, value);
            }
            {
                this.$read = $captured_local_variable$0;
                this.$write = $captured_local_variable$1;
                this.$name = $captured_local_variable$2;
                this.$version = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, null, 4, null);
            }
        };
    }

    @NotNull
    public static final List<String> readStringList(@NotNull DataInput $this$readStringList) {
        Intrinsics.checkNotNullParameter((Object)$this$readStringList, (String)"$this$readStringList");
        List list = DataInputOutputUtilRt.readSeq((DataInput)$this$readStringList, (ThrowableComputable)((ThrowableComputable)new ThrowableComputable<String, IOException>($this$readStringList){
            final /* synthetic */ DataInput $this_readStringList;

            public final String compute() {
                return FileAttributeUtilsKt.readString(this.$this_readStringList);
            }
            {
                this.$this_readStringList = dataInput;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readSeq(this) { readString() }");
        return list;
    }

    @NotNull
    public static final List<File> readFileList(@NotNull DataInput $this$readFileList) {
        Intrinsics.checkNotNullParameter((Object)$this$readFileList, (String)"$this$readFileList");
        List list = DataInputOutputUtilRt.readSeq((DataInput)$this$readFileList, (ThrowableComputable)((ThrowableComputable)new ThrowableComputable<File, IOException>($this$readFileList){
            final /* synthetic */ DataInput $this_readFileList;

            public final File compute() {
                return FileAttributeUtilsKt.readFile(this.$this_readFileList);
            }
            {
                this.$this_readFileList = dataInput;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readSeq(this) { readFile() }");
        return list;
    }

    @NotNull
    public static final String readString(@NotNull DataInput $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"$this$readString");
        String string = IOUtil.readUTF((DataInput)$this$readString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(this)");
        return string;
    }

    @NotNull
    public static final File readFile(@NotNull DataInput $this$readFile) {
        Intrinsics.checkNotNullParameter((Object)$this$readFile, (String)"$this$readFile");
        return new File(IOUtil.readUTF((DataInput)$this$readFile));
    }

    public static final void writeFileList(@NotNull DataOutput $this$writeFileList, @NotNull Iterable<? extends File> iterable) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFileList, (String)"$this$writeFileList");
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        DataInputOutputUtilRt.writeSeq((DataOutput)$this$writeFileList, (Collection)CollectionsKt.toList(iterable), (ThrowableConsumer)((ThrowableConsumer)new ThrowableConsumer<File, IOException>($this$writeFileList){
            final /* synthetic */ DataOutput $this_writeFileList;

            public final void consume(File it) {
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                FileAttributeUtilsKt.writeFile(this.$this_writeFileList, file);
            }
            {
                this.$this_writeFileList = dataOutput;
            }
        }));
    }

    public static final void writeFile(@NotNull DataOutput $this$writeFile, @NotNull File it) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFile, (String)"$this$writeFile");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.canonicalPath");
        FileAttributeUtilsKt.writeString($this$writeFile, string);
    }

    public static final void writeString(@NotNull DataOutput $this$writeString, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"$this$writeString");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        IOUtil.writeUTF((DataOutput)$this$writeString, (String)string);
    }

    public static final void writeStringList(@NotNull DataOutput $this$writeStringList, @NotNull Iterable<String> iterable) {
        Intrinsics.checkNotNullParameter((Object)$this$writeStringList, (String)"$this$writeStringList");
        Intrinsics.checkNotNullParameter(iterable, (String)"iterable");
        DataInputOutputUtilRt.writeSeq((DataOutput)$this$writeStringList, (Collection)CollectionsKt.toList(iterable), (ThrowableConsumer)((ThrowableConsumer)new ThrowableConsumer<String, IOException>($this$writeStringList){
            final /* synthetic */ DataOutput $this_writeStringList;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                FileAttributeUtilsKt.writeString(this.$this_writeStringList, string);
            }
            {
                this.$this_writeStringList = dataOutput;
            }
        }));
    }

    public static final <T> void writeNullable(@NotNull DataOutput $this$writeNullable, @Nullable T nullable, @NotNull Function2<? super DataOutput, ? super T, Unit> writeT) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$writeNullable, (String)"$this$writeNullable");
            Intrinsics.checkNotNullParameter(writeT, (String)"writeT");
            $this$writeNullable.writeBoolean(nullable != null);
            T t = nullable;
            if (t == null) break block0;
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            writeT.invoke((Object)$this$writeNullable, it);
        }
    }

    @Nullable
    public static final <T> T readNullable(@NotNull DataInput $this$readNullable, @NotNull Function1<? super DataInput, ? extends T> readT) {
        Intrinsics.checkNotNullParameter((Object)$this$readNullable, (String)"$this$readNullable");
        Intrinsics.checkNotNullParameter(readT, (String)"readT");
        boolean hasValue = $this$readNullable.readBoolean();
        return (T)(hasValue ? readT.invoke((Object)$this$readNullable) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final /* synthetic */ <T> void writeObject(@NotNull DataOutputStream $this$writeObject, @NotNull T obj) {
        int $i$f$writeObject = 0;
        Intrinsics.checkNotNullParameter((Object)$this$writeObject, (String)"$this$writeObject");
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Closeable closeable = new ObjectOutputStream(os);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ObjectOutputStream oos = (ObjectOutputStream)closeable;
            boolean bl3 = false;
            oos.writeObject(obj);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        byte[] bytes = os.toByteArray();
        $this$writeObject.writeInt(bytes.length);
        $this$writeObject.write(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final /* synthetic */ <T> T readObject(@NotNull DataInputStream $this$readObject) {
        Object object;
        int $i$f$readObject = 0;
        Intrinsics.checkNotNullParameter((Object)$this$readObject, (String)"$this$readObject");
        int size = $this$readObject.readInt();
        byte[] bytes = new byte[size];
        $this$readObject.read(bytes, 0, size);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        Closeable closeable = new ObjectInputStream(bis);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ObjectInputStream ois = (ObjectInputStream)closeable;
            boolean bl3 = false;
            Object object2 = ois.readObject();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }
}

