/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.collectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.ParallelDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.ParallelDiagnosticsCollector$getCollectedDiagnostics$;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.SimpleDiagnosticReporter;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u001c\u0010\u001a\u001a\u00020\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00180\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/collectors/ParallelDiagnosticsCollector;", "Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "numberOfThreads", "", "(Lorg/jetbrains/kotlin/fir/FirSession;I)V", "collectorIndexCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "collectorLocalIndex", "Ljava/lang/ThreadLocal;", "futures", "Ljava/util/LinkedList;", "Ljava/util/concurrent/Future;", "pool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "reporters", "", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/SimpleDiagnosticReporter;", "getCollectedDiagnostics", "", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "initializeCollector", "", "initializeReporters", "runCheck", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class ParallelDiagnosticsCollector
extends AbstractDiagnosticCollector {
    private List<SimpleDiagnosticReporter> reporters;
    private final ThreadLocal<Integer> collectorLocalIndex;
    private final AtomicInteger collectorIndexCounter;
    private final LinkedList<Future<?>> futures;
    private final ExecutorService pool;
    private final int numberOfThreads;

    /*
     * WARNING - void declaration
     */
    private final List<SimpleDiagnosticReporter> initializeReporters() {
        void $this$mapTo$iv$iv;
        int n = 1;
        Iterable $this$map$iv = (Iterable)new IntRange(n, this.numberOfThreads);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SimpleDiagnosticReporter simpleDiagnosticReporter = new SimpleDiagnosticReporter();
            collection.add(simpleDiagnosticReporter);
        }
        return (List)destination$iv$iv;
    }

    @Override
    protected void initializeCollector() {
        this.reporters = this.initializeReporters();
        this.futures.clear();
    }

    @Override
    @NotNull
    protected Iterable<FirDiagnostic<?>> getCollectedDiagnostics() {
        Iterable $this$forEach$iv = this.futures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Future it = (Future)element$iv;
            boolean bl = false;
            it.get();
        }
        boolean bl = false;
        return new Iterable<FirDiagnostic<?>>(this){
            final /* synthetic */ ParallelDiagnosticsCollector this$0;
            {
                this.this$0 = parallelDiagnosticsCollector;
            }

            @NotNull
            public Iterator<FirDiagnostic<?>> iterator() {
                boolean bl = false;
                return new Iterator<FirDiagnostic<?>>(this){
                    private final Iterator<SimpleDiagnosticReporter> globalIterator;
                    private Iterator<? extends FirDiagnostic<?>> localIterator;
                    final /* synthetic */ getCollectedDiagnostics$$inlined$Iterable$1 this$0;
                    {
                        this.this$0 = var1_1;
                        this.globalIterator = ParallelDiagnosticsCollector.access$getReporters$p(this.this$0.this$0).iterator();
                        this.localIterator = this.globalIterator.next().getDiagnostics().iterator();
                    }

                    private final void update() {
                        while (!this.localIterator.hasNext() && this.globalIterator.hasNext()) {
                            this.localIterator = this.globalIterator.next().getDiagnostics().iterator();
                        }
                    }

                    public boolean hasNext() {
                        this.update();
                        return this.localIterator.hasNext();
                    }

                    @NotNull
                    public FirDiagnostic<?> next() {
                        this.update();
                        return this.localIterator.next();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @Override
    public void runCheck(@NotNull Function1<? super DiagnosticReporter, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Collection collection = this.futures;
        Future<?> future = this.pool.submit(new Runnable(this, block){
            final /* synthetic */ ParallelDiagnosticsCollector this$0;
            final /* synthetic */ Function1 $block;

            public final void run() {
                List list2 = ParallelDiagnosticsCollector.access$getReporters$p(this.this$0);
                T t = ParallelDiagnosticsCollector.access$getCollectorLocalIndex$p(this.this$0).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"collectorLocalIndex.get()");
                SimpleDiagnosticReporter reporter = (SimpleDiagnosticReporter)list2.get(((Number)t).intValue());
                this.$block.invoke((Object)reporter);
            }
            {
                this.this$0 = parallelDiagnosticsCollector;
                this.$block = function1;
            }
        });
        Intrinsics.checkNotNullExpressionValue(future, (String)"pool.submit {\n          \u2026block(reporter)\n        }");
        Future<?> future2 = future;
        boolean bl = false;
        collection.add(future2);
    }

    public ParallelDiagnosticsCollector(@NotNull FirSession session, int numberOfThreads) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, null, 2, null);
        this.numberOfThreads = numberOfThreads;
        boolean bl = this.numberOfThreads >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Number of threads should be at least 1";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.reporters = this.initializeReporters();
        this.collectorLocalIndex = new ThreadLocal();
        this.collectorIndexCounter = new AtomicInteger();
        this.futures = new LinkedList();
        this.pool = Executors.newFixedThreadPool(this.numberOfThreads, new ThreadFactory(this){
            final /* synthetic */ ParallelDiagnosticsCollector this$0;

            public final Thread newThread(Runnable runnable) {
                return new Thread(new Runnable(this, runnable){
                    final /* synthetic */ pool.1 this$0;
                    final /* synthetic */ Runnable $runnable;

                    public final void run() {
                        ParallelDiagnosticsCollector.access$getCollectorLocalIndex$p(this.this$0.this$0).set(ParallelDiagnosticsCollector.access$getCollectorIndexCounter$p(this.this$0.this$0).getAndIncrement());
                        this.$runnable.run();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$runnable = runnable;
                    }
                });
            }
            {
                this.this$0 = parallelDiagnosticsCollector;
            }
        });
    }

    public static final /* synthetic */ List access$getReporters$p(ParallelDiagnosticsCollector $this) {
        return $this.reporters;
    }

    public static final /* synthetic */ void access$setReporters$p(ParallelDiagnosticsCollector $this, List list2) {
        $this.reporters = list2;
    }

    public static final /* synthetic */ ThreadLocal access$getCollectorLocalIndex$p(ParallelDiagnosticsCollector $this) {
        return $this.collectorLocalIndex;
    }

    public static final /* synthetic */ AtomicInteger access$getCollectorIndexCounter$p(ParallelDiagnosticsCollector $this) {
        return $this.collectorIndexCounter;
    }
}

