/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.resolve.FirSamResolver;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SamResolutionKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.SubstitutorsKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0014\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirSamResolverImpl;", "Lorg/jetbrains/kotlin/fir/resolve/FirSamResolver;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "resolvedFunctionType", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "samConstructor", "buildSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firRegularClass", "getFunctionTypeForPossibleSamType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getSamConstructor", "resolveFunctionTypeIfSamInterface", "shouldRunSamConversionForFunction", "", "firFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "resolve"})
public final class FirSamResolverImpl
implements FirSamResolver {
    private final Map<FirRegularClass, Object> resolvedFunctionType;
    private final Map<FirRegularClass, Object> samConstructor;
    private final FirSession firSession;
    private final ScopeSession scopeSession;

    @Override
    @Nullable
    public ConeKotlinType getFunctionTypeForPossibleSamType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType coneKotlinType2 = type2;
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.getFunctionTypeForPossibleSamType((ConeClassLikeType)type2);
        } else if (coneKotlinType2 instanceof ConeFlexibleType) {
            ConeKotlinType coneKotlinType3 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getLowerBound());
            if (coneKotlinType3 == null) {
                return null;
            }
            ConeKotlinType coneKotlinType4 = this.getFunctionTypeForPossibleSamType(((ConeFlexibleType)type2).getUpperBound());
            if (coneKotlinType4 == null) {
                return null;
            }
            coneKotlinType = new ConeFlexibleType(coneKotlinType3, coneKotlinType4);
        } else if (coneKotlinType2 instanceof ConeClassErrorType || coneKotlinType2 instanceof ConeStubType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeTypeParameterType || coneKotlinType2 instanceof ConeTypeVariableType || coneKotlinType2 instanceof ConeCapturedType || coneKotlinType2 instanceof ConeDefinitelyNotNullType || coneKotlinType2 instanceof ConeIntersectionType || coneKotlinType2 instanceof ConeIntegerLiteralType) {
            coneKotlinType = null;
        } else if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
            coneKotlinType = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final ConeLookupTagBasedType getFunctionTypeForPossibleSamType(ConeClassLikeType type2) {
        Object object;
        Iterable iterable;
        ConeTypeProjection[] $this$mapTo$iv$iv;
        FirClassLikeSymbol<?> firClassLikeSymbol = ResolveUtilsKt.getFirSymbolProvider(this.firSession).getSymbolByLookupTag(type2.getLookupTag());
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        if (!(firClassLikeDeclaration instanceof FirRegularClass)) {
            firClassLikeDeclaration = null;
        }
        FirRegularClass firRegularClass = (FirRegularClass)firClassLikeDeclaration;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass firRegularClass2 = firRegularClass;
        ConeKotlinType coneKotlinType = this.resolveFunctionTypeIfSamInterface(firRegularClass2);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType unsubstitutedFunctionType = coneKotlinType;
        ConeTypeProjection[] $this$map$iv = (ConeTypeProjection[])firRegularClass2.getTypeParameters();
        boolean $i$f$map = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)t;
            iterable = destination$iv$iv;
            boolean bl = false;
            object = it.getSymbol();
            iterable.add(object);
        }
        $this$map$iv = type2.getTypeArguments();
        iterable = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        ConeTypeProjection[] coneTypeProjectionArray2 = $this$mapTo$iv$iv;
        int n = coneTypeProjectionArray2.length;
        for (int i = 0; i < n; ++i) {
            ConeKotlinTypeProjection coneKotlinTypeProjection;
            void it;
            ConeTypeProjection item$iv$iv;
            ConeTypeProjection coneTypeProjection = item$iv$iv = coneTypeProjectionArray2[i];
            object = destination$iv$iv;
            boolean bl = false;
            Object v4 = it;
            if (!(v4 instanceof ConeKotlinTypeProjection)) {
                v4 = null;
            }
            if ((coneKotlinTypeProjection = (ConeKotlinTypeProjection)v4) == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
                coneKotlinTypeProjection = this.firSession.getBuiltinTypes().getNullableAnyType().getType();
            }
            ConeKotlinTypeProjection coneKotlinTypeProjection2 = coneKotlinTypeProjection;
            object.add(coneKotlinTypeProjection2);
        }
        object = (List)destination$iv$iv;
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable, (Iterable)((Iterable)object))));
        ConeKotlinType result2 = TypeUtilsKt.withNullability(substitutor2.substituteOrSelf(unsubstitutedFunctionType), ConeNullability.Companion.create(ConeTypeUtilsKt.isMarkedNullable(type2)), SessionUtilsKt.getInferenceContext(this.firSession));
        boolean bl = result2 instanceof ConeLookupTagBasedType;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Function type should always be ConeLookupTagBasedType, but " + Reflection.getOrCreateKotlinClass(result2.getClass()) + " was found";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return (ConeLookupTagBasedType)result2;
    }

    @Override
    @Nullable
    public FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firRegularClass) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)firRegularClass, (String)"firRegularClass");
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.samConstructor;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            boolean bl = false;
            Object object3 = this.buildSamConstructor(firRegularClass);
            if (object3 == null) {
                object3 = SamResolutionKt.access$getNULL_STUB$p();
            }
            FirSimpleFunction answer$iv = object3;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = object = value$iv;
        }
        if (!(object2 instanceof FirSimpleFunction)) {
            object = null;
        }
        return (FirSimpleFunction)object;
    }

    /*
     * WARNING - void declaration
     */
    private final FirSimpleFunction buildSamConstructor(FirRegularClass firRegularClass) {
        void $this$buildResolvedTypeRef;
        void $this$buildResolvedTypeRef2;
        void $this$mapTo$iv$iv;
        Iterable $this$apply;
        FirTypeParameterBuilder $this$mapTo$iv$iv2;
        Object item$iv$iv3;
        void $this$mapTo$iv$iv3;
        Object object;
        Object object2;
        Object object3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Iterable it;
        ConeKotlinType coneKotlinType = this.resolveFunctionTypeIfSamInterface(firRegularClass);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType functionType = coneKotlinType;
        ClassId classId = FirDeclarationUtilKt.getClassId(firRegularClass);
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
        FqName fqName3 = classId.getRelativeClassName().parent();
        boolean bl = false;
        boolean bl2 = false;
        FqName fqName4 = fqName3;
        FqName fqName5 = fqName2;
        boolean bl3 = false;
        void v2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
        boolean bl4 = !v2.isRoot();
        FqName fqName6 = bl4 ? fqName3 : null;
        Name name = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"classId.shortClassName");
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        FqName fqName7 = null;
        Name name2 = name;
        FqName fqName8 = fqName6;
        FqName fqName9 = fqName5;
        CallableId callableId = new CallableId(fqName9, fqName8, name2, fqName7, n, defaultConstructorMarker);
        FirSyntheticFunctionSymbol symbol2 = new FirSyntheticFunctionSymbol(callableId);
        Iterable $this$map$iv = firRegularClass.getTypeParameters();
        boolean $i$f$map = false;
        it = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
            void typeParameter;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl5 = false;
            FirTypeParameter declaredTypeParameter = (FirTypeParameter)typeParameter.getSymbol().getFir();
            FirTypeParameterBuilder firTypeParameterBuilder = new FirTypeParameterBuilder();
            boolean bl6 = false;
            boolean bl7 = false;
            FirTypeParameterBuilder $this$apply2 = firTypeParameterBuilder;
            boolean bl8 = false;
            $this$apply2.setSource(declaredTypeParameter.getSource());
            $this$apply2.setSession(this.firSession);
            $this$apply2.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
            $this$apply2.setName(declaredTypeParameter.getName());
            $this$apply2.setSymbol(new FirTypeParameterSymbol());
            $this$apply2.setVariance(Variance.INVARIANT);
            $this$apply2.setReified(false);
            object3 = $this$apply2.getAnnotations();
            object2 = declaredTypeParameter.getAnnotations();
            boolean bl9 = false;
            CollectionsKt.addAll((Collection)object3, (Iterable)object2);
            object = firTypeParameterBuilder;
            collection.add(object);
        }
        List newTypeParameters = (List)destination$iv$iv;
        Iterable $this$map$iv2 = newTypeParameters;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
            void it2;
            FirTypeParameterBuilder bl5 = (FirTypeParameterBuilder)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl10 = false;
            object = new ConeTypeParameterTypeImpl(it2.getSymbol().toLookupTag(), false);
            collection.add(object);
        }
        List newTypeParameterTypes = (List)destination$iv$iv2;
        Iterable $this$map$iv32 = firRegularClass.getTypeParameters();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv32;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv32, (int)10));
        boolean $i$f$mapTo3 = false;
        item$iv$iv3 = $this$mapTo$iv$iv2.iterator();
        while (item$iv$iv3.hasNext()) {
            void it3;
            Object item$iv$iv4 = item$iv$iv3.next();
            FirTypeParameterRef bl10 = (FirTypeParameterRef)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl11 = false;
            object = it3.getSymbol();
            collection.add(object);
        }
        ConeSubstitutor substitutor2 = SubstitutorsKt.substitutorByMap(MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv3), (Iterable)newTypeParameterTypes)));
        for (Iterable $this$map$iv32 : CollectionsKt.zip((Iterable)newTypeParameters, (Iterable)firRegularClass.getTypeParameters())) {
            void $this$mapNotNullTo$iv$iv;
            void newTypeParameter;
            $this$mapTo$iv$iv2 = (FirTypeParameterBuilder)$this$map$iv32.component1();
            FirTypeParameterRef oldTypeParameter = (FirTypeParameterRef)$this$map$iv32.component2();
            FirTypeParameter declared = (FirTypeParameter)oldTypeParameter.getSymbol().getFir();
            item$iv$iv3 = newTypeParameter.getBounds();
            Iterable $this$mapNotNull$iv = declared.getBounds();
            boolean $i$f$mapNotNull = false;
            Iterable bl11 = $this$mapNotNull$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object3 = $this$forEach$iv$iv$iv.iterator();
            while (object3.hasNext()) {
                FirResolvedTypeRef firResolvedTypeRef;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object3.next();
                boolean bl12 = false;
                FirTypeRef typeRef = (FirTypeRef)element$iv$iv;
                boolean bl13 = false;
                boolean $i$f$buildResolvedTypeRef = false;
                boolean bl14 = false;
                FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                boolean bl15 = false;
                boolean bl16 = false;
                FirResolvedTypeRefBuilder $this$buildResolvedTypeRef3 = firResolvedTypeRefBuilder;
                boolean bl17 = false;
                $this$buildResolvedTypeRef3.setSource(typeRef.getSource());
                FirTypeRef $this$coneTypeSafe$iv = typeRef;
                boolean $i$f$coneTypeSafe = false;
                boolean bl18 = false;
                FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                    firTypeRef = null;
                }
                FirResolvedTypeRef firResolvedTypeRef2 = (FirResolvedTypeRef)firTypeRef;
                ConeKotlinType coneKotlinType2 = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getType() : null;
                if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                    coneKotlinType2 = null;
                }
                if (coneKotlinType2 == null) {
                    Object var36_113 = null;
                    firResolvedTypeRef = var36_113;
                } else {
                    $this$buildResolvedTypeRef3.setType(substitutor2.substituteOrSelf(coneKotlinType2));
                    firResolvedTypeRef = firResolvedTypeRefBuilder.build();
                }
                if (firResolvedTypeRef == null) continue;
                FirResolvedTypeRef firResolvedTypeRef3 = firResolvedTypeRef;
                boolean bl19 = false;
                boolean bl20 = false;
                FirResolvedTypeRef it$iv$iv = firResolvedTypeRef3;
                boolean bl21 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv4;
            $i$f$mapNotNull = false;
            CollectionsKt.addAll((Collection)item$iv$iv3, (Iterable)$this$mapNotNull$iv);
        }
        boolean $i$f$buildSimpleFunction = false;
        boolean bl22 = false;
        FirSimpleFunctionBuilder firSimpleFunctionBuilder = new FirSimpleFunctionBuilder();
        boolean bl23 = false;
        boolean bl24 = false;
        FirSimpleFunctionBuilder $this$buildSimpleFunction = firSimpleFunctionBuilder;
        boolean bl25 = false;
        $this$buildSimpleFunction.setSession(this.firSession);
        Name name3 = classId.getShortClassName();
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"classId.shortClassName");
        $this$buildSimpleFunction.setName(name3);
        $this$buildSimpleFunction.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        Object $this$visibility$iv = firRegularClass;
        boolean $i$f$getVisibility = false;
        $this$visibility$iv = new FirDeclarationStatusImpl($this$visibility$iv.getStatus().getVisibility(), Modality.FINAL);
        $i$f$getVisibility = false;
        boolean $this$mapNotNullTo$iv$iv = false;
        FirElement destination$iv$iv4 = $this$visibility$iv;
        Object object4 = $this$buildSimpleFunction;
        boolean bl26 = false;
        FirMemberDeclaration $this$isExpect$iv = firRegularClass;
        boolean $i$f$isExpect = false;
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setExpect($this$isExpect$iv.getStatus().isExpect());
        FirMemberDeclaration $this$isActual$iv = firRegularClass;
        boolean $i$f$isActual22 = false;
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setActual($this$isActual$iv.getStatus().isActual());
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setOverride(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setOperator(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setInfix(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setExternal(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setInline(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setSuspend(false);
        ((FirDeclarationStatusImpl)((Object)$this$apply)).setTailRec(false);
        object2 = Unit.INSTANCE;
        ((FirSimpleFunctionBuilder)object4).setStatus((FirDeclarationStatus)$this$visibility$iv);
        $this$buildSimpleFunction.setSymbol(symbol2);
        $this$visibility$iv = $this$buildSimpleFunction.getTypeParameters();
        Iterable $this$map$iv4 = newTypeParameters;
        boolean $i$f$map4 = false;
        $this$apply = $this$map$iv4;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv5 : $this$mapTo$iv$iv) {
            void it4;
            FirTypeParameterBuilder bl12 = (FirTypeParameterBuilder)item$iv$iv5;
            object4 = destination$iv$iv5;
            boolean bl27 = false;
            object2 = it4.build();
            object4.add(object2);
        }
        $this$map$iv4 = (List)destination$iv$iv5;
        $i$f$map4 = false;
        CollectionsKt.addAll((Collection)$this$visibility$iv, (Iterable)$this$map$iv4);
        ConeKotlinType substitutedFunctionType = substitutor2.substituteOrSelf(functionType);
        Collection $this$toTypedArray$iv = newTypeParameterTypes;
        boolean $i$f$toTypedArray22 = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray = thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]);
        if (coneTypeParameterTypeImplArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ConeClassLikeTypeImpl substitutedReturnType = new ConeClassLikeTypeImpl(firRegularClass.getSymbol().toLookupTag(), coneTypeParameterTypeImplArray, false);
        boolean $i$f$buildResolvedTypeRef = false;
        $i$f$toTypedArray22 = false;
        FirResolvedTypeRefBuilder $i$f$toTypedArray22 = new FirResolvedTypeRefBuilder();
        boolean bl28 = false;
        boolean bl29 = false;
        FirResolvedTypeRefBuilder $i$f$isActual22 = $i$f$toTypedArray22;
        object4 = $this$buildSimpleFunction;
        boolean bl30 = false;
        $this$buildResolvedTypeRef2.setSource(null);
        $this$buildResolvedTypeRef2.setType(substitutedReturnType);
        object2 = Unit.INSTANCE;
        ((FirSimpleFunctionBuilder)object4).setReturnTypeRef($i$f$toTypedArray22.build());
        Collection collection2 = $this$buildSimpleFunction.getValueParameters();
        boolean $i$f$buildValueParameter = false;
        bl28 = false;
        FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
        bl29 = false;
        boolean bl31 = false;
        FirValueParameterBuilder $this$buildValueParameter = firValueParameterBuilder;
        boolean bl32 = false;
        $this$buildValueParameter.setSession(this.firSession);
        $this$buildValueParameter.setOrigin(FirDeclarationOrigin.SamConstructor.INSTANCE);
        boolean $i$f$buildResolvedTypeRef2 = false;
        boolean bl33 = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
        boolean bl34 = false;
        boolean bl35 = false;
        FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder;
        FirValueParameterBuilder firValueParameterBuilder2 = $this$buildValueParameter;
        boolean bl36 = false;
        $this$buildResolvedTypeRef.setSource(firRegularClass.getSource());
        $this$buildResolvedTypeRef.setType(substitutedFunctionType);
        Unit unit = Unit.INSTANCE;
        firValueParameterBuilder2.setReturnTypeRef(firResolvedTypeRefBuilder.build());
        $this$buildValueParameter.setName(SamResolutionKt.getSAM_PARAMETER_NAME());
        $this$buildValueParameter.setSymbol(new FirVariableSymbol<FirValueParameter>(SamResolutionKt.getSAM_PARAMETER_NAME()));
        $this$buildValueParameter.setCrossinline(false);
        $this$buildValueParameter.setNoinline(false);
        $this$buildValueParameter.setVararg(false);
        FirValueParameter firValueParameter = firValueParameterBuilder.build();
        boolean bl37 = false;
        collection2.add(firValueParameter);
        $this$buildSimpleFunction.setResolvePhase(FirResolvePhase.BODY_RESOLVE);
        return firSimpleFunctionBuilder.build();
    }

    private final ConeKotlinType resolveFunctionTypeIfSamInterface(FirRegularClass firRegularClass) {
        Object object;
        Object object2;
        Map<FirRegularClass, Object> $this$getOrPut$iv = this.resolvedFunctionType;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(firRegularClass);
        if (value$iv == null) {
            Object object3;
            boolean bl = false;
            FirSimpleFunction firSimpleFunction = SamResolutionKt.access$getSingleAbstractMethodOrNull(firRegularClass, this.firSession, this.scopeSession);
            if (firSimpleFunction == null) {
                object3 = SamResolutionKt.access$getNULL_STUB$p();
            } else {
                FirSimpleFunction abstractMethod = firSimpleFunction;
                object3 = SamResolutionKt.access$getFunctionTypeForAbstractMethod(abstractMethod);
            }
            Object answer$iv = object3;
            $this$getOrPut$iv.put(firRegularClass, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = object = value$iv;
        }
        if (!(object2 instanceof ConeKotlinType)) {
            object = null;
        }
        return (ConeKotlinType)object;
    }

    @Override
    public boolean shouldRunSamConversionForFunction(@NotNull FirFunction<?> firFunction) {
        Intrinsics.checkNotNullParameter(firFunction, (String)"firFunction");
        return true;
    }

    public FirSamResolverImpl(@NotNull FirSession firSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.firSession = firSession;
        this.scopeSession = scopeSession;
        boolean bl = false;
        this.resolvedFunctionType = new LinkedHashMap();
        bl = false;
        this.samConstructor = new LinkedHashMap();
    }
}

