/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptionalExpectationChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getOptionalExpectationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend"})
public final class OptionalExpectationChecker {
    public static final OptionalExpectationChecker INSTANCE;

    public final void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        block2: {
            block1: {
                boolean isExpect;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
                boolean bl = isExpect = descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect();
                if (!isExpect) break block1;
                if (!DescriptorUtils.isAnnotationClass(descriptor2) || descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor) break block2;
                KtAnnotationEntry ktAnnotationEntry = this.getOptionalExpectationEntry(declaration, trace);
                if (ktAnnotationEntry != null) {
                    KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    KtAnnotationEntry it = ktAnnotationEntry2;
                    boolean bl4 = false;
                    trace.report(Errors.NESTED_OPTIONAL_EXPECTATION.on((PsiElement)it));
                }
                break block2;
            }
            KtAnnotationEntry ktAnnotationEntry = this.getOptionalExpectationEntry(declaration, trace);
            if (ktAnnotationEntry == null) break block2;
            KtAnnotationEntry ktAnnotationEntry3 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl5 = false;
            KtAnnotationEntry it = ktAnnotationEntry3;
            boolean bl6 = false;
            trace.report(Errors.OPTIONAL_EXPECTATION_NOT_ON_EXPECTED.on((PsiElement)it));
        }
    }

    private final KtAnnotationEntry getOptionalExpectationEntry(KtDeclaration declaration, BindingTrace trace) {
        Object v3;
        block1: {
            List list2 = declaration.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"declaration.annotationEntries");
            Iterable iterable = list2;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                AnnotationDescriptor annotationDescriptor;
                KtAnnotationEntry entry = (KtAnnotationEntry)t;
                boolean bl3 = false;
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
                FqName fqName2 = annotationDescriptor2 != null ? annotationDescriptor2.getFqName() : null;
                if (!Intrinsics.areEqual((Object)fqName2, (Object)ExpectedActualDeclarationChecker.Companion.getOPTIONAL_EXPECTATION_FQ_NAME())) continue;
                v3 = t;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    private OptionalExpectationChecker() {
    }

    static {
        OptionalExpectationChecker optionalExpectationChecker;
        INSTANCE = optionalExpectationChecker = new OptionalExpectationChecker();
    }
}

