/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.ContextProvider;
import org.intellij.lang.xpath.psi.XPathToken;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.context.XsltContextProviderBase;
import org.intellij.lang.xpath.xslt.quickfix.ConvertToEntityFix;
import org.intellij.lang.xpath.xslt.quickfix.FlipOperandsFix;
import org.intellij.lang.xpath.xslt.validation.XsltPatternValidator;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class XsltAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        boolean isXslt;
        if (psiElement == null) {
            XsltAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            XsltAnnotator.$$$reportNull$$$0(1);
        }
        if (isXslt = ContextProvider.getContextProvider(psiElement) instanceof XsltContextProviderBase) {
            if (psiElement instanceof XPathFile) {
                this.visitXPathFile((XPathFile)psiElement, holder);
            } else if (psiElement instanceof XPathToken) {
                this.visitXPathToken((XPathToken)psiElement, holder);
            }
        }
    }

    public void visitXPathFile(XPathFile file, AnnotationHolder holder) {
        XmlAttribute context = (XmlAttribute)PsiTreeUtil.getContextOfType((PsiElement)file, XmlAttribute.class, (boolean)true);
        if (context != null) {
            FileASTNode node;
            if (XsltSupport.isPatternAttribute(context)) {
                XsltPatternValidator.validate(holder, (PsiFile)file);
            } else if (file.getText().trim().length() == 0 && file.getExpression() == null) {
                holder.newAnnotation(HighlightSeverity.ERROR, XPathBundle.message("annotator.error.empty.xpath.expression", new Object[0])).create();
            }
            if (XsltSupport.isXsltAttribute(context) && !XsltSupport.mayBeAVT(context) && (node = file.getNode()).findChildByType(XPathTokenTypes.LBRACE) != null) {
                holder.newAnnotation(HighlightSeverity.ERROR, XPathBundle.message("annotator.error.attribute.value.template.not.allowed.here", new Object[0])).create();
            }
        }
    }

    public void visitXPathToken(XPathToken token, AnnotationHolder holder) {
        if (XPathTokenTypes.REL_OPS.contains(token.getTokenType()) && token.textContains('<')) {
            holder.newAnnotation(HighlightSeverity.ERROR, XPathBundle.message("annotator.less.than.must.be.escaped.as.ampersand.lt.in.xslt.documents", new Object[0])).withFix((IntentionAction)new ConvertToEntityFix(token)).withFix((IntentionAction)new FlipOperandsFix(token)).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/xpath/xslt/validation/XsltAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

