/*
 * Decompiled with CFR 0.152.
 */
package training.keymap;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\bJ\u0012\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019*\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u001aJ\f\u0010\u001b\u001a\u00020\b*\u00020\bH\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u001c"}, d2={"Ltraining/keymap/KeymapUtil;", "", "()V", "isNumpadKey", "", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "(Lcom/intellij/openapi/actionSystem/KeyboardShortcut;)Z", "decryptMacShortcut", "", "shortcut", "getGotoActionText", "actionId", "getKeyStrokeText", "keyStroke", "Ljavax/swing/KeyStroke;", "getModifiersText", "modifiers", "", "getShortcutByActionId", "getStringForMacSymbol", "c", "", "toCanonical", "modifiersString", "getModifiers", "", "(Ljava/lang/String;)[Ljava/lang/String;", "replaceSpacesWithNonBreakSpace", "intellij.featuresTrainer"})
public final class KeymapUtil {
    public static final KeymapUtil INSTANCE;

    @Nullable
    public final KeyStroke getShortcutByActionId(@Nullable String actionId) {
        if (actionId == null) {
            return null;
        }
        Function1<KeyboardShortcut, Boolean> $fun$isConflicting$1 = new Function1<KeyboardShortcut, Boolean>(actionId){
            final /* synthetic */ String $actionId;

            public final boolean invoke(@NotNull KeyboardShortcut $this$isConflicting) {
                Intrinsics.checkNotNullParameter((Object)$this$isConflicting, (String)"$this$isConflicting");
                KeymapManager keymapManager = KeymapManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
                Map map = keymapManager.getActiveKeymap().getConflicts(this.$actionId, $this$isConflicting);
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"KeymapManager.getInstanc\u2026Conflicts(actionId, this)");
                Map map2 = map;
                boolean bl = false;
                return !map2.isEmpty();
            }
            {
                this.$actionId = string;
                super(1);
            }
        };
        KeymapManager keymapManager = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
        Shortcut[] shortcuts = keymapManager.getActiveKeymap().getShortcuts(actionId);
        KeyboardShortcut bestShortcut = null;
        for (Shortcut curShortcut : shortcuts) {
            if (!(curShortcut instanceof KeyboardShortcut)) continue;
            boolean isConflicting = $fun$isConflicting$1.invoke((KeyboardShortcut)curShortcut);
            boolean isNumpadKey = this.isNumpadKey((KeyboardShortcut)curShortcut);
            if (bestShortcut == null || !isConflicting && !isNumpadKey || !isNumpadKey && this.isNumpadKey(bestShortcut) || !isConflicting && $fun$isConflicting$1.invoke(bestShortcut) && this.isNumpadKey(bestShortcut)) {
                bestShortcut = (KeyboardShortcut)curShortcut;
            }
            if (!isConflicting && !isNumpadKey) break;
        }
        KeyboardShortcut keyboardShortcut = bestShortcut;
        return keyboardShortcut != null ? keyboardShortcut.getFirstKeyStroke() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNumpadKey(KeyboardShortcut $this$isNumpadKey) {
        KeyStroke keyStroke = $this$isNumpadKey.getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"firstKeyStroke");
        int n = keyStroke.getKeyCode();
        if (96 <= n) {
            if (111 >= n) return true;
        }
        KeyStroke keyStroke2 = $this$isNumpadKey.getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"firstKeyStroke");
        if (keyStroke2.getKeyCode() != 144) return false;
        return true;
    }

    @NlsSafe
    @NotNull
    public final String getKeyStrokeText(@Nullable KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String modifiers = this.getModifiersText(keyStroke.getModifiers());
        String key = SystemInfo.isMac ? MacKeymapUtil.getKeyText((int)keyStroke.getKeyCode()) : KeyEvent.getKeyText(keyStroke.getKeyCode());
        return this.toCanonical(modifiers) + key;
    }

    @NotNull
    public final String getGotoActionText(@NonNls @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        StringBuilder stringBuilder = new StringBuilder().append(this.getKeyStrokeText(this.getShortcutByActionId("GotoAction"))).append(" \u2192 ");
        AnAction anAction = ActionManager.getInstance().getAction(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"ActionManager.getInstance().getAction(actionId)");
        Presentation presentation = anAction.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"ActionManager.getInstanc\u2026nId).templatePresentation");
        return this.replaceSpacesWithNonBreakSpace(stringBuilder.append(presentation.getText()).toString());
    }

    private final String getModifiersText(int modifiers) {
        String string = KeyEvent.getKeyModifiersText(modifiers);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeyEvent.getKeyModifiersText(modifiers)");
        return string;
    }

    private final String toCanonical(String modifiersString) {
        String string;
        CharSequence charSequence = modifiersString;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        if (SystemInfo.isMac) {
            String string2;
            if (StringsKt.contains$default((CharSequence)modifiersString, (CharSequence)"+", (boolean)false, (int)2, null)) {
                for (String modifier : this.getModifiers(modifiersString)) {
                    result2.append(modifier);
                }
                String string3 = result2.toString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"result.toString()");
            } else {
                string2 = modifiersString;
            }
            return string2;
        }
        if (StringsKt.contains$default((CharSequence)modifiersString, (CharSequence)"+", (boolean)false, (int)2, null)) {
            for (String modifier : this.getModifiers(modifiersString)) {
                result2.append(modifier).append(" + ");
            }
            String string4 = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"result.toString()");
            string = this.replaceSpacesWithNonBreakSpace(string4);
        } else {
            string = this.replaceSpacesWithNonBreakSpace(modifiersString + " + ");
        }
        return string;
    }

    private final String[] getModifiers(String $this$getModifiers) {
        List list2;
        CharSequence charSequence = $this$getModifiers;
        String string = "[ +]";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private final String replaceSpacesWithNonBreakSpace(String $this$replaceSpacesWithNonBreakSpace) {
        return StringsKt.replace$default((String)$this$replaceSpacesWithNonBreakSpace, (String)" ", (String)"\u00a0", (boolean)false, (int)4, null);
    }

    @NlsSafe
    @NotNull
    public final String decryptMacShortcut(@NotNull String shortcut) {
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        if (StringsKt.contains$default((CharSequence)shortcut, (char)'\u2192', (boolean)false, (int)2, null)) {
            List split = StringsKt.split$default((CharSequence)shortcut, (char[])new char[]{'\u2192'}, (boolean)false, (int)0, (int)6, null);
            if (split.size() != 2) {
                return shortcut;
            }
            String string = (String)split.get(0);
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            return this.decryptMacShortcut(((Object)StringsKt.trim((CharSequence)string2)).toString()) + " \u2192" + (String)split.get(1);
        }
        StringBuffer buffer = new StringBuffer();
        boolean shouldInsertPlus = false;
        String string = shortcut;
        int n = string.length();
        for (int j = 0; j < n; ++j) {
            String stringForMacSymbol;
            char c = string.charAt(j);
            if (CharsKt.isWhitespace((char)c)) {
                shouldInsertPlus = true;
                continue;
            }
            if (shouldInsertPlus) {
                buffer.append(" + ");
            }
            if ((stringForMacSymbol = this.getStringForMacSymbol(c)) != null) {
                buffer.append(stringForMacSymbol);
                shouldInsertPlus = true;
                continue;
            }
            buffer.append(c);
            shouldInsertPlus = false;
        }
        String string3 = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"buffer.toString()");
        return string3;
    }

    private final String getStringForMacSymbol(char c) {
        switch (c) {
            case '\u238b': {
                return "Escape";
            }
            case '\u21e5': {
                return "Tab";
            }
            case '\u21ea': {
                return "Caps Lock";
            }
            case '\u21e7': {
                return "Shift";
            }
            case '\u2303': {
                return "Control";
            }
            case '\u2325': {
                return "Option";
            }
            case '\u2318': {
                return "Command";
            }
            case '\u23ce': {
                return "Return";
            }
            case '\u232b': {
                return "Backspace";
            }
            case '\u2326': {
                return "Delete";
            }
            case '\u2196': {
                return "Home";
            }
            case '\u2198': {
                return "End";
            }
            case '\u21de': {
                return "Page Up";
            }
            case '\u21df': {
                return "Page Down";
            }
            case '\u2191': {
                return "Up";
            }
            case '\u2193': {
                return "Down";
            }
            case '\u2190': {
                return "Left";
            }
            case '\u2192': {
                return "Right";
            }
            case '\u21ed': {
                return "Num Lock";
            }
            case '\u2328': {
                return "NumPad";
            }
        }
        return null;
    }

    private KeymapUtil() {
    }

    static {
        KeymapUtil keymapUtil;
        INSTANCE = keymapUtil = new KeymapUtil();
    }
}

