/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GHLoginRequestKt;
import org.jetbrains.plugins.github.authentication.GHOAuthServiceKt;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManagerKt;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 12\u00020\u0001:\u00011B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007J\u001e\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0017J\u0006\u0010\u0018\u001a\u00020\nJ\u001d\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ+\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"J%\u0010#\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b%J\u001d\u0010#\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b'J \u0010(\u001a\u0004\u0018\u00010\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J(\u0010)\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J0\u0010)\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J-\u0010*\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0001\u00a2\u0006\u0002\b+J&\u0010,\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u001a\u0010-\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0007J\u001d\u0010.\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b0R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "", "()V", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "getAccountManager", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "clearAccounts", "", "ensureHasAccounts", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "getAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getDefaultAccount", "getSingleOrDefaultAccount", "getTokenForAccount", "", "account", "getTokenForAccount$intellij_vcs_github", "hasAccounts", "isAccountUnique", "name", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "isAccountUnique$intellij_vcs_github", "login", "Lorg/jetbrains/plugins/github/authentication/GHAccountAuthData;", "request", "Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;", "login$intellij_vcs_github", "registerAccount", "token", "registerAccount$intellij_vcs_github", "removeAccount", "removeAccount$intellij_vcs_github", "requestNewAccount", "requestNewAccountForServer", "requestNewToken", "requestNewToken$intellij_vcs_github", "requestReLogin", "setDefaultAccount", "updateAccountToken", "newToken", "updateAccountToken$intellij_vcs_github", "Companion", "intellij.vcs.github"})
public final class GithubAuthenticationManager {
    public static final Companion Companion = new Companion(null);

    private final GithubAccountManager getAccountManager() {
        boolean $i$f$service = false;
        Object object = ApplicationManager.getApplication().getService(GithubAccountManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
        return (GithubAccountManager)object;
    }

    public final boolean hasAccounts() {
        Collection collection = this.getAccountManager().getAccounts();
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final Set<GithubAccount> getAccounts() {
        return this.getAccountManager().getAccounts();
    }

    @Nullable
    public final String getTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        return this.getAccountManager().getTokenForAccount(account);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final String requestNewToken$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(GithubBundle.message("account.token.missing.for", account), null, account.getServer(), false, account.getName(), false, false, null, null, 490, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$updateAccount(gHAccountAuthData, account) : null;
    }

    public static /* synthetic */ String requestNewToken$intellij_vcs_github$default(GithubAuthenticationManager githubAuthenticationManager, GithubAccount githubAccount, Project project, Component component, int n, Object object) {
        if ((n & 4) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewToken$intellij_vcs_github(githubAccount, project, component);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final String requestNewToken$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewToken$intellij_vcs_github$default(this, account, project, null, 4, null);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project, @Nullable Component parentComponent) {
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, null, false, null, false, true, null, null, 447, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$registerAccount(gHAccountAuthData) : null;
    }

    public static /* synthetic */ GithubAccount requestNewAccount$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewAccount(project, component);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccount$default(this, project, null, 2, null);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, server, false, null, false, true, null, null, 443, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$registerAccount(gHAccountAuthData) : null;
    }

    public static /* synthetic */ GithubAccount requestNewAccountForServer$default(GithubAuthenticationManager githubAuthenticationManager, GithubServerPath githubServerPath, Project project, Component component, int n, Object object) {
        if ((n & 4) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewAccountForServer(githubServerPath, project, component);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccountForServer$default(this, server, project, null, 4, null);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @NotNull String login2, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, server, false, login2, false, true, null, null, 395, null));
        return gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$registerAccount(gHAccountAuthData) : null;
    }

    public static /* synthetic */ GithubAccount requestNewAccountForServer$default(GithubAuthenticationManager githubAuthenticationManager, GithubServerPath githubServerPath, String string, Project project, Component component, int n, Object object) {
        if ((n & 8) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewAccountForServer(githubServerPath, string, project, component);
    }

    @RequiresEdt
    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @NotNull String login2, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccountForServer$default(this, server, login2, project, null, 8, null);
    }

    public final boolean isAccountUnique$intellij_vcs_github(@NotNull String name, @NotNull GithubServerPath server) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Iterable $this$none$iv = this.getAccountManager().getAccounts();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    GithubAccount it = (GithubAccount)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && it.getServer().equals(server, true))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean requestReLogin(@NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        GHAccountAuthData gHAccountAuthData = this.login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, null, account.getServer(), false, account.getName(), false, false, null, null, 491, null));
        return (gHAccountAuthData != null ? GithubAuthenticationManagerKt.access$updateAccount(gHAccountAuthData, account) : null) != null;
    }

    public static /* synthetic */ boolean requestReLogin$default(GithubAuthenticationManager githubAuthenticationManager, GithubAccount githubAccount, Project project, Component component, int n, Object object) {
        if ((n & 4) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestReLogin(githubAccount, project, component);
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean requestReLogin(@NotNull GithubAccount account, @Nullable Project project) {
        return GithubAuthenticationManager.requestReLogin$default(this, account, project, null, 4, null);
    }

    @RequiresEdt
    @Nullable
    public final GHAccountAuthData login$intellij_vcs_github(@Nullable Project project, @Nullable Component parentComponent, @NotNull GHLoginRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        GithubServerPath githubServerPath = request.getServer();
        Boolean isGH = githubServerPath != null ? Boolean.valueOf(githubServerPath.isGithubDotCom()) : null;
        return Intrinsics.areEqual((Object)isGH, (Object)false) ? GHLoginRequestKt.loginWithToken(request, project, parentComponent) : (Intrinsics.areEqual((Object)isGH, (Object)true) && GHOAuthServiceKt.isOAuthEnabled() ? GHLoginRequestKt.loginWithOAuthOrToken(request, project, parentComponent) : GHLoginRequestKt.loginWithPasswordOrToken(request, project, parentComponent));
    }

    @RequiresEdt
    public final void removeAccount$intellij_vcs_github(@NotNull GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        GithubAccountManager githubAccountManager = this.getAccountManager();
        githubAccountManager.setAccounts(SetsKt.minus(githubAccountManager.getAccounts(), (Object)account));
    }

    @RequiresEdt
    public final void updateAccountToken$intellij_vcs_github(@NotNull GithubAccount account, @NotNull String newToken) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)newToken, (String)"newToken");
        this.getAccountManager().updateAccountToken(account, newToken);
    }

    @RequiresEdt
    @NotNull
    public final GithubAccount registerAccount$intellij_vcs_github(@NotNull String name, @NotNull GithubServerPath server, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return this.registerAccount$intellij_vcs_github(GithubAccountManager.Companion.createAccount(name, server), token);
    }

    @RequiresEdt
    @NotNull
    public final GithubAccount registerAccount$intellij_vcs_github(@NotNull GithubAccount account, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        GithubAccountManager githubAccountManager = this.getAccountManager();
        githubAccountManager.setAccounts(SetsKt.plus(githubAccountManager.getAccounts(), (Object)account));
        this.getAccountManager().updateAccountToken(account, token);
        return account;
    }

    @TestOnly
    public final void clearAccounts() {
        this.getAccountManager().setAccounts(SetsKt.emptySet());
    }

    @Nullable
    public final GithubAccount getDefaultAccount(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return ((GithubProjectDefaultAccountHolder)object).getAccount();
    }

    @TestOnly
    public final void setDefaultAccount(@NotNull Project project, @Nullable GithubAccount account) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        ((GithubProjectDefaultAccountHolder)object).setAccount(account);
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project, @Nullable Component parentComponent) {
        return this.hasAccounts() || this.requestNewAccount(project, parentComponent) != null;
    }

    public static /* synthetic */ boolean ensureHasAccounts$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAuthenticationManager.ensureHasAccounts(project, component);
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project) {
        return GithubAuthenticationManager.ensureHasAccounts$default(this, project, null, 2, null);
    }

    @Nullable
    public final GithubAccount getSingleOrDefaultAccount(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        GithubAccount githubAccount = ((GithubProjectDefaultAccountHolder)object).getAccount();
        if (githubAccount == null) {
            githubAccount = (GithubAccount)CollectionsKt.singleOrNull((Iterable)this.getAccountManager().getAccounts());
        }
        return githubAccount;
    }

    @JvmStatic
    @NotNull
    public static final GithubAuthenticationManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAuthenticationManager getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(GithubAuthenticationManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (GithubAuthenticationManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

