/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u001d\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014J1\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/UseAccessorsJavaCodeProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "factory", "Lcom/intellij/psi/PsiElementFactory;", "propertyName", "", "(Lcom/intellij/psi/PsiElementFactory;Ljava/lang/String;)V", "accessorName", "kind", "Lorg/jetbrains/kotlin/j2k/AccessorKind;", "generateGetterCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "qualifier", "Lcom/intellij/psi/PsiExpression;", "generateSetterCall", "value", "processUsage", "", "Lcom/intellij/psi/PsiReference;", "reference", "(Lcom/intellij/psi/PsiReference;)[Lcom/intellij/psi/PsiReference;", "replaceWithModificationCalls", "op", "(Lcom/intellij/psi/PsiExpression;Lcom/intellij/psi/PsiExpression;Ljava/lang/String;Lcom/intellij/psi/PsiExpression;)[Lcom/intellij/psi/PsiReference;", "kotlin.j2k.old"})
public final class UseAccessorsJavaCodeProcessor
implements ExternalCodeProcessor {
    private final PsiElementFactory factory;
    private final String propertyName;

    @Override
    @Nullable
    public PsiReference[] processUsage(@NotNull PsiReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        PsiElement psiElement = reference.getElement();
        if (!(psiElement instanceof PsiReferenceExpression)) {
            psiElement = null;
        }
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiElement;
        if (psiReferenceExpression == null) {
            return null;
        }
        PsiReferenceExpression refExpr = psiReferenceExpression;
        PsiExpression qualifier = refExpr.getQualifierExpression();
        PsiElement parent = refExpr.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            if (Intrinsics.areEqual((Object)refExpr, (Object)((PsiAssignmentExpression)parent).getLExpression())) {
                String assignmentOpText;
                if (Intrinsics.areEqual((Object)((PsiAssignmentExpression)parent).getOperationTokenType(), (Object)JavaTokenType.EQ)) {
                    PsiExpression psiExpression = ((PsiAssignmentExpression)parent).getRExpression();
                    if (psiExpression == null) {
                        return null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"parent.rExpression ?: return null");
                    PsiElement psiElement2 = parent.replace((PsiElement)this.generateSetterCall(qualifier, psiExpression));
                    if (psiElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
                    }
                    PsiMethodCallExpression callExpr = (PsiMethodCallExpression)psiElement2;
                    PsiReference[] psiReferenceArray = new PsiReference[1];
                    PsiReferenceExpression psiReferenceExpression2 = callExpr.getMethodExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression2, (String)"callExpr.methodExpression");
                    psiReferenceArray[0] = (PsiReference)psiReferenceExpression2;
                    return psiReferenceArray;
                }
                PsiJavaToken psiJavaToken = ((PsiAssignmentExpression)parent).getOperationSign();
                Intrinsics.checkNotNullExpressionValue((Object)psiJavaToken, (String)"parent.operationSign");
                String string = assignmentOpText = psiJavaToken.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"assignmentOpText");
                boolean bl = StringsKt.endsWith$default((String)string, (String)"=", (boolean)false, (int)2, null);
                boolean bl2 = false;
                int n = 0;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                String string3 = assignmentOpText;
                n = 0;
                int n2 = assignmentOpText.length() - 1;
                boolean bl4 = false;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String opText = string4;
                PsiExpression psiExpression = (PsiExpression)parent;
                PsiExpression psiExpression2 = ((PsiAssignmentExpression)parent).getRExpression();
                if (psiExpression2 == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression2, (String)"parent.rExpression ?: return null");
                return this.replaceWithModificationCalls(psiExpression, qualifier, opText, psiExpression2);
            }
        } else if (parent instanceof PsiPrefixExpression || parent instanceof PsiPostfixExpression) {
            String opText;
            PsiPrefixExpression operationType;
            PsiPrefixExpression psiPrefixExpression;
            PsiElement psiElement3 = parent;
            if (!(psiElement3 instanceof PsiPrefixExpression)) {
                psiElement3 = null;
            }
            if ((psiPrefixExpression = (PsiPrefixExpression)psiElement3) == null || (psiPrefixExpression = psiPrefixExpression.getOperationTokenType()) == null) {
                psiPrefixExpression = ((PsiPostfixExpression)parent).getOperationTokenType();
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiPrefixExpression, (String)"(parent as? PsiPrefixExp\u2026ssion).operationTokenType");
            PsiPrefixExpression psiPrefixExpression2 = operationType = psiPrefixExpression;
            String string = Intrinsics.areEqual((Object)psiPrefixExpression2, (Object)JavaTokenType.PLUSPLUS) ? "+" : (opText = Intrinsics.areEqual((Object)psiPrefixExpression2, (Object)JavaTokenType.MINUSMINUS) ? "-" : null);
            if (opText != null) {
                PsiExpression psiExpression = (PsiExpression)parent;
                PsiExpression psiExpression3 = this.factory.createExpressionFromText("1", null);
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression3, (String)"factory.createExpressionFromText(\"1\", null)");
                return this.replaceWithModificationCalls(psiExpression, qualifier, opText, psiExpression3);
            }
        }
        PsiElement psiElement4 = refExpr.replace((PsiElement)this.generateGetterCall(qualifier));
        if (psiElement4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        }
        PsiMethodCallExpression callExpr = (PsiMethodCallExpression)psiElement4;
        PsiReference[] psiReferenceArray = new PsiReference[1];
        PsiReferenceExpression psiReferenceExpression3 = callExpr.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression3, (String)"callExpr.methodExpression");
        psiReferenceArray[0] = (PsiReference)psiReferenceExpression3;
        return psiReferenceArray;
    }

    private final PsiReference[] replaceWithModificationCalls(PsiExpression $this$replaceWithModificationCalls, PsiExpression qualifier, String op, PsiExpression value2) {
        PsiMethodCallExpression getCall = this.generateGetterCall(qualifier);
        PsiExpression psiExpression = this.factory.createExpressionFromText("x " + op + " y", null);
        if (psiExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiBinaryExpression");
        }
        PsiBinaryExpression binary = (PsiBinaryExpression)psiExpression;
        binary.getLOperand().replace((PsiElement)getCall);
        PsiExpression psiExpression2 = binary.getROperand();
        Intrinsics.checkNotNull((Object)psiExpression2);
        psiExpression2.replace((PsiElement)value2);
        PsiExpression psiExpression3 = this.generateSetterCall(qualifier, (PsiExpression)binary);
        if (psiExpression3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        }
        PsiMethodCallExpression setCall = (PsiMethodCallExpression)psiExpression3;
        PsiElement psiElement = $this$replaceWithModificationCalls.replace((PsiElement)setCall);
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        }
        setCall = (PsiMethodCallExpression)psiElement;
        PsiExpressionList psiExpressionList = setCall.getArgumentList();
        Intrinsics.checkNotNullExpressionValue((Object)psiExpressionList, (String)"setCall.argumentList");
        Object[] objectArray = psiExpressionList.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"setCall.argumentList.expressions");
        Object object = ArraysKt.single((Object[])objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiBinaryExpression");
        }
        binary = (PsiBinaryExpression)object;
        PsiExpression psiExpression4 = binary.getLOperand();
        if (psiExpression4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        }
        getCall = (PsiMethodCallExpression)psiExpression4;
        PsiReference[] psiReferenceArray = new PsiReference[2];
        PsiReferenceExpression psiReferenceExpression = getCall.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"getCall.methodExpression");
        psiReferenceArray[0] = (PsiReference)psiReferenceExpression;
        PsiReferenceExpression psiReferenceExpression2 = setCall.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression2, (String)"setCall.methodExpression");
        psiReferenceArray[1] = (PsiReference)psiReferenceExpression2;
        return psiReferenceArray;
    }

    private final PsiMethodCallExpression generateGetterCall(PsiExpression qualifier) {
        String text2 = this.accessorName(AccessorKind.GETTER) + "()";
        String expressionText = qualifier != null ? qualifier.getText() + '.' + text2 : text2;
        PsiExpression psiExpression = this.factory.createExpressionFromText(expressionText, null);
        if (psiExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        }
        return (PsiMethodCallExpression)psiExpression;
    }

    private final PsiExpression generateSetterCall(PsiExpression qualifier, PsiExpression value2) {
        String text2 = this.accessorName(AccessorKind.SETTER) + "(" + value2.getText() + ")";
        String expressionText = qualifier != null ? qualifier.getText() + '.' + text2 : text2;
        PsiExpression psiExpression = this.factory.createExpressionFromText(expressionText, null);
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"factory.createExpression\u2026ext(expressionText, null)");
        return psiExpression;
    }

    private final String accessorName(AccessorKind kind2) {
        return (kind2 == AccessorKind.GETTER ? "get" : "set") + StringsKt.capitalize((String)this.propertyName);
    }

    public UseAccessorsJavaCodeProcessor(@NotNull PsiElementFactory factory, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.factory = factory;
        this.propertyName = propertyName;
    }
}

