/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features;

import com.intellij.filePrediction.FileFeaturesComputationResult;
import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.features.FilePredictionFeaturesCache;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00150\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/filePrediction/features/FilePredictionFeaturesHelper;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "getEP_NAME$intellij_filePrediction", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "calculateFileFeatures", "Lcom/intellij/filePrediction/FileFeaturesComputationResult;", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "cache", "Lcom/intellij/filePrediction/features/FilePredictionFeaturesCache;", "prevFile", "calculateProviderPrefix", "", "provider", "getFeaturesByProviders", "", "getOrderedFeatureProviders", "intellij.filePrediction"})
public final class FilePredictionFeaturesHelper {
    @NotNull
    private static final ExtensionPointName<FilePredictionFeatureProvider> EP_NAME;
    public static final FilePredictionFeaturesHelper INSTANCE;

    @NotNull
    public final ExtensionPointName<FilePredictionFeatureProvider> getEP_NAME$intellij_filePrediction() {
        return EP_NAME;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileFeaturesComputationResult calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @NotNull FilePredictionFeaturesCache cache, @Nullable VirtualFile prevFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        long start = System.currentTimeMillis();
        HashMap result2 = new HashMap();
        Iterator iterator = EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext()) {
            void $this$mapKeysTo$iv$iv;
            FilePredictionFeatureProvider provider;
            FilePredictionFeatureProvider filePredictionFeatureProvider = provider = (FilePredictionFeatureProvider)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)filePredictionFeatureProvider, (String)"provider");
            String prefix = this.calculateProviderPrefix(filePredictionFeatureProvider);
            Map<String, FilePredictionFeature> $this$mapKeys$iv = provider.calculateFileFeatures(project, newFile, prevFile, cache);
            boolean $i$f$mapKeys = false;
            Map<String, FilePredictionFeature> map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                String string = prefix + (String)it.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string2 = string;
                Map map3 = map2;
                boolean bl2 = false;
                Object v = it$iv$iv.getValue();
                map3.put(string2, v);
            }
            Map features = destination$iv$iv;
            result2.putAll(features);
        }
        return new FileFeaturesComputationResult(result2, start);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<String>> getFeaturesByProviders() {
        boolean bl = false;
        ArrayList<List> orderedFeatures = new ArrayList<List>();
        for (FilePredictionFeatureProvider provider : this.getOrderedFeatureProviders()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String prefix = this.calculateProviderPrefix(provider);
            Iterable iterable = provider.getFeatures();
            ArrayList<List> arrayList = orderedFeatures;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = prefix + (String)it;
                collection.add(string2);
            }
            collection = (List)destination$iv$iv;
            arrayList.add(CollectionsKt.toList((Iterable)collection));
        }
        return orderedFeatures;
    }

    private final List<FilePredictionFeatureProvider> getOrderedFeatureProviders() {
        List list = EP_NAME.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EP_NAME.extensionList");
        Iterable $this$sortedBy$iv = list;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                FilePredictionFeatureProvider it = (FilePredictionFeatureProvider)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (FilePredictionFeatureProvider)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
    }

    private final String calculateProviderPrefix(FilePredictionFeatureProvider provider) {
        CharSequence charSequence = provider.getName();
        boolean bl = false;
        return charSequence.length() > 0 ? provider.getName() + "_" : "";
    }

    private FilePredictionFeaturesHelper() {
    }

    static {
        FilePredictionFeaturesHelper filePredictionFeaturesHelper;
        INSTANCE = filePredictionFeaturesHelper = new FilePredictionFeaturesHelper();
        EP_NAME = new ExtensionPointName("com.intellij.filePrediction.featureProvider");
    }
}

