/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.logger;

import com.intellij.filePrediction.candidates.FilePredictionCandidateSource;
import com.intellij.filePrediction.logger.FileNavigationLogger;
import com.intellij.filePrediction.predictor.FilePredictionCompressedCandidate;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J>\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/filePrediction/logger/FileUsagePredictionLogger;", "", "logTopLimit", "", "logTotalLimit", "(II)V", "isRecentCandidate", "", "candidate", "Lcom/intellij/filePrediction/predictor/FilePredictionCompressedCandidate;", "logCandidates", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionId", "opened", "candidates", "", "total", "", "refs", "selectCandidatesToLog", "intellij.filePrediction"})
public final class FileUsagePredictionLogger {
    private final int logTopLimit;
    private final int logTotalLimit;

    public final void logCandidates(@NotNull Project project, int sessionId, @Nullable FilePredictionCompressedCandidate opened, @NotNull List<FilePredictionCompressedCandidate> candidates, long total, long refs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        List<FilePredictionCompressedCandidate> toLog = this.selectCandidatesToLog(candidates);
        FileNavigationLogger.Companion.logEvent(project, sessionId, opened, toLog, total, refs);
    }

    /*
     * WARNING - void declaration
     */
    private final List<FilePredictionCompressedCandidate> selectCandidatesToLog(List<FilePredictionCompressedCandidate> candidates) {
        void $this$filterTo$iv$iv;
        List head = CollectionsKt.take((Iterable)candidates, (int)this.logTopLimit);
        if (candidates.size() <= this.logTopLimit) {
            return head;
        }
        Iterable $this$filter$iv = head;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FilePredictionCompressedCandidate it = (FilePredictionCompressedCandidate)element$iv$iv;
            boolean bl = false;
            if (!this.isRecentCandidate(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        int numOfRecentCandidates = $this$filter$iv.size();
        $i$f$filter = false;
        List toLog = new ArrayList();
        toLog.addAll(head);
        List tail = candidates.subList(this.logTopLimit, candidates.size());
        if (numOfRecentCandidates > this.logTopLimit / 2) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = tail;
            boolean $i$f$filter2 = false;
            Iterable $i$f$filterTo2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                FilePredictionCompressedCandidate it = (FilePredictionCompressedCandidate)element$iv$iv;
                boolean bl = false;
                if (!(!this.isRecentCandidate(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            tail = (List)destination$iv$iv2;
        }
        List randomToLog = CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)tail), (int)(this.logTotalLimit - this.logTopLimit));
        toLog.addAll(randomToLog);
        return toLog;
    }

    private final boolean isRecentCandidate(FilePredictionCompressedCandidate candidate) {
        return candidate.getSource() == FilePredictionCandidateSource.OPEN || candidate.getSource() == FilePredictionCandidateSource.RECENT;
    }

    public FileUsagePredictionLogger(int logTopLimit, int logTotalLimit) {
        this.logTopLimit = logTopLimit;
        this.logTotalLimit = logTotalLimit;
    }
}

