/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.util.Arrays;
import java.util.List;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaProjectSelfProviderFactory
implements JsonSchemaProviderFactory {
    public static final int TOTAL_PROVIDERS = 3;
    private static final String SCHEMA_JSON_FILE_NAME = "schema.json";
    private static final String SCHEMA06_JSON_FILE_NAME = "schema06.json";
    private static final String SCHEMA07_JSON_FILE_NAME = "schema07.json";

    @Override
    @NotNull
    public List<JsonSchemaFileProvider> getProviders(@NotNull Project project) {
        if (project == null) {
            JsonSchemaProjectSelfProviderFactory.$$$reportNull$$$0(0);
        }
        List<JsonSchemaFileProvider> list = Arrays.asList(new MyJsonSchemaFileProvider(project, SCHEMA_JSON_FILE_NAME), new MyJsonSchemaFileProvider(project, SCHEMA06_JSON_FILE_NAME), new MyJsonSchemaFileProvider(project, SCHEMA07_JSON_FILE_NAME));
        if (list == null) {
            JsonSchemaProjectSelfProviderFactory.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MyJsonSchemaFileProvider
    implements JsonSchemaFileProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final NullableLazyValue<VirtualFile> mySchemaFile;
        @NotNull
        @Nls
        private final String myFileName;

        public boolean isSchemaV4() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA_JSON_FILE_NAME.equals(this.myFileName);
        }

        public boolean isSchemaV6() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA06_JSON_FILE_NAME.equals(this.myFileName);
        }

        public boolean isSchemaV7() {
            return JsonSchemaProjectSelfProviderFactory.SCHEMA07_JSON_FILE_NAME.equals(this.myFileName);
        }

        private MyJsonSchemaFileProvider(@NotNull Project project, @NotNull @Nls String fileName) {
            if (project == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(0);
            }
            if (fileName == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myFileName = fileName;
            this.mySchemaFile = NullableLazyValue.createValue(() -> JsonSchemaProviderFactory.getResourceFile(JsonSchemaProjectSelfProviderFactory.class, "/jsonSchema/" + fileName));
        }

        @Override
        public boolean isAvailable(@NotNull VirtualFile file) {
            if (file == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(2);
            }
            if (this.myProject.isDisposed()) {
                return false;
            }
            JsonSchemaService service = JsonSchemaService.Impl.get(this.myProject);
            if (!service.isApplicableToFile(file)) {
                return false;
            }
            JsonSchemaVersion schemaVersion = service.getSchemaVersion(file);
            if (schemaVersion == null) {
                return false;
            }
            switch (schemaVersion) {
                case SCHEMA_4: {
                    return this.isSchemaV4();
                }
                case SCHEMA_6: {
                    return this.isSchemaV6();
                }
                case SCHEMA_7: {
                    return this.isSchemaV7();
                }
            }
            throw new NotImplementedError("Unknown schema version: " + schemaVersion);
        }

        @Override
        public JsonSchemaVersion getSchemaVersion() {
            return this.isSchemaV4() ? JsonSchemaVersion.SCHEMA_4 : (this.isSchemaV7() ? JsonSchemaVersion.SCHEMA_7 : JsonSchemaVersion.SCHEMA_6);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myFileName;
            if (string == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public VirtualFile getSchemaFile() {
            return (VirtualFile)this.mySchemaFile.getValue();
        }

        @Override
        @NotNull
        public SchemaType getSchemaType() {
            SchemaType schemaType = SchemaType.schema;
            if (schemaType == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(4);
            }
            return schemaType;
        }

        @Override
        @Nullable
        public String getRemoteSource() {
            switch (this.myFileName) {
                case "schema.json": {
                    return "http://json-schema.org/draft-04/schema";
                }
                case "schema06.json": {
                    return "http://json-schema.org/draft-06/schema";
                }
                case "schema07.json": {
                    return "http://json-schema.org/draft-07/schema";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getPresentableName() {
            switch (this.myFileName) {
                case "schema.json": {
                    String string = JsonBundle.message("schema.of.version", 4);
                    if (string == null) {
                        MyJsonSchemaFileProvider.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                case "schema06.json": {
                    String string = JsonBundle.message("schema.of.version", 6);
                    if (string == null) {
                        MyJsonSchemaFileProvider.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                case "schema07.json": {
                    String string = JsonBundle.message("schema.of.version", 7);
                    if (string == null) {
                        MyJsonSchemaFileProvider.$$$reportNull$$$0(7);
                    }
                    return string;
                }
            }
            String string = this.getName();
            if (string == null) {
                MyJsonSchemaFileProvider.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaProjectSelfProviderFactory$MyJsonSchemaFileProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaType";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

