/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.stepping.DebuggerSteppingHelper;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0018\u0010\u000f\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\t\u001a\u00020\nH\u0004J \u0010\u0011\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0004\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/AbstractCoroutineBreakpointFacility;", "", "()V", "applyEmptyThreadFilter", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "installCoroutineResumedBreakpoint", "", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "location", "Lcom/sun/jdi/Location;", "method", "Lcom/sun/jdi/Method;", "setSuspendPolicy", "Lcom/intellij/debugger/ui/breakpoints/Breakpoint;", "stepOverSuspendSwitch", "action", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "kotlin.jvm-debugger.core"})
public abstract class AbstractCoroutineBreakpointFacility {
    public abstract boolean installCoroutineResumedBreakpoint(@NotNull SuspendContextImpl var1, @NotNull Location var2, @NotNull Method var3);

    protected final void setSuspendPolicy(@NotNull Breakpoint<?> $this$setSuspendPolicy, @NotNull SuspendContextImpl context) {
        String string;
        Intrinsics.checkNotNullParameter($this$setSuspendPolicy, (String)"$this$setSuspendPolicy");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        switch (context.getSuspendPolicy()) {
            case 2: {
                string = "SuspendAll";
                break;
            }
            case 1: {
                string = "SuspendThread";
                break;
            }
            case 0: {
                string = "SuspendNone";
                break;
            }
            default: {
                string = "SuspendAll";
            }
        }
        $this$setSuspendPolicy.setSuspendPolicy(string);
    }

    protected final void stepOverSuspendSwitch(@NotNull Breakpoint<?> $this$stepOverSuspendSwitch, @NotNull SuspendContextCommandImpl action2, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter($this$stepOverSuspendSwitch, (String)"$this$stepOverSuspendSwitch");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        SuspendContextImpl suspendContext = action2.getSuspendContext();
        if (suspendContext != null) {
            DebuggerSteppingHelper.createStepOverCommandForSuspendSwitch(suspendContext).contextAction(suspendContext);
        }
        debugProcess.getRequestsManager().deleteRequest((Requestor)$this$stepOverSuspendSwitch);
    }

    protected final void applyEmptyThreadFilter(@NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)debugProcess.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getIns\u2026eEx(debugProcess.project)");
        BreakpointManager breakpointManager = debuggerManagerEx.getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)breakpointManager, (String)"DebuggerManagerEx.getIns\u2026roject).breakpointManager");
        BreakpointManager breakpointManager2 = breakpointManager;
        breakpointManager2.applyThreadFilter(debugProcess, null);
    }
}

